# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.datetime_utils import serialize_datetime
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.request_options import RequestOptions
from .....core.unchecked_base_model import construct_type
from ...types.meta_response import MetaResponse
from ...types.paginated_remote_field_class_list import PaginatedRemoteFieldClassList
from ...types.paginated_ticket_list import PaginatedTicketList
from ...types.paginated_viewer_list import PaginatedViewerList
from ...types.patched_ticket_request import PatchedTicketRequest
from ...types.ticket import Ticket
from ...types.ticket_request import TicketRequest
from ...types.ticket_response import TicketResponse
from .types.tickets_list_request_expand import TicketsListRequestExpand
from .types.tickets_list_request_priority import TicketsListRequestPriority
from .types.tickets_list_request_remote_fields import TicketsListRequestRemoteFields
from .types.tickets_list_request_show_enum_origins import TicketsListRequestShowEnumOrigins
from .types.tickets_list_request_status import TicketsListRequestStatus
from .types.tickets_retrieve_request_expand import TicketsRetrieveRequestExpand
from .types.tickets_retrieve_request_remote_fields import TicketsRetrieveRequestRemoteFields
from .types.tickets_retrieve_request_show_enum_origins import TicketsRetrieveRequestShowEnumOrigins
from .types.tickets_viewers_list_request_expand import TicketsViewersListRequestExpand

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawTicketsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        account_id: typing.Optional[str] = None,
        assignee_ids: typing.Optional[str] = None,
        collection_ids: typing.Optional[str] = None,
        completed_after: typing.Optional[dt.datetime] = None,
        completed_before: typing.Optional[dt.datetime] = None,
        contact_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        creator_id: typing.Optional[str] = None,
        creator_ids: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        due_after: typing.Optional[dt.datetime] = None,
        due_before: typing.Optional[dt.datetime] = None,
        expand: typing.Optional[TicketsListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        name: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        parent_ticket_id: typing.Optional[str] = None,
        priority: typing.Optional[TicketsListRequestPriority] = None,
        remote_created_after: typing.Optional[dt.datetime] = None,
        remote_created_before: typing.Optional[dt.datetime] = None,
        remote_fields: typing.Optional[TicketsListRequestRemoteFields] = None,
        remote_id: typing.Optional[str] = None,
        remote_updated_after: typing.Optional[dt.datetime] = None,
        remote_updated_before: typing.Optional[dt.datetime] = None,
        show_enum_origins: typing.Optional[TicketsListRequestShowEnumOrigins] = None,
        status: typing.Optional[TicketsListRequestStatus] = None,
        tags: typing.Optional[str] = None,
        ticket_type: typing.Optional[str] = None,
        ticket_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedTicketList]:
        """
        Returns a list of `Ticket` objects.

        Parameters
        ----------
        account_id : typing.Optional[str]
            If provided, will only return tickets for this account.

        assignee_ids : typing.Optional[str]
            If provided, will only return tickets assigned to the assignee_ids; multiple assignee_ids can be separated by commas.

        collection_ids : typing.Optional[str]
            If provided, will only return tickets assigned to the collection_ids; multiple collection_ids can be separated by commas.

        completed_after : typing.Optional[dt.datetime]
            If provided, will only return tickets completed after this datetime.

        completed_before : typing.Optional[dt.datetime]
            If provided, will only return tickets completed before this datetime.

        contact_id : typing.Optional[str]
            If provided, will only return tickets for this contact.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        creator_id : typing.Optional[str]
            If provided, will only return tickets created by this creator_id.

        creator_ids : typing.Optional[str]
            If provided, will only return tickets created by the creator_ids; multiple creator_ids can be separated by commas.

        cursor : typing.Optional[str]
            The pagination cursor value.

        due_after : typing.Optional[dt.datetime]
            If provided, will only return tickets due after this datetime.

        due_before : typing.Optional[dt.datetime]
            If provided, will only return tickets due before this datetime.

        expand : typing.Optional[TicketsListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        name : typing.Optional[str]
            If provided, will only return tickets with this name.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        parent_ticket_id : typing.Optional[str]
            If provided, will only return sub tickets of the parent_ticket_id.

        priority : typing.Optional[TicketsListRequestPriority]
            If provided, will only return tickets of this priority.

            * `URGENT` - URGENT
            * `HIGH` - HIGH
            * `NORMAL` - NORMAL
            * `LOW` - LOW

        remote_created_after : typing.Optional[dt.datetime]
            If provided, will only return tickets created in the third party platform after this datetime.

        remote_created_before : typing.Optional[dt.datetime]
            If provided, will only return tickets created in the third party platform before this datetime.

        remote_fields : typing.Optional[TicketsListRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        remote_updated_after : typing.Optional[dt.datetime]
            If provided, will only return tickets updated in the third party platform after this datetime.

        remote_updated_before : typing.Optional[dt.datetime]
            If provided, will only return tickets updated in the third party platform before this datetime.

        show_enum_origins : typing.Optional[TicketsListRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        status : typing.Optional[TicketsListRequestStatus]
            If provided, will only return tickets of this status.

        tags : typing.Optional[str]
            If provided, will only return tickets matching the tags; multiple tags can be separated by commas.

        ticket_type : typing.Optional[str]
            If provided, will only return tickets of this type.

        ticket_url : typing.Optional[str]
            If provided, will only return tickets where the URL matches or contains the substring

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedTicketList]

        """
        _response = self._client_wrapper.httpx_client.request(
            "ticketing/v1/tickets",
            method="GET",
            params={
                "account_id": account_id,
                "assignee_ids": assignee_ids,
                "collection_ids": collection_ids,
                "completed_after": serialize_datetime(completed_after) if completed_after is not None else None,
                "completed_before": serialize_datetime(completed_before) if completed_before is not None else None,
                "contact_id": contact_id,
                "created_after": serialize_datetime(created_after) if created_after is not None else None,
                "created_before": serialize_datetime(created_before) if created_before is not None else None,
                "creator_id": creator_id,
                "creator_ids": creator_ids,
                "cursor": cursor,
                "due_after": serialize_datetime(due_after) if due_after is not None else None,
                "due_before": serialize_datetime(due_before) if due_before is not None else None,
                "expand": expand,
                "include_deleted_data": include_deleted_data,
                "include_remote_data": include_remote_data,
                "include_remote_fields": include_remote_fields,
                "include_shell_data": include_shell_data,
                "modified_after": serialize_datetime(modified_after) if modified_after is not None else None,
                "modified_before": serialize_datetime(modified_before) if modified_before is not None else None,
                "name": name,
                "page_size": page_size,
                "parent_ticket_id": parent_ticket_id,
                "priority": priority,
                "remote_created_after": serialize_datetime(remote_created_after)
                if remote_created_after is not None
                else None,
                "remote_created_before": serialize_datetime(remote_created_before)
                if remote_created_before is not None
                else None,
                "remote_fields": remote_fields,
                "remote_id": remote_id,
                "remote_updated_after": serialize_datetime(remote_updated_after)
                if remote_updated_after is not None
                else None,
                "remote_updated_before": serialize_datetime(remote_updated_before)
                if remote_updated_before is not None
                else None,
                "show_enum_origins": show_enum_origins,
                "status": status,
                "tags": tags,
                "ticket_type": ticket_type,
                "ticket_url": ticket_url,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedTicketList,
                    construct_type(
                        type_=PaginatedTicketList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        model: TicketRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TicketResponse]:
        """
        Creates a `Ticket` object with the given values.

        Parameters
        ----------
        model : TicketRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TicketResponse]

        """
        _response = self._client_wrapper.httpx_client.request(
            "ticketing/v1/tickets",
            method="POST",
            params={
                "is_debug_mode": is_debug_mode,
                "run_async": run_async,
            },
            json={
                "model": model,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TicketResponse,
                    construct_type(
                        type_=TicketResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[TicketsRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        remote_fields: typing.Optional[TicketsRetrieveRequestRemoteFields] = None,
        show_enum_origins: typing.Optional[TicketsRetrieveRequestShowEnumOrigins] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Ticket]:
        """
        Returns a `Ticket` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[TicketsRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        remote_fields : typing.Optional[TicketsRetrieveRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        show_enum_origins : typing.Optional[TicketsRetrieveRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Ticket]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"ticketing/v1/tickets/{jsonable_encoder(id)}",
            method="GET",
            params={
                "expand": expand,
                "include_remote_data": include_remote_data,
                "include_remote_fields": include_remote_fields,
                "include_shell_data": include_shell_data,
                "remote_fields": remote_fields,
                "show_enum_origins": show_enum_origins,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Ticket,
                    construct_type(
                        type_=Ticket,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def partial_update(
        self,
        id: str,
        *,
        model: PatchedTicketRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TicketResponse]:
        """
        Updates a `Ticket` object with the given `id`.

        Parameters
        ----------
        id : str

        model : PatchedTicketRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TicketResponse]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"ticketing/v1/tickets/{jsonable_encoder(id)}",
            method="PATCH",
            params={
                "is_debug_mode": is_debug_mode,
                "run_async": run_async,
            },
            json={
                "model": model,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TicketResponse,
                    construct_type(
                        type_=TicketResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def viewers_list(
        self,
        ticket_id: str,
        *,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[TicketsViewersListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedViewerList]:
        """
        Returns a list of `Viewer` objects that point to a User id or Team id that is either an assignee or viewer on a `Ticket` with the given id. [Learn more.](https://help.merge.dev/en/articles/10333658-ticketing-access-control-list-acls)

        Parameters
        ----------
        ticket_id : str

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[TicketsViewersListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedViewerList]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"ticketing/v1/tickets/{jsonable_encoder(ticket_id)}/viewers",
            method="GET",
            params={
                "cursor": cursor,
                "expand": expand,
                "include_deleted_data": include_deleted_data,
                "include_remote_data": include_remote_data,
                "include_shell_data": include_shell_data,
                "page_size": page_size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedViewerList,
                    construct_type(
                        type_=PaginatedViewerList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def meta_patch_retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[MetaResponse]:
        """
        Returns metadata for `Ticket` PATCHs.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MetaResponse]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"ticketing/v1/tickets/meta/patch/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetaResponse,
                    construct_type(
                        type_=MetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def meta_post_retrieve(
        self,
        *,
        collection_id: typing.Optional[str] = None,
        ticket_type: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[MetaResponse]:
        """
        Returns metadata for `Ticket` POSTs.

        Parameters
        ----------
        collection_id : typing.Optional[str]
            If provided, will only return tickets for this collection.

        ticket_type : typing.Optional[str]
            If provided, will only return tickets for this ticket type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MetaResponse]

        """
        _response = self._client_wrapper.httpx_client.request(
            "ticketing/v1/tickets/meta/post",
            method="GET",
            params={
                "collection_id": collection_id,
                "ticket_type": ticket_type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetaResponse,
                    construct_type(
                        type_=MetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def remote_field_classes_list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        ids: typing.Optional[str] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        is_common_model_field: typing.Optional[bool] = None,
        is_custom: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedRemoteFieldClassList]:
        """
        Returns a list of `RemoteFieldClass` objects.

        Parameters
        ----------
        cursor : typing.Optional[str]
            The pagination cursor value.

        ids : typing.Optional[str]
            If provided, will only return remote field classes with the `ids` in this list

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        is_common_model_field : typing.Optional[bool]
            If provided, will only return remote field classes with this is_common_model_field value

        is_custom : typing.Optional[bool]
            If provided, will only return remote fields classes with this is_custom value

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedRemoteFieldClassList]

        """
        _response = self._client_wrapper.httpx_client.request(
            "ticketing/v1/tickets/remote-field-classes",
            method="GET",
            params={
                "cursor": cursor,
                "ids": ids,
                "include_deleted_data": include_deleted_data,
                "include_remote_data": include_remote_data,
                "include_shell_data": include_shell_data,
                "is_common_model_field": is_common_model_field,
                "is_custom": is_custom,
                "page_size": page_size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedRemoteFieldClassList,
                    construct_type(
                        type_=PaginatedRemoteFieldClassList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawTicketsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        account_id: typing.Optional[str] = None,
        assignee_ids: typing.Optional[str] = None,
        collection_ids: typing.Optional[str] = None,
        completed_after: typing.Optional[dt.datetime] = None,
        completed_before: typing.Optional[dt.datetime] = None,
        contact_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        creator_id: typing.Optional[str] = None,
        creator_ids: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        due_after: typing.Optional[dt.datetime] = None,
        due_before: typing.Optional[dt.datetime] = None,
        expand: typing.Optional[TicketsListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        name: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        parent_ticket_id: typing.Optional[str] = None,
        priority: typing.Optional[TicketsListRequestPriority] = None,
        remote_created_after: typing.Optional[dt.datetime] = None,
        remote_created_before: typing.Optional[dt.datetime] = None,
        remote_fields: typing.Optional[TicketsListRequestRemoteFields] = None,
        remote_id: typing.Optional[str] = None,
        remote_updated_after: typing.Optional[dt.datetime] = None,
        remote_updated_before: typing.Optional[dt.datetime] = None,
        show_enum_origins: typing.Optional[TicketsListRequestShowEnumOrigins] = None,
        status: typing.Optional[TicketsListRequestStatus] = None,
        tags: typing.Optional[str] = None,
        ticket_type: typing.Optional[str] = None,
        ticket_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedTicketList]:
        """
        Returns a list of `Ticket` objects.

        Parameters
        ----------
        account_id : typing.Optional[str]
            If provided, will only return tickets for this account.

        assignee_ids : typing.Optional[str]
            If provided, will only return tickets assigned to the assignee_ids; multiple assignee_ids can be separated by commas.

        collection_ids : typing.Optional[str]
            If provided, will only return tickets assigned to the collection_ids; multiple collection_ids can be separated by commas.

        completed_after : typing.Optional[dt.datetime]
            If provided, will only return tickets completed after this datetime.

        completed_before : typing.Optional[dt.datetime]
            If provided, will only return tickets completed before this datetime.

        contact_id : typing.Optional[str]
            If provided, will only return tickets for this contact.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        creator_id : typing.Optional[str]
            If provided, will only return tickets created by this creator_id.

        creator_ids : typing.Optional[str]
            If provided, will only return tickets created by the creator_ids; multiple creator_ids can be separated by commas.

        cursor : typing.Optional[str]
            The pagination cursor value.

        due_after : typing.Optional[dt.datetime]
            If provided, will only return tickets due after this datetime.

        due_before : typing.Optional[dt.datetime]
            If provided, will only return tickets due before this datetime.

        expand : typing.Optional[TicketsListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        name : typing.Optional[str]
            If provided, will only return tickets with this name.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        parent_ticket_id : typing.Optional[str]
            If provided, will only return sub tickets of the parent_ticket_id.

        priority : typing.Optional[TicketsListRequestPriority]
            If provided, will only return tickets of this priority.

            * `URGENT` - URGENT
            * `HIGH` - HIGH
            * `NORMAL` - NORMAL
            * `LOW` - LOW

        remote_created_after : typing.Optional[dt.datetime]
            If provided, will only return tickets created in the third party platform after this datetime.

        remote_created_before : typing.Optional[dt.datetime]
            If provided, will only return tickets created in the third party platform before this datetime.

        remote_fields : typing.Optional[TicketsListRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        remote_updated_after : typing.Optional[dt.datetime]
            If provided, will only return tickets updated in the third party platform after this datetime.

        remote_updated_before : typing.Optional[dt.datetime]
            If provided, will only return tickets updated in the third party platform before this datetime.

        show_enum_origins : typing.Optional[TicketsListRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        status : typing.Optional[TicketsListRequestStatus]
            If provided, will only return tickets of this status.

        tags : typing.Optional[str]
            If provided, will only return tickets matching the tags; multiple tags can be separated by commas.

        ticket_type : typing.Optional[str]
            If provided, will only return tickets of this type.

        ticket_url : typing.Optional[str]
            If provided, will only return tickets where the URL matches or contains the substring

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedTicketList]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "ticketing/v1/tickets",
            method="GET",
            params={
                "account_id": account_id,
                "assignee_ids": assignee_ids,
                "collection_ids": collection_ids,
                "completed_after": serialize_datetime(completed_after) if completed_after is not None else None,
                "completed_before": serialize_datetime(completed_before) if completed_before is not None else None,
                "contact_id": contact_id,
                "created_after": serialize_datetime(created_after) if created_after is not None else None,
                "created_before": serialize_datetime(created_before) if created_before is not None else None,
                "creator_id": creator_id,
                "creator_ids": creator_ids,
                "cursor": cursor,
                "due_after": serialize_datetime(due_after) if due_after is not None else None,
                "due_before": serialize_datetime(due_before) if due_before is not None else None,
                "expand": expand,
                "include_deleted_data": include_deleted_data,
                "include_remote_data": include_remote_data,
                "include_remote_fields": include_remote_fields,
                "include_shell_data": include_shell_data,
                "modified_after": serialize_datetime(modified_after) if modified_after is not None else None,
                "modified_before": serialize_datetime(modified_before) if modified_before is not None else None,
                "name": name,
                "page_size": page_size,
                "parent_ticket_id": parent_ticket_id,
                "priority": priority,
                "remote_created_after": serialize_datetime(remote_created_after)
                if remote_created_after is not None
                else None,
                "remote_created_before": serialize_datetime(remote_created_before)
                if remote_created_before is not None
                else None,
                "remote_fields": remote_fields,
                "remote_id": remote_id,
                "remote_updated_after": serialize_datetime(remote_updated_after)
                if remote_updated_after is not None
                else None,
                "remote_updated_before": serialize_datetime(remote_updated_before)
                if remote_updated_before is not None
                else None,
                "show_enum_origins": show_enum_origins,
                "status": status,
                "tags": tags,
                "ticket_type": ticket_type,
                "ticket_url": ticket_url,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedTicketList,
                    construct_type(
                        type_=PaginatedTicketList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        model: TicketRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TicketResponse]:
        """
        Creates a `Ticket` object with the given values.

        Parameters
        ----------
        model : TicketRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TicketResponse]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "ticketing/v1/tickets",
            method="POST",
            params={
                "is_debug_mode": is_debug_mode,
                "run_async": run_async,
            },
            json={
                "model": model,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TicketResponse,
                    construct_type(
                        type_=TicketResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[TicketsRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        remote_fields: typing.Optional[TicketsRetrieveRequestRemoteFields] = None,
        show_enum_origins: typing.Optional[TicketsRetrieveRequestShowEnumOrigins] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Ticket]:
        """
        Returns a `Ticket` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[TicketsRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        remote_fields : typing.Optional[TicketsRetrieveRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        show_enum_origins : typing.Optional[TicketsRetrieveRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Ticket]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ticketing/v1/tickets/{jsonable_encoder(id)}",
            method="GET",
            params={
                "expand": expand,
                "include_remote_data": include_remote_data,
                "include_remote_fields": include_remote_fields,
                "include_shell_data": include_shell_data,
                "remote_fields": remote_fields,
                "show_enum_origins": show_enum_origins,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Ticket,
                    construct_type(
                        type_=Ticket,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def partial_update(
        self,
        id: str,
        *,
        model: PatchedTicketRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TicketResponse]:
        """
        Updates a `Ticket` object with the given `id`.

        Parameters
        ----------
        id : str

        model : PatchedTicketRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TicketResponse]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ticketing/v1/tickets/{jsonable_encoder(id)}",
            method="PATCH",
            params={
                "is_debug_mode": is_debug_mode,
                "run_async": run_async,
            },
            json={
                "model": model,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TicketResponse,
                    construct_type(
                        type_=TicketResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def viewers_list(
        self,
        ticket_id: str,
        *,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[TicketsViewersListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedViewerList]:
        """
        Returns a list of `Viewer` objects that point to a User id or Team id that is either an assignee or viewer on a `Ticket` with the given id. [Learn more.](https://help.merge.dev/en/articles/10333658-ticketing-access-control-list-acls)

        Parameters
        ----------
        ticket_id : str

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[TicketsViewersListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedViewerList]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ticketing/v1/tickets/{jsonable_encoder(ticket_id)}/viewers",
            method="GET",
            params={
                "cursor": cursor,
                "expand": expand,
                "include_deleted_data": include_deleted_data,
                "include_remote_data": include_remote_data,
                "include_shell_data": include_shell_data,
                "page_size": page_size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedViewerList,
                    construct_type(
                        type_=PaginatedViewerList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def meta_patch_retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[MetaResponse]:
        """
        Returns metadata for `Ticket` PATCHs.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MetaResponse]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ticketing/v1/tickets/meta/patch/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetaResponse,
                    construct_type(
                        type_=MetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def meta_post_retrieve(
        self,
        *,
        collection_id: typing.Optional[str] = None,
        ticket_type: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[MetaResponse]:
        """
        Returns metadata for `Ticket` POSTs.

        Parameters
        ----------
        collection_id : typing.Optional[str]
            If provided, will only return tickets for this collection.

        ticket_type : typing.Optional[str]
            If provided, will only return tickets for this ticket type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MetaResponse]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "ticketing/v1/tickets/meta/post",
            method="GET",
            params={
                "collection_id": collection_id,
                "ticket_type": ticket_type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetaResponse,
                    construct_type(
                        type_=MetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def remote_field_classes_list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        ids: typing.Optional[str] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        is_common_model_field: typing.Optional[bool] = None,
        is_custom: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedRemoteFieldClassList]:
        """
        Returns a list of `RemoteFieldClass` objects.

        Parameters
        ----------
        cursor : typing.Optional[str]
            The pagination cursor value.

        ids : typing.Optional[str]
            If provided, will only return remote field classes with the `ids` in this list

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        is_common_model_field : typing.Optional[bool]
            If provided, will only return remote field classes with this is_common_model_field value

        is_custom : typing.Optional[bool]
            If provided, will only return remote fields classes with this is_custom value

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedRemoteFieldClassList]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "ticketing/v1/tickets/remote-field-classes",
            method="GET",
            params={
                "cursor": cursor,
                "ids": ids,
                "include_deleted_data": include_deleted_data,
                "include_remote_data": include_remote_data,
                "include_shell_data": include_shell_data,
                "is_common_model_field": is_common_model_field,
                "is_custom": is_custom,
                "page_size": page_size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedRemoteFieldClassList,
                    construct_type(
                        type_=PaginatedRemoteFieldClassList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
