# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .attachment_request_ticket import AttachmentRequestTicket


class AttachmentRequest(UncheckedBaseModel):
    """
    # The Attachment Object
    ### Description
    The `Attachment` object is used to represent an attachment for a ticket.

    ### Usage Example
    TODO
    """

    file_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The attachment's name. It is required to include the file extension in the attachment's name.
    """

    ticket: typing.Optional[AttachmentRequestTicket] = pydantic.Field(default=None)
    """
    The ticket associated with the attachment.
    """

    file_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The attachment's url. It is required to include the file extension in the file's URL.
    """

    content_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The attachment's file format.
    """

    uploaded_by: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user who uploaded the attachment.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .attachment import Attachment  # noqa: E402, F401, I001
from .collection import Collection  # noqa: E402, F401, I001
from .ticket import Ticket  # noqa: E402, F401, I001

update_forward_refs(AttachmentRequest)
