# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .collection_access_level import CollectionAccessLevel
from .collection_collection_type import CollectionCollectionType
from .remote_data import RemoteData


class Collection(UncheckedBaseModel):
    """
    # The Collection Object
    ### Description
    The `Collection` object is used to represent one or more `Tickets`. There can be a hierarchy of `Collections`, in which a sub-collection belongs to a parent-collection.

    ### Usage Example
    TODO
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The collection's name.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The collection's description.
    """

    access_level: typing.Optional[CollectionAccessLevel] = pydantic.Field(default=None)
    """
    The level of access a User has to the Collection and its sub-objects.
    
    * `PRIVATE` - PRIVATE
    * `COMPANY` - COMPANY
    * `PUBLIC` - PUBLIC
    * `PARENT_COLLECTION` - PARENT_COLLECTION
    """

    collection_type: typing.Optional[CollectionCollectionType] = pydantic.Field(default=None)
    """
    The collection's type.
    
    * `LIST` - LIST
    * `PROJECT` - PROJECT
    """

    parent_collection: typing.Optional["CollectionParentCollection"] = pydantic.Field(default=None)
    """
    The parent collection for this collection.
    """

    collection_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The 3rd party url of the Collection.
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's collection was created.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's collection was updated.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .collection_parent_collection import CollectionParentCollection  # noqa: E402, F401, I001

update_forward_refs(Collection)
