# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .viewer_team import ViewerTeam
from .viewer_user import ViewerUser


class Viewer(UncheckedBaseModel):
    """
    # The Viewer Object
    ### Description
    The `Viewer` object is used to represent a User or Team within a company.

    ### Usage Example
    TODO
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    team: typing.Optional[ViewerTeam] = pydantic.Field(default=None)
    """
    The Team this Viewer belongs to.
    """

    user: typing.Optional[ViewerUser] = pydantic.Field(default=None)
    """
    The User this Viewer belongs to.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
