"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WindowsEKSCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class WindowsEKSCluster extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        props.eksSsmParameters = props.eksSsmParameters ?? {};
        props.eksSsmParameters.clusterNamePointer =
            props.eksSsmParameters.clusterNamePointer ?? 'windows-eks-cluster-name';
        if (props.eksSsmParameters.namespace) {
            props.eksSsmParameters.namespace = `${props.eksSsmParameters.namespace}/compute/eks`;
        }
        else {
            props.eksSsmParameters.namespace = 'cdk-skylight/compute/eks';
        }
        const eks_role = new aws_cdk_lib_1.aws_iam.Role(this, 'eks-instance-role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('ec2.amazonaws.com'),
            roleName: 'eks-node-role' + id,
            managedPolicies: [
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKSWorkerNodePolicy'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEC2ContainerRegistryReadOnly'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKS_CNI_Policy'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMDirectoryServiceAccess'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AWSKeyManagementServicePowerUser'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKSClusterPolicy'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKSVPCResourceController'),
            ],
        });
        this.eksCluster = new aws_cdk_lib_1.aws_eks.Cluster(this, 'WindowsEKSCluster', {
            version: aws_cdk_lib_1.aws_eks.KubernetesVersion.V1_21,
            vpc: props.vpc,
        });
        this.eksCluster.awsAuth.addRoleMapping(eks_role, {
            groups: ['system:bootstrappers', 'system:nodes'],
            username: 'system:node:{{EC2PrivateDNSName}}',
        });
        // https://docs.aws.amazon.com/eks/latest/userguide/windows-support.html#enable-windows-support
        const yaml_file = {
            apiVersion: 'v1',
            kind: 'ConfigMap',
            metadata: {
                name: 'amazon-vpc-cni',
                namespace: 'kube-system',
            },
            data: {
                'enable-windows-ipam': 'true',
            },
        };
        this.eksCluster.addManifest('WindowsSupport', yaml_file);
        new aws_cdk_lib_1.aws_ssm.StringParameter(this, 'clusterNamePointer', {
            parameterName: `/${props.eksSsmParameters.namespace}/${props.eksSsmParameters.clusterNamePointer}`,
            stringValue: this.eksCluster.clusterName,
        });
    }
}
exports.WindowsEKSCluster = WindowsEKSCluster;
_a = JSII_RTTI_SYMBOL_1;
WindowsEKSCluster[_a] = { fqn: "cdk-skylight.compute.WindowsEKSCluster", version: "1.1.869" };
//# sourceMappingURL=data:application/json;base64,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