# 🌀 bluer-ai

🌀 `bluer-ai` is an implementation of 🔻 [giza](https://github.com/kamangir/giza) and a language [to speak AI](https://github.com/kamangir/bluer-south).

![image](https://github.com/kamangir/assets/blob/main/awesome-bash-cli/marquee-2024-10-26.jpg?raw=true)

# installation

```bash
pip install bluer_ai
```

Add to `bashrc`, `.bash_profile`, or the relevant startup file.

```bash
source $(python3 -m bluer_ai locate)/.abcli/bluer_ai.sh
```

# dev install

- [Amazon EC2 instances](./bluer_ai/docs/install/ec2.md)
- [Amazon SageMaker](./bluer_ai/docs/install/SageMaker.md)
- [Jetson Nano](./bluer_ai/docs/install/Jetson-Nano.md)
- [macOS](./bluer_ai/docs/install/macOS.md)
- [Raspberry Pi](./bluer_ai/docs/install/RPi.md)
- [Raspberry Pi + ROS](./bluer_ai/docs/install/RPi-ROS.md)


# aliases

[@conda](./bluer_ai/docs/aliases/conda.md), 
[@git](./bluer_ai/docs/aliases/git.md), 
[@gpu](./bluer_ai/docs/aliases/gpu.md), 
[@init](./bluer_ai/docs/aliases/init.md), 
[@latex](./bluer_ai/docs/aliases/latex.md), 
[@logging](./bluer_ai/docs/aliases/logging.md), 
[@pypi](./bluer_ai/docs/aliases/pypi.md), 
[@screen](./bluer_ai/docs/aliases/screen.md), 
[@seed](./bluer_ai/docs/aliases/seed.md) 🌱, 
[@ssh](./bluer_ai/docs/aliases/ssh.md), 
[@terraform](./bluer_ai/docs/aliases/terraform.md), 
[@wifi](./bluer_ai/docs/aliases/wifi.md).

[@options](https://github.com/kamangir/bluer-options): 
[@assert](./bluer_ai/docs/aliases/assert.md), 
[@badge](./bluer_ai/docs/aliases/badge.md), 
[@browse](./bluer_ai/docs/aliases/browse.md), 
[@cat](./bluer_ai/docs/aliases/cat.md), 
[@code](./bluer_ai/docs/aliases/code.md), 
[@env](./bluer_ai/docs/aliases/env.md), 
[@eval](./bluer_ai/docs/aliases/eval.md), 
[@help](./bluer_ai/docs/aliases/help.md), 
[@hr](./bluer_ai/docs/aliases/hr.md), 
[@list](./bluer_ai/docs/aliases/list.md), 
[@not](./bluer_ai/docs/aliases/not.md), 
[@open](./bluer_ai/docs/aliases/open.md), 
[@option](./bluer_ai/docs/aliases/option.md), 
[@pause](./bluer_ai/docs/aliases/pause.md), 
[@pylint](./bluer_ai/docs/aliases/pylint.md), 
[@pytest](./bluer_ai/docs/aliases/pytest.md), 
[@repeat](./bluer_ai/docs/aliases/repeat.md), 
[@sleep](./bluer_ai/docs/aliases/sleep.md), 
[@test](./bluer_ai/docs/aliases/test.md), 
[@timestamp](./bluer_ai/docs/aliases/timestamp.md), 
[@wait](./bluer_ai/docs/aliases/wait.md), 
[@watch](./bluer_ai/docs/aliases/watch.md).

[@objects](https://github.com/kamangir/bluer-objects): 
[@select](./bluer_ai/docs/aliases/select.md), 
[@storage](./bluer_ai/docs/aliases/storage.md).

---

> 🪄 [`abcli`](https://github.com/kamangir/awesome-bash-cli) for the [Global South](https://github.com/kamangir/bluer-south).

---


[![pylint](https://github.com/kamangir/bluer-ai/actions/workflows/pylint.yml/badge.svg)](https://github.com/kamangir/bluer-ai/actions/workflows/pylint.yml) [![pytest](https://github.com/kamangir/bluer-ai/actions/workflows/pytest.yml/badge.svg)](https://github.com/kamangir/bluer-ai/actions/workflows/pytest.yml) [![bashtest](https://github.com/kamangir/bluer-ai/actions/workflows/bashtest.yml/badge.svg)](https://github.com/kamangir/bluer-ai/actions/workflows/bashtest.yml) [![PyPI version](https://img.shields.io/pypi/v/bluer_ai.svg)](https://pypi.org/project/bluer_ai/) [![PyPI - Downloads](https://img.shields.io/pypi/dd/bluer_ai)](https://pypistats.org/packages/bluer_ai)

built by 🌀 [`bluer README`](https://github.com/kamangir/bluer-objects/tree/main/bluer_objects/README), based on 🌀 [`bluer_ai-12.271.1`](https://github.com/kamangir/bluer-ai).
