<p align="center">
    <img
        src="https://github.com/xonq/mycotools/blob/master/misc/pictogo.white.png"
    >
</p>
<br /><br />

# PURPOSE
Bring broadscale comparative genomics to the masses. Taxonomy-agnostic, with
automated data acquisition operational with
prokaryote, animal, plant, and fungal genome data.

Mycotools is a compilation of computational biology tools and database
([MycotoolsDB/MTDB](https://github.com/xonq/mycotools/wiki/MycotoolsDB)) software
that facilitate large-scale comparative genomics. MycotoolsDB dereplicates and locally
assimilates NCBI and MycoCosm (Joint Genome Institute) genomes into a database schema with uniform file curation, scalability, and automation as guiding principles. 

- Database initialization: `mtdb u --init <DIR>`
- Database updating: `mtdb u --update`
- The MycotoolsDB (MTDB) uniformly curates GenBank/MycoCosm and local `gff` formats into a consistent standard
- The `.mtdb` database format is a uniform input for analyses with 100,000s to as few as a single genome
- Mycotools [software suite](https://github.com/xonq/mycotools/wiki/Usage) includes modules to automate routine-complex
  comparative genomics, such as phylogenetic analysis

<p align="center">
    <img
        src="https://github.com/xonq/mycotools/blob/master/misc/mtdb.png"
    >
</p>

<br />

# INSTALL

Please review the [wiki](https://github.com/xonq/mycotools/wiki/Install) for installation and usage information!

<br />

# CITING

If Mycotools contribute to your analysis, please cite the preprint and mention
the version in-line. 

Konkel, Z., Slot, J. C. Mycotools: An Automated and Scalable Platform for
Comparative Genomics. bioRxiv 2023.09.08.556886; doi: https://doi.org/10.1101/2023.09.08.556886

---


