# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from revengai.models.app_api_rest_v2_analyses_responses_tag_item import AppApiRestV2AnalysesResponsesTagItem
from typing import Optional, Set
from typing_extensions import Self

class AnalysisTags(BaseModel):
    """
    AnalysisTags
    """ # noqa: E501
    analysis_tags: List[AppApiRestV2AnalysesResponsesTagItem]
    suggested_tags: List[AppApiRestV2AnalysesResponsesTagItem]
    __properties: ClassVar[List[str]] = ["analysis_tags", "suggested_tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnalysisTags from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in analysis_tags (list)
        _items = []
        if self.analysis_tags:
            for _item_analysis_tags in self.analysis_tags:
                if _item_analysis_tags:
                    _items.append(_item_analysis_tags.to_dict())
            _dict['analysis_tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in suggested_tags (list)
        _items = []
        if self.suggested_tags:
            for _item_suggested_tags in self.suggested_tags:
                if _item_suggested_tags:
                    _items.append(_item_suggested_tags.to_dict())
            _dict['suggested_tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnalysisTags from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "analysis_tags": [AppApiRestV2AnalysesResponsesTagItem.from_dict(_item) for _item in obj["analysis_tags"]] if obj.get("analysis_tags") is not None else None,
            "suggested_tags": [AppApiRestV2AnalysesResponsesTagItem.from_dict(_item) for _item in obj["suggested_tags"]] if obj.get("suggested_tags") is not None else None
        })
        return _obj


