# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Basic(BaseModel):
    """
    Basic
    """ # noqa: E501
    binary_name: StrictStr = Field(description="The name of the binary uploaded")
    binary_size: StrictInt = Field(description="The size of the binary uploaded (bytes)")
    creation: datetime = Field(description="When the binary was uploaded")
    sha_256_hash: StrictStr = Field(description="The hash of the binary uploaded")
    model_name: StrictStr = Field(description="The model name used for analysis")
    model_id: StrictInt = Field(description="The model ID used for analysis")
    owner_username: StrictStr = Field(description="The name of the owner of the binary")
    analysis_scope: StrictStr = Field(description="The scope of the analysis")
    is_owner: StrictBool = Field(description="Whether the current user is the owner")
    debug: StrictBool = Field(description="Whether the current analysis was analysed with debug symbols")
    function_count: StrictInt = Field(description="The number of functions in the binary")
    is_advanced: StrictBool = Field(description="Whether the analysis was advanced")
    base_address: Optional[StrictInt]
    __properties: ClassVar[List[str]] = ["binary_name", "binary_size", "creation", "sha_256_hash", "model_name", "model_id", "owner_username", "analysis_scope", "is_owner", "debug", "function_count", "is_advanced", "base_address"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Basic from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if base_address (nullable) is None
        # and model_fields_set contains the field
        if self.base_address is None and "base_address" in self.model_fields_set:
            _dict['base_address'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Basic from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "binary_name": obj.get("binary_name"),
            "binary_size": obj.get("binary_size"),
            "creation": obj.get("creation"),
            "sha_256_hash": obj.get("sha_256_hash"),
            "model_name": obj.get("model_name"),
            "model_id": obj.get("model_id"),
            "owner_username": obj.get("owner_username"),
            "analysis_scope": obj.get("analysis_scope"),
            "is_owner": obj.get("is_owner"),
            "debug": obj.get("debug"),
            "function_count": obj.get("function_count"),
            "is_advanced": obj.get("is_advanced"),
            "base_address": obj.get("base_address")
        })
        return _obj


