# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.collection_scope import CollectionScope
from typing import Optional, Set
from typing_extensions import Self

class CollectionCreateRequest(BaseModel):
    """
    CollectionCreateRequest
    """ # noqa: E501
    collection_name: StrictStr
    description: StrictStr
    collection_scope: Optional[CollectionScope] = None
    tags: Optional[List[StrictStr]] = None
    binaries: Optional[List[StrictInt]] = None
    model_id: StrictInt
    __properties: ClassVar[List[str]] = ["collection_name", "description", "collection_scope", "tags", "binaries", "model_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CollectionCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if binaries (nullable) is None
        # and model_fields_set contains the field
        if self.binaries is None and "binaries" in self.model_fields_set:
            _dict['binaries'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CollectionCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "collection_name": obj.get("collection_name"),
            "description": obj.get("description"),
            "collection_scope": obj.get("collection_scope"),
            "tags": obj.get("tags"),
            "binaries": obj.get("binaries"),
            "model_id": obj.get("model_id")
        })
        return _obj


