# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FileHashes(BaseModel):
    """
    FileHashes
    """ # noqa: E501
    md5: Optional[StrictStr]
    sha1: Optional[StrictStr]
    sha256: Optional[StrictStr]
    sha512: Optional[StrictStr]
    sha3_224: Optional[StrictStr]
    sha3_256: Optional[StrictStr]
    sha3_384: Optional[StrictStr]
    sha3_512: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["md5", "sha1", "sha256", "sha512", "sha3_224", "sha3_256", "sha3_384", "sha3_512"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FileHashes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if md5 (nullable) is None
        # and model_fields_set contains the field
        if self.md5 is None and "md5" in self.model_fields_set:
            _dict['md5'] = None

        # set to None if sha1 (nullable) is None
        # and model_fields_set contains the field
        if self.sha1 is None and "sha1" in self.model_fields_set:
            _dict['sha1'] = None

        # set to None if sha256 (nullable) is None
        # and model_fields_set contains the field
        if self.sha256 is None and "sha256" in self.model_fields_set:
            _dict['sha256'] = None

        # set to None if sha512 (nullable) is None
        # and model_fields_set contains the field
        if self.sha512 is None and "sha512" in self.model_fields_set:
            _dict['sha512'] = None

        # set to None if sha3_224 (nullable) is None
        # and model_fields_set contains the field
        if self.sha3_224 is None and "sha3_224" in self.model_fields_set:
            _dict['sha3_224'] = None

        # set to None if sha3_256 (nullable) is None
        # and model_fields_set contains the field
        if self.sha3_256 is None and "sha3_256" in self.model_fields_set:
            _dict['sha3_256'] = None

        # set to None if sha3_384 (nullable) is None
        # and model_fields_set contains the field
        if self.sha3_384 is None and "sha3_384" in self.model_fields_set:
            _dict['sha3_384'] = None

        # set to None if sha3_512 (nullable) is None
        # and model_fields_set contains the field
        if self.sha3_512 is None and "sha3_512" in self.model_fields_set:
            _dict['sha3_512'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FileHashes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "md5": obj.get("md5"),
            "sha1": obj.get("sha1"),
            "sha256": obj.get("sha256"),
            "sha512": obj.get("sha512"),
            "sha3_224": obj.get("sha3_224"),
            "sha3_256": obj.get("sha3_256"),
            "sha3_384": obj.get("sha3_384"),
            "sha3_512": obj.get("sha3_512")
        })
        return _obj


