# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.function_matching_result_with_best_match import FunctionMatchingResultWithBestMatch
from typing import Optional, Set
from typing_extensions import Self

class FunctionMatchingBatchResponse(BaseModel):
    """
    FunctionMatchingBatchResponse
    """ # noqa: E501
    progress: Optional[StrictInt] = Field(default=0, description="Progress of the matching operation, represented as a percentage")
    status: Optional[StrictStr] = None
    total_time: Optional[StrictInt] = None
    error_message: Optional[StrictStr] = None
    current_page: Optional[StrictInt] = None
    total_pages: Optional[StrictInt] = None
    matches: Optional[List[FunctionMatchingResultWithBestMatch]] = None
    __properties: ClassVar[List[str]] = ["progress", "status", "total_time", "error_message", "current_page", "total_pages", "matches"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionMatchingBatchResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in matches (list)
        _items = []
        if self.matches:
            for _item_matches in self.matches:
                if _item_matches:
                    _items.append(_item_matches.to_dict())
            _dict['matches'] = _items
        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if total_time (nullable) is None
        # and model_fields_set contains the field
        if self.total_time is None and "total_time" in self.model_fields_set:
            _dict['total_time'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['error_message'] = None

        # set to None if current_page (nullable) is None
        # and model_fields_set contains the field
        if self.current_page is None and "current_page" in self.model_fields_set:
            _dict['current_page'] = None

        # set to None if total_pages (nullable) is None
        # and model_fields_set contains the field
        if self.total_pages is None and "total_pages" in self.model_fields_set:
            _dict['total_pages'] = None

        # set to None if matches (nullable) is None
        # and model_fields_set contains the field
        if self.matches is None and "matches" in self.model_fields_set:
            _dict['matches'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionMatchingBatchResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "progress": obj.get("progress") if obj.get("progress") is not None else 0,
            "status": obj.get("status"),
            "total_time": obj.get("total_time"),
            "error_message": obj.get("error_message"),
            "current_page": obj.get("current_page"),
            "total_pages": obj.get("total_pages"),
            "matches": [FunctionMatchingResultWithBestMatch.from_dict(_item) for _item in obj["matches"]] if obj.get("matches") is not None else None
        })
        return _obj


