# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.matched_function import MatchedFunction
from revengai.models.name_confidence import NameConfidence
from typing import Optional, Set
from typing_extensions import Self

class FunctionMatchingResultWithBestMatch(BaseModel):
    """
    FunctionMatchingResultWithBestMatch
    """ # noqa: E501
    function_id: StrictInt = Field(description="Unique identifier of the function")
    matched_functions: List[MatchedFunction]
    confidences: Optional[List[NameConfidence]] = None
    __properties: ClassVar[List[str]] = ["function_id", "matched_functions", "confidences"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionMatchingResultWithBestMatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in matched_functions (list)
        _items = []
        if self.matched_functions:
            for _item_matched_functions in self.matched_functions:
                if _item_matched_functions:
                    _items.append(_item_matched_functions.to_dict())
            _dict['matched_functions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in confidences (list)
        _items = []
        if self.confidences:
            for _item_confidences in self.confidences:
                if _item_confidences:
                    _items.append(_item_confidences.to_dict())
            _dict['confidences'] = _items
        # set to None if confidences (nullable) is None
        # and model_fields_set contains the field
        if self.confidences is None and "confidences" in self.model_fields_set:
            _dict['confidences'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionMatchingResultWithBestMatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "function_id": obj.get("function_id"),
            "matched_functions": [MatchedFunction.from_dict(_item) for _item in obj["matched_functions"]] if obj.get("matched_functions") is not None else None,
            "confidences": [NameConfidence.from_dict(_item) for _item in obj["confidences"]] if obj.get("confidences") is not None else None
        })
        return _obj


