# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class FunctionsDetailResponse(BaseModel):
    """
    FunctionsDetailResponse
    """ # noqa: E501
    function_id: StrictInt = Field(description="Function id")
    function_name: StrictStr
    function_vaddr: StrictInt
    function_size: StrictInt
    analysis_id: StrictInt
    binary_id: StrictInt
    binary_name: StrictStr
    sha_256_hash: StrictStr
    debug_hash: Optional[StrictStr]
    debug: StrictBool
    embedding_3d: Optional[List[Union[StrictFloat, StrictInt]]] = None
    embedding_1d: Optional[List[Union[StrictFloat, StrictInt]]] = None
    __properties: ClassVar[List[str]] = ["function_id", "function_name", "function_vaddr", "function_size", "analysis_id", "binary_id", "binary_name", "sha_256_hash", "debug_hash", "debug", "embedding_3d", "embedding_1d"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionsDetailResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if debug_hash (nullable) is None
        # and model_fields_set contains the field
        if self.debug_hash is None and "debug_hash" in self.model_fields_set:
            _dict['debug_hash'] = None

        # set to None if embedding_3d (nullable) is None
        # and model_fields_set contains the field
        if self.embedding_3d is None and "embedding_3d" in self.model_fields_set:
            _dict['embedding_3d'] = None

        # set to None if embedding_1d (nullable) is None
        # and model_fields_set contains the field
        if self.embedding_1d is None and "embedding_1d" in self.model_fields_set:
            _dict['embedding_1d'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionsDetailResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "function_id": obj.get("function_id"),
            "function_name": obj.get("function_name"),
            "function_vaddr": obj.get("function_vaddr"),
            "function_size": obj.get("function_size"),
            "analysis_id": obj.get("analysis_id"),
            "binary_id": obj.get("binary_id"),
            "binary_name": obj.get("binary_name"),
            "sha_256_hash": obj.get("sha_256_hash"),
            "debug_hash": obj.get("debug_hash"),
            "debug": obj.get("debug"),
            "embedding_3d": obj.get("embedding_3d"),
            "embedding_1d": obj.get("embedding_1d")
        })
        return _obj


