# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class SecurityModel(BaseModel):
    """
    SecurityModel
    """ # noqa: E501
    aslr: StrictBool
    dep: StrictBool
    cfg: StrictBool
    driver_model: StrictBool
    app_container: StrictBool
    terminal_server_aware: StrictBool
    image_isolation: StrictBool
    code_integrity: StrictBool
    high_entropy: StrictBool
    seh: StrictBool
    bound_image: StrictBool
    __properties: ClassVar[List[str]] = ["aslr", "dep", "cfg", "driver_model", "app_container", "terminal_server_aware", "image_isolation", "code_integrity", "high_entropy", "seh", "bound_image"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecurityModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecurityModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aslr": obj.get("aslr"),
            "dep": obj.get("dep"),
            "cfg": obj.get("cfg"),
            "driver_model": obj.get("driver_model"),
            "app_container": obj.get("app_container"),
            "terminal_server_aware": obj.get("terminal_server_aware"),
            "image_isolation": obj.get("image_isolation"),
            "code_integrity": obj.get("code_integrity"),
            "high_entropy": obj.get("high_entropy"),
            "seh": obj.get("seh"),
            "bound_image": obj.get("bound_image")
        })
        return _obj


