# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from revengai.models.ttps_attack import TTPSAttack
from revengai.models.ttps_occurance import TTPSOccurance
from typing import Optional, Set
from typing_extensions import Self

class TTPSElement(BaseModel):
    """
    TTPSElement
    """ # noqa: E501
    name: StrictStr
    attack: List[TTPSAttack]
    occurrences: List[TTPSOccurance]
    score: StrictInt
    __properties: ClassVar[List[str]] = ["name", "attack", "occurrences", "score"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TTPSElement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attack (list)
        _items = []
        if self.attack:
            for _item_attack in self.attack:
                if _item_attack:
                    _items.append(_item_attack.to_dict())
            _dict['attack'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in occurrences (list)
        _items = []
        if self.occurrences:
            for _item_occurrences in self.occurrences:
                if _item_occurrences:
                    _items.append(_item_occurrences.to_dict())
            _dict['occurrences'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TTPSElement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "attack": [TTPSAttack.from_dict(_item) for _item in obj["attack"]] if obj.get("attack") is not None else None,
            "occurrences": [TTPSOccurance.from_dict(_item) for _item in obj["occurrences"]] if obj.get("occurrences") is not None else None,
            "score": obj.get("score")
        })
        return _obj


