'use strict';
/*!
 * Copyright (c) Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" ? (version != null ? Bokeh[version] : Bokeh) : null;
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh" + (version != null ? " " + version : "") + ". You have to load it prior to loading plugins.");
    }
  })
({
"c27055c896": function _(e,o,b,s,t){s();const i=e("tslib").__importStar(e("2fbbcedd89"));b.bokehmol=i;(0,e("@bokehjs/base").register_models)(i)},
"2fbbcedd89": function _(e,r,t,a,o){a(),o("BaseFormatter",e("827897d99e").BaseFormatter),o("BaseHover",e("7443b2978e").BaseHover),o("RDKitFormatter",e("8eb66e0186").RDKitFormatter),o("RDKitHover",e("a1f83847db").RDKitHover),o("SmilesDrawerFormatter",e("630ad3fc70").SmilesDrawerFormatter),o("SmilesDrawerHover",e("3152be4d3f").SmilesDrawerHover)},
"827897d99e": function _(e,t,o,s,r){var _;s();const a=e("@bokehjs/models/tools/inspectors/customjs_hover");class m extends a.CustomJSHover{constructor(e){super(e)}draw_svg(e){return""}format(e,t,o){return this.draw_svg(e)}}o.BaseFormatter=m,_=m,m.__name__="BaseFormatter",m.__module__="bokehmol.models.base_formatter",_.define((({Int:e})=>({width:[e,160],height:[e,120]})))},
"7443b2978e": function _(e,i,o,I,t){var s;I();const A=e("@bokehjs/core/dom"),l=e("@bokehjs/core/util/templating"),r=e("@bokehjs/core/util/types"),h=e("@bokehjs/models/tools/inspectors/hover_tool"),n=e("@bokehjs/styles/icons.css");class _ extends h.HoverToolView{_render_tooltips(e,i){const{tooltips:o,smiles_column:I}=this.model,t=i.index;let s=o;if(null===s&&(s=""),!(0,r.isString)(s)){const o=this._template_el??(this._template_el=this._create_template(s));s=this._render_template(o,s,e,i).outerHTML}const h="<div>@"+I+"{custom}</div>"+s,n=(0,l.replace_placeholders)({html:h},e,t,this.model.formatters,i);return(0,A.div)(n)}}o.BaseHoverView=_,_.__name__="BaseHoverView";class a extends h.HoverTool{get computed_icon(){return"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAMAAADzapwJAAAAt1BMVEUAAAAAAAArKyskJCQcHBwrKyscHBwmJiYjIyMhISEgICAfHx8dHR0kJCQiIiIhISEhISEgICAkJCQkJCQjIyMiIiIiIiIhISEkJCQjIyMiIiIiIiIjIyMjIyMkJCQjIyMiIiIkJCQhISEjIyMiIiIiIiIiIiIkJCQjIyMiIiIiIiIiIiIiIiIhISEjIyMjIyMiIiIiIiIjIyMiIiIiIiIhISEiIiIiIiIiIiIiIiIhISEjIyP///9o30WSAAAAPHRSTlMAAQYHCQwSFBYXGBkaKy0uLzAxMjM0NTY5UVJTV1hdYHJyc3V3eHmBk5SVlpeZmpucnaqtrrCytLa7wMBTv07WAAAAAWJLR0Q8p2phzwAAAKRJREFUGBmtwQkagUAAgNF/ZAtZo2yRIrusofvfi+ab0gG8xx85gS8FDjlabJuS/db4WQ1RRksy+p3ZRZpxbZA6t8gYJxRzTc7WQhKPCjnlSJDwXEIdRQ9xPRKeS+eAcurjeiTEo8JhgNTdU44EUm9D9SlIRDV2FkrYZjHhazrHOJLS7xReRSi+CtzqZJYjmiUoNRn7/GixbUr2WyPHCXwpcPifD0UBD3u/QqniAAAAAElFTkSuQmCC"}constructor(e){super(e),this.tool_icon=n.tool_icon_hover}}o.BaseHover=a,s=a,a.__name__="BaseHover",a.__module__="bokehmol.models.base_hover",s.prototype.default_view=_,s.define((({Str:e,Int:i})=>({smiles_column:[e,"SMILES"],width:[i,160],height:[i,120]}))),s.override({tooltips:[]})},
"8eb66e0186": function _(t,i,e,s,o){var r;s();const _=t("827897d99e");class n extends _.BaseFormatter{constructor(t){super(t)}initialize(){super.initialize(),initRDKitModule().then((t=>{this.RDKitModule=t,console.log("RDKit version: "+t.version())}))}_wait_rdkit_module(){void 0===this.RDKitModule&&setTimeout(this._wait_rdkit_module,100)}_setup_options(){return this._wait_rdkit_module(),this.RDKitModule.prefer_coordgen(this.prefer_coordgen),this.json_mol_opts=JSON.stringify({removeHs:this.remove_hs,sanitize:this.sanitize,kekulize:this.kekulize}),this.json_draw_opts=JSON.stringify({width:this.width,height:this.height,...this.draw_options}),this.json_draw_opts}draw_svg(t){const i=this.json_draw_opts??this._setup_options(),e=this.RDKitModule.get_mol(t,this.json_mol_opts);if(null!==e&&e.is_valid()){const t=e.get_svg_with_highlights(i);return e.delete(),t}return super.draw_svg(t)}}e.RDKitFormatter=n,r=n,n.__name__="RDKitFormatter",n.__module__="bokehmol.models.rdkit_formatter",r.define((({Bool:t,Dict:i,Unknown:e})=>({prefer_coordgen:[t,!0],remove_hs:[t,!0],sanitize:[t,!0],kekulize:[t,!0],draw_options:[i(e),{}]})))},
"a1f83847db": function _(A,e,o,i,t){var r;i();const s=A("7443b2978e"),n=A("8eb66e0186");class d extends s.BaseHoverView{initialize(){super.initialize();const{formatters:A,smiles_column:e,width:o,height:i,prefer_coordgen:t,remove_hs:r,sanitize:s,kekulize:d,draw_options:_}=this.model;A["@"+e]=new n.RDKitFormatter({width:o,height:i,prefer_coordgen:t,remove_hs:r,sanitize:s,kekulize:d,draw_options:_})}}o.RDKitHoverView=d,d.__name__="RDKitHoverView";class _ extends s.BaseHover{get computed_icon(){return"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAFVBMVEXc3NwUFP8UPP9kZP+MjP+0tP////9ZXZotAAAAAXRSTlMAQObYZgAAAAFiS0dEBmFmuH0AAAAHdElNRQfmAwsPGi+MyC9RAAAAQElEQVQI12NgQABGQUEBMENISUkRLKBsbGwEEhIyBgJFsICLC0iIUdnExcUZwnANQWfApKCK4doRBsKtQFgKAQC5Ww1JEHSEkAAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAyMi0wMy0xMVQxNToyNjo0NyswMDowMDzr2J4AAAAldEVYdGRhdGU6bW9kaWZ5ADIwMjItMDMtMTFUMTU6MjY6NDcrMDA6MDBNtmAiAAAAAElFTkSuQmCC"}constructor(A){super(A),this.tool_name="RDKit Hover"}}o.RDKitHover=_,r=_,_.__name__="RDKitHover",_.__module__="bokehmol.models.rdkit_hover",r.prototype.default_view=d,r.define((({Bool:A,Dict:e,Unknown:o})=>({prefer_coordgen:[A,!0],remove_hs:[A,!0],sanitize:[A,!0],kekulize:[A,!0],draw_options:[e(o),{}]}))),r.register_alias("rdkit_hover",(()=>new r))},
"630ad3fc70": function _(t,e,r,s,i){var o;s();const n=t("827897d99e");class a extends n.BaseFormatter{constructor(t){super(t)}initialize(){super.initialize(),this.SmiDrawer=SmiDrawer}_make_svg_element(){const t=document.createElementNS("http://www.w3.org/2000/svg","svg");return t.setAttribute("xmlns","http://www.w3.org/2000/svg"),t.setAttribute("xmlns:xlink","http://www.w3.org/1999/xlink"),t.setAttributeNS(null,"width",""+this.width),t.setAttributeNS(null,"height",""+this.height),t.style.backgroundColor=this.background_colour,t}_setup_drawer(){const t=new this.SmiDrawer(this.mol_options,this.reaction_options);return this.drawer=t,t}draw_svg(t){const e=this.drawer??this._setup_drawer(),r=this._make_svg_element();e.draw(t,r,this.theme);const s=r.outerHTML;return r.remove(),s}}r.SmilesDrawerFormatter=a,o=a,a.__name__="SmilesDrawerFormatter",a.__module__="bokehmol.models.smilesdrawer_formatter",o.define((({Str:t,Dict:e,Unknown:r})=>({theme:[t,"light"],background_colour:[t,"transparent"],mol_options:[e(r),{}],reaction_options:[e(r),{}]})))},
"3152be4d3f": function _(e,o,r,i,t){var s;i();const n=e("7443b2978e"),a=e("630ad3fc70");class l extends n.BaseHoverView{initialize(){super.initialize();const{formatters:e,smiles_column:o,width:r,height:i,theme:t,background_colour:s,mol_options:n,reaction_options:l}=this.model;e["@"+o]=new a.SmilesDrawerFormatter({width:r,height:i,theme:t,background_colour:s,mol_options:n,reaction_options:l})}}r.SmilesDrawerHoverView=l,l.__name__="SmilesDrawerHoverView";class _ extends n.BaseHover{constructor(e){super(e),this.tool_name="SmilesDrawer Hover"}}r.SmilesDrawerHover=_,s=_,_.__name__="SmilesDrawerHover",_.__module__="bokehmol.models.smilesdrawer_hover",s.prototype.default_view=l,s.define((({Str:e,Dict:o,Unknown:r})=>({theme:[e,"light"],background_colour:[e,"transparent"],mol_options:[o(r),{}],reaction_options:[o(r),{}]}))),s.register_alias("smiles_hover",(()=>new s))},
}, "c27055c896", {"index":"c27055c896","models/index":"2fbbcedd89","models/base_formatter":"827897d99e","models/base_hover":"7443b2978e","models/rdkit_formatter":"8eb66e0186","models/rdkit_hover":"a1f83847db","models/smilesdrawer_formatter":"630ad3fc70","models/smilesdrawer_hover":"3152be4d3f"}, {});});
