"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import modal_proto.api_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _SandboxExecStderrConfig:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SandboxExecStderrConfigEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SandboxExecStderrConfig.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SANDBOX_EXEC_STDERR_CONFIG_DEVNULL: _SandboxExecStderrConfig.ValueType  # 0
    """The output will be discarded."""
    SANDBOX_EXEC_STDERR_CONFIG_PIPE: _SandboxExecStderrConfig.ValueType  # 1
    """The output will be streamed to the client."""
    SANDBOX_EXEC_STDERR_CONFIG_STDOUT: _SandboxExecStderrConfig.ValueType  # 2
    """A special value that can be used to indicate that the stderr stream should
    be merged with the stdout stream.
    """

class SandboxExecStderrConfig(_SandboxExecStderrConfig, metaclass=_SandboxExecStderrConfigEnumTypeWrapper): ...

SANDBOX_EXEC_STDERR_CONFIG_DEVNULL: SandboxExecStderrConfig.ValueType  # 0
"""The output will be discarded."""
SANDBOX_EXEC_STDERR_CONFIG_PIPE: SandboxExecStderrConfig.ValueType  # 1
"""The output will be streamed to the client."""
SANDBOX_EXEC_STDERR_CONFIG_STDOUT: SandboxExecStderrConfig.ValueType  # 2
"""A special value that can be used to indicate that the stderr stream should
be merged with the stdout stream.
"""
global___SandboxExecStderrConfig = SandboxExecStderrConfig

class _SandboxExecStdioFileDescriptor:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SandboxExecStdioFileDescriptorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SandboxExecStdioFileDescriptor.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SANDBOX_EXEC_STDIO_FILE_DESCRIPTOR_STDOUT: _SandboxExecStdioFileDescriptor.ValueType  # 0
    """Read from stdout."""
    SANDBOX_EXEC_STDIO_FILE_DESCRIPTOR_STDERR: _SandboxExecStdioFileDescriptor.ValueType  # 1
    """Read from stderr."""

class SandboxExecStdioFileDescriptor(_SandboxExecStdioFileDescriptor, metaclass=_SandboxExecStdioFileDescriptorEnumTypeWrapper): ...

SANDBOX_EXEC_STDIO_FILE_DESCRIPTOR_STDOUT: SandboxExecStdioFileDescriptor.ValueType  # 0
"""Read from stdout."""
SANDBOX_EXEC_STDIO_FILE_DESCRIPTOR_STDERR: SandboxExecStdioFileDescriptor.ValueType  # 1
"""Read from stderr."""
global___SandboxExecStdioFileDescriptor = SandboxExecStdioFileDescriptor

class _SandboxExecStdoutConfig:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SandboxExecStdoutConfigEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SandboxExecStdoutConfig.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SANDBOX_EXEC_STDOUT_CONFIG_DEVNULL: _SandboxExecStdoutConfig.ValueType  # 0
    """The output will be discarded."""
    SANDBOX_EXEC_STDOUT_CONFIG_PIPE: _SandboxExecStdoutConfig.ValueType  # 1
    """The output will be streamed to the client."""

class SandboxExecStdoutConfig(_SandboxExecStdoutConfig, metaclass=_SandboxExecStdoutConfigEnumTypeWrapper): ...

SANDBOX_EXEC_STDOUT_CONFIG_DEVNULL: SandboxExecStdoutConfig.ValueType  # 0
"""The output will be discarded."""
SANDBOX_EXEC_STDOUT_CONFIG_PIPE: SandboxExecStdoutConfig.ValueType  # 1
"""The output will be streamed to the client."""
global___SandboxExecStdoutConfig = SandboxExecStdoutConfig

class SandboxExecPollRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    EXEC_ID_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """The task ID of the sandbox running the exec'd command."""
    exec_id: builtins.str
    """The execution ID of the command to wait on."""
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
        exec_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["exec_id", b"exec_id", "task_id", b"task_id"]) -> None: ...

global___SandboxExecPollRequest = SandboxExecPollRequest

class SandboxExecPollResponse(google.protobuf.message.Message):
    """The response to a SandboxExecPollRequest. If the exec'd command has not
    completed, exit_status will be unset.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODE_FIELD_NUMBER: builtins.int
    SIGNAL_FIELD_NUMBER: builtins.int
    code: builtins.int
    """The exit code of the command."""
    signal: builtins.int
    """The signal that terminated the command."""
    def __init__(
        self,
        *,
        code: builtins.int = ...,
        signal: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["code", b"code", "exit_status", b"exit_status", "signal", b"signal"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["code", b"code", "exit_status", b"exit_status", "signal", b"signal"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["exit_status", b"exit_status"]) -> typing_extensions.Literal["code", "signal"] | None: ...

global___SandboxExecPollResponse = SandboxExecPollResponse

class SandboxExecStartRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    EXEC_ID_FIELD_NUMBER: builtins.int
    COMMAND_ARGS_FIELD_NUMBER: builtins.int
    STDOUT_CONFIG_FIELD_NUMBER: builtins.int
    STDERR_CONFIG_FIELD_NUMBER: builtins.int
    TIMEOUT_SECS_FIELD_NUMBER: builtins.int
    WORKDIR_FIELD_NUMBER: builtins.int
    SECRET_IDS_FIELD_NUMBER: builtins.int
    PTY_INFO_FIELD_NUMBER: builtins.int
    RUNTIME_DEBUG_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """The task ID of the sandbox to execute the command in."""
    exec_id: builtins.str
    """Execution ID. This ID will be used to identify the execution for other
    requests and ensure exec commands are idempotent.
    """
    @property
    def command_args(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Command arguments to execute."""
    stdout_config: global___SandboxExecStdoutConfig.ValueType
    """Configures how the stdout of the command will be handled."""
    stderr_config: global___SandboxExecStderrConfig.ValueType
    """Configures how the stderr of the command will be handled."""
    timeout_secs: builtins.int
    """Timeout in seconds for the exec'd command to exit. If the command does not
    exit within this duration, the command will be killed. This is NOT the
    timeout for the ExecStartRequest RPC to complete.
    """
    workdir: builtins.str
    """Working directory for the command."""
    @property
    def secret_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Secret IDs to mount into the sandbox."""
    @property
    def pty_info(self) -> modal_proto.api_pb2.PTYInfo:
        """PTY info for the command."""
    runtime_debug: builtins.bool
    """Enable debugging capabilities on the container runtime. Used only for
    internal debugging.
    """
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
        exec_id: builtins.str = ...,
        command_args: collections.abc.Iterable[builtins.str] | None = ...,
        stdout_config: global___SandboxExecStdoutConfig.ValueType = ...,
        stderr_config: global___SandboxExecStderrConfig.ValueType = ...,
        timeout_secs: builtins.int | None = ...,
        workdir: builtins.str | None = ...,
        secret_ids: collections.abc.Iterable[builtins.str] | None = ...,
        pty_info: modal_proto.api_pb2.PTYInfo | None = ...,
        runtime_debug: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_pty_info", b"_pty_info", "_timeout_secs", b"_timeout_secs", "_workdir", b"_workdir", "pty_info", b"pty_info", "timeout_secs", b"timeout_secs", "workdir", b"workdir"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_pty_info", b"_pty_info", "_timeout_secs", b"_timeout_secs", "_workdir", b"_workdir", "command_args", b"command_args", "exec_id", b"exec_id", "pty_info", b"pty_info", "runtime_debug", b"runtime_debug", "secret_ids", b"secret_ids", "stderr_config", b"stderr_config", "stdout_config", b"stdout_config", "task_id", b"task_id", "timeout_secs", b"timeout_secs", "workdir", b"workdir"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_pty_info", b"_pty_info"]) -> typing_extensions.Literal["pty_info"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout_secs", b"_timeout_secs"]) -> typing_extensions.Literal["timeout_secs"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_workdir", b"_workdir"]) -> typing_extensions.Literal["workdir"] | None: ...

global___SandboxExecStartRequest = SandboxExecStartRequest

class SandboxExecStartResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SandboxExecStartResponse = SandboxExecStartResponse

class SandboxExecStdinWriteRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    EXEC_ID_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    EOF_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """The task ID of the sandbox running the exec'd command."""
    exec_id: builtins.str
    """The execution ID of the command to write to."""
    offset: builtins.int
    """The offset to start writing to. This is used to resume writing from the
    last write position if the connection is closed and reopened.
    """
    data: builtins.bytes
    eof: builtins.bool
    """If true, close the stdin stream after writing any provided data.
    This signals EOF to the exec'd process.
    """
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
        exec_id: builtins.str = ...,
        offset: builtins.int = ...,
        data: builtins.bytes = ...,
        eof: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data", "eof", b"eof", "exec_id", b"exec_id", "offset", b"offset", "task_id", b"task_id"]) -> None: ...

global___SandboxExecStdinWriteRequest = SandboxExecStdinWriteRequest

class SandboxExecStdinWriteResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SandboxExecStdinWriteResponse = SandboxExecStdinWriteResponse

class SandboxExecStdioReadRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    EXEC_ID_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    FILE_DESCRIPTOR_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """The task ID of the sandbox running the exec'd command."""
    exec_id: builtins.str
    """The execution ID of the command to read from."""
    offset: builtins.int
    """The offset to start reading from. This is used to resume reading from the
    last read position if the connection is closed and reopened.
    """
    file_descriptor: global___SandboxExecStdioFileDescriptor.ValueType
    """Which file descriptor to read from."""
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
        exec_id: builtins.str = ...,
        offset: builtins.int = ...,
        file_descriptor: global___SandboxExecStdioFileDescriptor.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["exec_id", b"exec_id", "file_descriptor", b"file_descriptor", "offset", b"offset", "task_id", b"task_id"]) -> None: ...

global___SandboxExecStdioReadRequest = SandboxExecStdioReadRequest

class SandboxExecStdioReadResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    """The data read from the file descriptor."""
    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data"]) -> None: ...

global___SandboxExecStdioReadResponse = SandboxExecStdioReadResponse

class SandboxExecWaitRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    EXEC_ID_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """The task ID of the sandbox running the exec'd command."""
    exec_id: builtins.str
    """The execution ID of the command to wait on."""
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
        exec_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["exec_id", b"exec_id", "task_id", b"task_id"]) -> None: ...

global___SandboxExecWaitRequest = SandboxExecWaitRequest

class SandboxExecWaitResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODE_FIELD_NUMBER: builtins.int
    SIGNAL_FIELD_NUMBER: builtins.int
    code: builtins.int
    """The exit code of the command."""
    signal: builtins.int
    """The signal that terminated the command."""
    def __init__(
        self,
        *,
        code: builtins.int = ...,
        signal: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["code", b"code", "exit_status", b"exit_status", "signal", b"signal"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["code", b"code", "exit_status", b"exit_status", "signal", b"signal"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["exit_status", b"exit_status"]) -> typing_extensions.Literal["code", "signal"] | None: ...

global___SandboxExecWaitResponse = SandboxExecWaitResponse
