# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr, field_validator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from ri.apiclient.models.create_agent_request import CreateAgentRequest
from ri.apiclient.models.create_agent_response import CreateAgentResponse
from ri.apiclient.models.create_firewall_agent_request import CreateFirewallAgentRequest
from ri.apiclient.models.create_firewall_agent_response import CreateFirewallAgentResponse
from ri.apiclient.models.create_firewall_instance_request import CreateFirewallInstanceRequest
from ri.apiclient.models.create_firewall_instance_response import CreateFirewallInstanceResponse
from ri.apiclient.models.get_agent_response import GetAgentResponse
from ri.apiclient.models.get_upgrade_for_agent_response import GetUpgradeForAgentResponse
from ri.apiclient.models.list_agents_response import ListAgentsResponse
from ri.apiclient.models.list_firewall_instances_response import ListFirewallInstancesResponse
from ri.apiclient.models.upgrade_agent_request import UpgradeAgentRequest

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class AgentManagerApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_agent(
        self,
        aws_config: Optional[AWSConfig] = None,
        azure_config: Optional[AzureConfig] = None,
        gcp_config: Optional[GCPConfig] = None,
        local_config: Optional[object] = None,
        name: Optional[str] = None,
    ) -> CreateAgentResponse:
        """CreateAgent

        Creates agent and returns the configuration for installing the agent.

        :param aws_config:
        :type aws_config: AWSConfig
        :param azure_config:
        :type azure_config: AzureConfig
        :param gcp_config:
        :type gcp_config: GCPConfig
        :param local_config: Configuration for local machine.
        :type local_config: object
        :param name: Agent name given by the user.
        :type name: str
        :return: Returns the result object.
        """ # noqa: E501

        body = CreateAgentRequest(
          aws_config=aws_config,
          azure_config=azure_config,
          gcp_config=gcp_config,
          local_config=local_config,
          name=name,
        )

        _param = self._create_agent_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAgentResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_agent_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/agents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def create_firewall_agent(
        self,
        name: Optional[str] = None,
    ) -> CreateFirewallAgentResponse:
        """CreateFirewallAgent

        Creates a firewall agent and returns the api key.

        :param name: The agent name given by the user.
        :type name: str
        :return: Returns the result object.
        """ # noqa: E501

        body = CreateFirewallAgentRequest(
          name=name,
        )

        _param = self._create_firewall_agent_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateFirewallAgentResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_firewall_agent_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/agents/firewall',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def create_firewall_instance(
        self,
        agent_id_uuid: str,
        description: str,
        agent_id: Optional[object] = None,
        config: Optional[RuleConfig] = None,
        spec: Optional[FirewallInstanceDeploymentConfig] = None,
    ) -> CreateFirewallInstanceResponse:
        """CreateFirewallInstance

        Creates a new firewall instance record in the DB with REQUESTED status. Expects firewall agent in the DP to check for and eventually deploy the firewall instance. This is intended to be used by external clients of the CP.  Example flow: user logs into the UI connected to the CP -> user tries to create agent in the UI -> UI calls CreateFirewallInstance -> CP tries to create the agent with the DP and then update the status

        :param agent_id_uuid: Unique object ID. (required)
        :type agent_id_uuid: str
        :param description: Human-readable description of the firewall instance. (required)
        :type description: str
        :param agent_id: ID of the agent that will create the firewall instance.
        :type agent_id: object
        :param config:
        :type config: RuleConfig
        :param spec:
        :type spec: FirewallInstanceDeploymentConfig
        :return: Returns the result object.
        """ # noqa: E501

        body = CreateFirewallInstanceRequest(
          agent_id=agent_id,
          config=config,
          description=description,
          spec=spec,
        )

        _param = self._create_firewall_instance_serialize(
            agent_id_uuid=agent_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateFirewallInstanceResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_firewall_instance_serialize(
        self,
        agent_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if agent_id_uuid is not None:
            _path_params['agentId.uuid'] = agent_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/agents/firewall/{agentId.uuid}/instances',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_agent(
        self,
        agent_id_uuid: str,
    ) -> object:
        """DeleteAgent

        Deletes a specified agent. An error is returned if the deletion fails or if the agent is not in a deletable state.

        :param agent_id_uuid: Unique object ID. (required)
        :type agent_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_agent_serialize(
            agent_id_uuid=agent_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_agent_serialize(
        self,
        agent_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if agent_id_uuid is not None:
            _path_params['agentId.uuid'] = agent_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/agents/{agentId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_firewall_instance(
        self,
        agent_id_uuid: str,
        firewall_instance_id: str,
    ) -> object:
        """DeleteFirewallInstance

        Marks the specified firewall instance with REQUESTED_DELETE status. Expects firewall agent in the DP to check for and eventually delete the firewall instance. This is intended to be used by external clients of the CP.  Example flow: user uses API to call DeleteFirewallInstance -> CP tries to delete the firewall instance with the DP and then delete it from the DB.

        :param agent_id_uuid: Unique object ID. (required)
        :type agent_id_uuid: str
        :param firewall_instance_id: ID of the firewall instance to delete. (required)
        :type firewall_instance_id: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_firewall_instance_serialize(
            agent_id_uuid=agent_id_uuid,
            firewall_instance_id=firewall_instance_id,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_firewall_instance_serialize(
        self,
        agent_id_uuid,
        firewall_instance_id,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if agent_id_uuid is not None:
            _path_params['agentId.uuid'] = agent_id_uuid
        if firewall_instance_id is not None:
            _path_params['firewallInstanceId'] = firewall_instance_id
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1-beta/agents/firewall/{agentId.uuid}/instances/{firewallInstanceId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_agent(
        self,
        agent_id_uuid: str,
    ) -> GetAgentResponse:
        """GetAgent

        Returns the agent that matches the specified ID.

        :param agent_id_uuid: Unique object ID. (required)
        :type agent_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_agent_serialize(
            agent_id_uuid=agent_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAgentResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_agent_serialize(
        self,
        agent_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if agent_id_uuid is not None:
            _path_params['agentId.uuid'] = agent_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/agents/{agentId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_upgrade_for_agent(
        self,
        agent_id_uuid: str,
        agent_namespace: str,
    ) -> GetUpgradeForAgentResponse:
        """GetUpgradeForAgent

        GetUpgradeForAgent returns the desired state of the agent and the current status of the upgrade.

        :param agent_id_uuid: Unique object ID. (required)
        :type agent_id_uuid: str
        :param agent_namespace: The namespace in which the agent is deployed. Since namespace is not known in the CP, it must be provided by the launcher when calling GetUpgradeForAgent. (required)
        :type agent_namespace: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_upgrade_for_agent_serialize(
            agent_id_uuid=agent_id_uuid,
            agent_namespace=agent_namespace,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUpgradeForAgentResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_upgrade_for_agent_serialize(
        self,
        agent_id_uuid,
        agent_namespace,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if agent_id_uuid is not None:
            _path_params['agentId.uuid'] = agent_id_uuid
        if agent_namespace is not None:
            
            _query_params.append(('agentNamespace', agent_namespace))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/agents/{agentId.uuid}/upgrade',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_agents(
        self,
        page_size: Optional[str] = None,
        page_token: Optional[str] = None,
        first_page_query_agent_status_types: Optional[List[str]] = None,
        first_page_query_agent_ids: Optional[List[str]] = None,
        first_page_query_type: Optional[str] = None,
    ) -> ListAgentsResponse:
        """ListAgents

        Returns a paginated list of agents.

        :param page_size: The maximum number of Agent objects to return in a single page.
        :type page_size: str
        :param page_token: Specifies a page of the list returned by a ListAgents query. The ListAgents query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageQuery field.
        :type page_token: str
        :param first_page_query_agent_status_types: Specifies a set of agent status types. The query filters for results that match the specified types.   - AGENT_STATUS_PENDING: Resources have been created for the agent but the agent has not started yet.  - AGENT_STATUS_ACTIVE: Agent can run jobs.  - AGENT_STATUS_UNRESPONSIVE: No agent heartbeat for three minutes.  - AGENT_STATUS_DEACTIVATED: Agent can no longer run jobs and can be deleted. (Deprecated after Deactivation and Deletion endpoints are combined)
        :type first_page_query_agent_status_types: List[str]
        :param first_page_query_agent_ids: Specifies a set of agent IDs. The query filters for results that match the specified IDs.
        :type first_page_query_agent_ids: List[str]
        :param first_page_query_type: Specifies the type of agent (validation or firewall). The query filters for results that match the specified type.   - AGENT_TYPE_VALIDATION: We use the zero value for VALIDATION for backwards compatibility with existing agents. protolint:disable:next ENUM_FIELD_NAMES_ZERO_VALUE_END_WITH
        :type first_page_query_type: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_agents_serialize(
            page_size=page_size,
            page_token=page_token,
            first_page_query_agent_status_types=first_page_query_agent_status_types,
            first_page_query_agent_ids=first_page_query_agent_ids,
            first_page_query_type=first_page_query_type,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListAgentsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_agents_serialize(
        self,
        page_size,
        page_token,
        first_page_query_agent_status_types,
        first_page_query_agent_ids,
        first_page_query_type,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'firstPageQuery.agentStatusTypes': 'multi',
            'firstPageQuery.agentIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if first_page_query_agent_status_types is not None:
            
            _query_params.append(('firstPageQuery.agentStatusTypes', first_page_query_agent_status_types))
            
        if first_page_query_agent_ids is not None:
            
            _query_params.append(('firstPageQuery.agentIds', first_page_query_agent_ids))
            
        if first_page_query_type is not None:
            
            _query_params.append(('firstPageQuery.type', first_page_query_type))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/agents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_firewall_instances(
        self,
        agent_id_uuid: str,
        page_size: Optional[str] = None,
        page_token: Optional[str] = None,
        first_page_query_deployment_status: Optional[str] = None,
    ) -> ListFirewallInstancesResponse:
        """ListFirewallInstances

        Returns a paginated list of firewall instances.

        :param agent_id_uuid: Unique object ID. (required)
        :type agent_id_uuid: str
        :param page_size:
        :type page_size: str
        :param page_token: Specifies a page of the list returned by a ListFirewallInstances query. The ListFirewallInstances query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageQuery field.
        :type page_token: str
        :param first_page_query_deployment_status: If provided, only firewall instances with the provided status will be returned.
        :type first_page_query_deployment_status: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_firewall_instances_serialize(
            agent_id_uuid=agent_id_uuid,
            page_size=page_size,
            page_token=page_token,
            first_page_query_deployment_status=first_page_query_deployment_status,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFirewallInstancesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_firewall_instances_serialize(
        self,
        agent_id_uuid,
        page_size,
        page_token,
        first_page_query_deployment_status,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if agent_id_uuid is not None:
            _path_params['agentId.uuid'] = agent_id_uuid
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if first_page_query_deployment_status is not None:
            
            _query_params.append(('firstPageQuery.deploymentStatus', first_page_query_deployment_status))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/agents/firewall/{agentId.uuid}/instances',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def upgrade_agent(
        self,
        agent_id_uuid: str,
        agent_id: Optional[object] = None,
        custom_values: Optional[Dict[str, str]] = None,
    ) -> object:
        """UpgradeAgent

        UpgradeAgent starts the process of upgrading the agent to the version of the control plane

        :param agent_id_uuid: Unique object ID. (required)
        :type agent_id_uuid: str
        :param agent_id: Uniquely specifies an Agent.
        :type agent_id: object
        :param custom_values: Example:   {     \"rimeAgent.images.agentImage.registry\": \"docker.io\",   }
        :type custom_values: Dict[str, str]
        :return: Returns the result object.
        """ # noqa: E501

        body = UpgradeAgentRequest(
          agent_id=agent_id,
          custom_values=custom_values,
        )

        _param = self._upgrade_agent_serialize(
            agent_id_uuid=agent_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _upgrade_agent_serialize(
        self,
        agent_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if agent_id_uuid is not None:
            _path_params['agentId.uuid'] = agent_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/agents/{agentId.uuid}/upgrade',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
