# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr
from typing import Any, Dict, Optional
from typing_extensions import Annotated
from ri.apiclient.models.register_data_stream_request import RegisterDataStreamRequest
from ri.apiclient.models.register_data_stream_response import RegisterDataStreamResponse
from ri.apiclient.models.store_datapoints_request import StoreDatapointsRequest
from ri.apiclient.models.store_datapoints_response import StoreDatapointsResponse
from ri.apiclient.models.store_predictions_request import StorePredictionsRequest
from ri.apiclient.models.stream_result_of_get_datapoints_response import StreamResultOfGetDatapointsResponse
from ri.apiclient.models.stream_result_of_get_predictions_response import StreamResultOfGetPredictionsResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class DataCollectorApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def get_datapoints(
        self,
        data_stream_id_uuid: str,
        time_interval_start_time: Optional[datetime] = None,
        time_interval_end_time: Optional[datetime] = None,
    ) -> StreamResultOfGetDatapointsResponse:
        """GetDatapoints

        GetDatapoints returns all datapoints from a time period.

        :param data_stream_id_uuid: Unique object ID. (required)
        :type data_stream_id_uuid: str
        :param time_interval_start_time:
        :type time_interval_start_time: datetime
        :param time_interval_end_time:
        :type time_interval_end_time: datetime
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_datapoints_serialize(
            data_stream_id_uuid=data_stream_id_uuid,
            time_interval_start_time=time_interval_start_time,
            time_interval_end_time=time_interval_end_time,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StreamResultOfGetDatapointsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_datapoints_serialize(
        self,
        data_stream_id_uuid,
        time_interval_start_time,
        time_interval_end_time,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if data_stream_id_uuid is not None:
            _path_params['dataStreamId.uuid'] = data_stream_id_uuid
        if time_interval_start_time is not None:
            if isinstance(time_interval_start_time, datetime):
                _query_params.append(
                    (
                        'timeInterval.startTime',
                        time_interval_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('timeInterval.startTime', time_interval_start_time))
            
        if time_interval_end_time is not None:
            if isinstance(time_interval_end_time, datetime):
                _query_params.append(
                    (
                        'timeInterval.endTime',
                        time_interval_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('timeInterval.endTime', time_interval_end_time))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/data-collector/datapoints/{dataStreamId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_predictions(
        self,
        model_id_uuid: str,
        data_stream_id_uuid: str,
        time_interval_start_time: Optional[datetime] = None,
        time_interval_end_time: Optional[datetime] = None,
    ) -> StreamResultOfGetPredictionsResponse:
        """GetPredictions

        GetPredictions returns all predictions from a time period

        :param model_id_uuid: Unique object ID. (required)
        :type model_id_uuid: str
        :param data_stream_id_uuid: Unique object ID. (required)
        :type data_stream_id_uuid: str
        :param time_interval_start_time:
        :type time_interval_start_time: datetime
        :param time_interval_end_time:
        :type time_interval_end_time: datetime
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_predictions_serialize(
            model_id_uuid=model_id_uuid,
            data_stream_id_uuid=data_stream_id_uuid,
            time_interval_start_time=time_interval_start_time,
            time_interval_end_time=time_interval_end_time,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StreamResultOfGetPredictionsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_predictions_serialize(
        self,
        model_id_uuid,
        data_stream_id_uuid,
        time_interval_start_time,
        time_interval_end_time,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if model_id_uuid is not None:
            _path_params['modelId.uuid'] = model_id_uuid
        if data_stream_id_uuid is not None:
            _path_params['dataStreamId.uuid'] = data_stream_id_uuid
        if time_interval_start_time is not None:
            if isinstance(time_interval_start_time, datetime):
                _query_params.append(
                    (
                        'timeInterval.startTime',
                        time_interval_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('timeInterval.startTime', time_interval_start_time))
            
        if time_interval_end_time is not None:
            if isinstance(time_interval_end_time, datetime):
                _query_params.append(
                    (
                        'timeInterval.endTime',
                        time_interval_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('timeInterval.endTime', time_interval_end_time))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/data-collector/predictions/{modelId.uuid}/{dataStreamId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def register_data_stream(
        self,
        project_id_uuid: str,
        project_id: Optional[object] = None,
    ) -> RegisterDataStreamResponse:
        """RegisterDataStream

        Registers a new data stream. A data stream is a location where data points are stored. All data points that are in the same registered data set must be stored in the same data stream.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param project_id: Uniquely specifies a Project.
        :type project_id: object
        :return: Returns the result object.
        """ # noqa: E501

        body = RegisterDataStreamRequest(
          project_id=project_id,
        )

        _param = self._register_data_stream_serialize(
            project_id_uuid=project_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RegisterDataStreamResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _register_data_stream_serialize(
        self,
        project_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/data-collector/datastream/{projectId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def store_datapoints(
        self,
        data_stream_id_uuid: str,
        data_stream_id: Optional[object] = None,
        datapoints: Optional[List[DatapointRow]] = None,
    ) -> StoreDatapointsResponse:
        """StoreDatapoints

        Store multiple new datapoints into a data stream.

        :param data_stream_id_uuid: Unique object ID. (required)
        :type data_stream_id_uuid: str
        :param data_stream_id: Uniquely specifies a data stream.
        :type data_stream_id: object
        :param datapoints: The datapoints to store.
        :type datapoints: List[DatapointRow]
        :return: Returns the result object.
        """ # noqa: E501

        body = StoreDatapointsRequest(
          data_stream_id=data_stream_id,
          datapoints=datapoints,
        )

        _param = self._store_datapoints_serialize(
            data_stream_id_uuid=data_stream_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StoreDatapointsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _store_datapoints_serialize(
        self,
        data_stream_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if data_stream_id_uuid is not None:
            _path_params['dataStreamId.uuid'] = data_stream_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1-beta/data-collector/data/{dataStreamId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def store_predictions(
        self,
        model_id_uuid: str,
        predictions: List[StorePredictionsRequestPrediction],
        model_id: Optional[object] = None,
    ) -> object:
        """StorePredictions

        Store multiple new predictions.

        :param model_id_uuid: Unique object ID. (required)
        :type model_id_uuid: str
        :param predictions: (required)
        :type predictions: List[StorePredictionsRequestPrediction]
        :param model_id: Uniquely specifies a Model.
        :type model_id: object
        :return: Returns the result object.
        """ # noqa: E501

        body = StorePredictionsRequest(
          model_id=model_id,
          predictions=predictions,
        )

        _param = self._store_predictions_serialize(
            model_id_uuid=model_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _store_predictions_serialize(
        self,
        model_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if model_id_uuid is not None:
            _path_params['modelId.uuid'] = model_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1-beta/data-collector/predictions/{modelId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
