# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from ri.apiclient.models.list_detection_events_response import ListDetectionEventsResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class DetectionApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def list_detection_events(
        self,
        project_id_uuid: str,
        first_page_req_event_object_id: Optional[str] = None,
        first_page_req_event_time_range_start_time: Optional[datetime] = None,
        first_page_req_event_time_range_end_time: Optional[datetime] = None,
        first_page_req_severity: Optional[str] = None,
        first_page_req_event_types: Optional[List[str]] = None,
        first_page_req_risk_category_types: Optional[List[str]] = None,
        first_page_req_test_categories: Optional[List[str]] = None,
        first_page_req_sort_sort_order: Optional[str] = None,
        first_page_req_sort_sort_by: Optional[str] = None,
        first_page_req_include_resolved: Optional[bool] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListDetectionEventsResponse:
        """ListDetectionEvents

        List out events for a given project. Detection events represent problems Robust Intelligence detects in different risk categories, such as performance degradation or security risk. This is a paginated method.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param first_page_req_event_object_id: Optional: return a series of detection events for a single object.
        :type first_page_req_event_object_id: str
        :param first_page_req_event_time_range_start_time:
        :type first_page_req_event_time_range_start_time: datetime
        :param first_page_req_event_time_range_end_time:
        :type first_page_req_event_time_range_end_time: datetime
        :param first_page_req_severity: Optional: When unspecified, returns all.   - SEVERITY_UNSPECIFIED: Indicates that no test runs for the specified metric.  - SEVERITY_PASS: Indicates that the specified metric is lower than the low threshold in the case where the Monitor is configured to trigger on an increase of a metric.  - SEVERITY_WARNING: Indicates that the specified metric is higher than the low threshold but still lower than the high threshold, in the case that a Monitor is configured to trigger on an increase of a metric. Warning and Alert severity levels will trigger a Degradation event.  - SEVERITY_ALERT: Indicates that the specified metric is higher than the high threshold in the case that the Monitor is configured to trigger on an increase of a metric. Warning and Alert severity level will trigger a Degradation event.
        :type first_page_req_severity: str
        :param first_page_req_event_types: Optional: When the list is empty, returns all.
        :type first_page_req_event_types: List[str]
        :param first_page_req_risk_category_types: Optional: When the list is empty, returns all.
        :type first_page_req_risk_category_types: List[str]
        :param first_page_req_test_categories: Optional: When the list is empty, return all.
        :type first_page_req_test_categories: List[str]
        :param first_page_req_sort_sort_order:
        :type first_page_req_sort_sort_order: str
        :param first_page_req_sort_sort_by:
        :type first_page_req_sort_sort_by: str
        :param first_page_req_include_resolved:
        :type first_page_req_include_resolved: bool
        :param page_token: Specifies a page of the list returned by a ListDetectionEvents query. The ListDetectionEvents query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :type page_token: str
        :param page_size: The maximum number of Detection Event objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_detection_events_serialize(
            project_id_uuid=project_id_uuid,
            first_page_req_event_object_id=first_page_req_event_object_id,
            first_page_req_event_time_range_start_time=first_page_req_event_time_range_start_time,
            first_page_req_event_time_range_end_time=first_page_req_event_time_range_end_time,
            first_page_req_severity=first_page_req_severity,
            first_page_req_event_types=first_page_req_event_types,
            first_page_req_risk_category_types=first_page_req_risk_category_types,
            first_page_req_test_categories=first_page_req_test_categories,
            first_page_req_sort_sort_order=first_page_req_sort_sort_order,
            first_page_req_sort_sort_by=first_page_req_sort_sort_by,
            first_page_req_include_resolved=first_page_req_include_resolved,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListDetectionEventsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_detection_events_serialize(
        self,
        project_id_uuid,
        first_page_req_event_object_id,
        first_page_req_event_time_range_start_time,
        first_page_req_event_time_range_end_time,
        first_page_req_severity,
        first_page_req_event_types,
        first_page_req_risk_category_types,
        first_page_req_test_categories,
        first_page_req_sort_sort_order,
        first_page_req_sort_sort_by,
        first_page_req_include_resolved,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'firstPageReq.eventTypes': 'multi',
            'firstPageReq.riskCategoryTypes': 'multi',
            'firstPageReq.testCategories': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if first_page_req_event_object_id is not None:
            
            _query_params.append(('firstPageReq.eventObjectId', first_page_req_event_object_id))
            
        if first_page_req_event_time_range_start_time is not None:
            if isinstance(first_page_req_event_time_range_start_time, datetime):
                _query_params.append(
                    (
                        'firstPageReq.eventTimeRange.startTime',
                        first_page_req_event_time_range_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('firstPageReq.eventTimeRange.startTime', first_page_req_event_time_range_start_time))
            
        if first_page_req_event_time_range_end_time is not None:
            if isinstance(first_page_req_event_time_range_end_time, datetime):
                _query_params.append(
                    (
                        'firstPageReq.eventTimeRange.endTime',
                        first_page_req_event_time_range_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('firstPageReq.eventTimeRange.endTime', first_page_req_event_time_range_end_time))
            
        if first_page_req_severity is not None:
            
            _query_params.append(('firstPageReq.severity', first_page_req_severity))
            
        if first_page_req_event_types is not None:
            
            _query_params.append(('firstPageReq.eventTypes', first_page_req_event_types))
            
        if first_page_req_risk_category_types is not None:
            
            _query_params.append(('firstPageReq.riskCategoryTypes', first_page_req_risk_category_types))
            
        if first_page_req_test_categories is not None:
            
            _query_params.append(('firstPageReq.testCategories', first_page_req_test_categories))
            
        if first_page_req_sort_sort_order is not None:
            
            _query_params.append(('firstPageReq.sort.sortOrder', first_page_req_sort_sort_order))
            
        if first_page_req_sort_sort_by is not None:
            
            _query_params.append(('firstPageReq.sort.sortBy', first_page_req_sort_sort_by))
            
        if first_page_req_include_resolved is not None:
            
            _query_params.append(('firstPageReq.includeResolved', first_page_req_include_resolved))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/detection-events/{projectId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
