# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr, field_validator
from typing_extensions import Annotated
from ri.apiclient.models.get_limit_status_response import GetLimitStatusResponse
from ri.apiclient.models.list_enabled_features_response import ListEnabledFeaturesResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class FeatureFlagApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def get_limit_status(
        self,
        customer_name: str,
        limit: str,
    ) -> GetLimitStatusResponse:
        """GetLimitStatus

        Returns the status of a specified limit in this deployment's license.

        :param customer_name: Name of the customer to query. (required)
        :type customer_name: str
        :param limit: Specifies which limit to query. (required)
        :type limit: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_limit_status_serialize(
            customer_name=customer_name,
            limit=limit,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLimitStatusResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_limit_status_serialize(
        self,
        customer_name,
        limit,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if customer_name is not None:
            _path_params['customerName'] = customer_name
        if limit is not None:
            _path_params['limit'] = limit
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/feature-flags/{customerName}/limits/{limit}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_enabled_features(
        self,
        customer_name: str,
    ) -> ListEnabledFeaturesResponse:
        """ListEnabledFeatures

        Returns all features enabled in license for a customer.

        :param customer_name: Name of the customer to query. (required)
        :type customer_name: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_enabled_features_serialize(
            customer_name=customer_name,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEnabledFeaturesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_enabled_features_serialize(
        self,
        customer_name,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if customer_name is not None:
            _path_params['customerName'] = customer_name
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/feature-flags/{customerName}/features',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
