# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Any, Dict, Optional
from typing_extensions import Annotated
from ri.apiclient.models.get_file_scan_result_response import GetFileScanResultResponse
from ri.apiclient.models.list_file_scan_results_response import ListFileScanResultsResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class FileScanningApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def delete_file_scan_result(
        self,
        file_scan_id_uuid: str,
    ) -> object:
        """DeleteFileScanResult

        Deletes a File Scan result by ID.

        :param file_scan_id_uuid: Unique object ID. (required)
        :type file_scan_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_file_scan_result_serialize(
            file_scan_id_uuid=file_scan_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_file_scan_result_serialize(
        self,
        file_scan_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if file_scan_id_uuid is not None:
            _path_params['fileScanId.uuid'] = file_scan_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/file-scan-results/{fileScanId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_file_scan_result2(
        self,
        file_scan_id_uuid: str,
    ) -> object:
        """DeleteFileScanResult

        Deletes a File Scan result by ID.

        :param file_scan_id_uuid: Unique object ID. (required)
        :type file_scan_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_file_scan_result2_serialize(
            file_scan_id_uuid=file_scan_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_file_scan_result2_serialize(
        self,
        file_scan_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if file_scan_id_uuid is not None:
            _path_params['fileScanId.uuid'] = file_scan_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1-beta/file-scan-results/{fileScanId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_file_scan_result(
        self,
        file_scan_id_uuid: str,
    ) -> GetFileScanResultResponse:
        """GetFileScanResult

        Returns a File Scan result by ID.

        :param file_scan_id_uuid: Unique object ID. (required)
        :type file_scan_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_file_scan_result_serialize(
            file_scan_id_uuid=file_scan_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFileScanResultResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_file_scan_result_serialize(
        self,
        file_scan_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if file_scan_id_uuid is not None:
            _path_params['fileScanId.uuid'] = file_scan_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/file-scan-results/{fileScanId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_file_scan_result2(
        self,
        file_scan_id_uuid: str,
    ) -> GetFileScanResultResponse:
        """GetFileScanResult

        Returns a File Scan result by ID.

        :param file_scan_id_uuid: Unique object ID. (required)
        :type file_scan_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_file_scan_result2_serialize(
            file_scan_id_uuid=file_scan_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFileScanResultResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_file_scan_result2_serialize(
        self,
        file_scan_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if file_scan_id_uuid is not None:
            _path_params['fileScanId.uuid'] = file_scan_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/file-scan-results/{fileScanId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_file_scan_results(
        self,
        first_page_query_project_id_uuid: Optional[str] = None,
        first_page_query_model_id_uuid: Optional[str] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListFileScanResultsResponse:
        """ListFileScanResults

        Returns a paginated list of all File Scan results for the project.

        :param first_page_query_project_id_uuid: Unique object ID.
        :type first_page_query_project_id_uuid: str
        :param first_page_query_model_id_uuid: Unique object ID.
        :type first_page_query_model_id_uuid: str
        :param page_token: Specifies a page of the list returned by a ListFileScan query beyond the first page.
        :type page_token: str
        :param page_size: Defines the maximum number of results on a given page. API call pagination navigates through the entire set of results in groups of the specified page size.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_file_scan_results_serialize(
            first_page_query_project_id_uuid=first_page_query_project_id_uuid,
            first_page_query_model_id_uuid=first_page_query_model_id_uuid,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFileScanResultsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_file_scan_results_serialize(
        self,
        first_page_query_project_id_uuid,
        first_page_query_model_id_uuid,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if first_page_query_project_id_uuid is not None:
            
            _query_params.append(('firstPageQuery.projectId.uuid', first_page_query_project_id_uuid))
            
        if first_page_query_model_id_uuid is not None:
            
            _query_params.append(('firstPageQuery.modelId.uuid', first_page_query_model_id_uuid))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/file-scan-results',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_file_scan_results2(
        self,
        first_page_query_project_id_uuid: Optional[str] = None,
        first_page_query_model_id_uuid: Optional[str] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListFileScanResultsResponse:
        """ListFileScanResults

        Returns a paginated list of all File Scan results for the project.

        :param first_page_query_project_id_uuid: Unique object ID.
        :type first_page_query_project_id_uuid: str
        :param first_page_query_model_id_uuid: Unique object ID.
        :type first_page_query_model_id_uuid: str
        :param page_token: Specifies a page of the list returned by a ListFileScan query beyond the first page.
        :type page_token: str
        :param page_size: Defines the maximum number of results on a given page. API call pagination navigates through the entire set of results in groups of the specified page size.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_file_scan_results2_serialize(
            first_page_query_project_id_uuid=first_page_query_project_id_uuid,
            first_page_query_model_id_uuid=first_page_query_model_id_uuid,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFileScanResultsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_file_scan_results2_serialize(
        self,
        first_page_query_project_id_uuid,
        first_page_query_model_id_uuid,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if first_page_query_project_id_uuid is not None:
            
            _query_params.append(('firstPageQuery.projectId.uuid', first_page_query_project_id_uuid))
            
        if first_page_query_model_id_uuid is not None:
            
            _query_params.append(('firstPageQuery.modelId.uuid', first_page_query_model_id_uuid))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/file-scan-results',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
