# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from ri.apiclient.models.get_dataset_file_upload_url_request import GetDatasetFileUploadURLRequest
from ri.apiclient.models.get_dataset_file_upload_url_response import GetDatasetFileUploadURLResponse
from ri.apiclient.models.get_model_directory_upload_urls_request import GetModelDirectoryUploadURLsRequest
from ri.apiclient.models.get_model_directory_upload_urls_response import GetModelDirectoryUploadURLsResponse
from ri.apiclient.models.list_uploaded_file_urls_response import ListUploadedFileURLsResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class FileUploadApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def delete_uploaded_file_url(
        self,
        uploaded_url: str,
    ) -> object:
        """DeleteUploadedFileURL

        Deletes the uploaded dataset at the specified URL from the blob store.

        :param uploaded_url: URL of the uploaded file to delete. (required)
        :type uploaded_url: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_uploaded_file_url_serialize(
            uploaded_url=uploaded_url,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_uploaded_file_url_serialize(
        self,
        uploaded_url,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if uploaded_url is not None:
            
            _query_params.append(('uploadedUrl', uploaded_url))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1-beta/datasets/upload-url',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_dataset_file_upload_url(
        self,
        file_name: str,
        upload_path: Optional[str] = None,
    ) -> GetDatasetFileUploadURLResponse:
        """GetDatasetFileUploadURL

        Returns a pre-signed upload URL for a dataset.  File uploading is not currently supported in a Cloud deployment. Please use an external data source instead.

        :param file_name: Path of dataset file on the local file system. (required)
        :type file_name: str
        :param upload_path: Specify a path in the blob store to use for data uploads.
        :type upload_path: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_dataset_file_upload_url_serialize(
            file_name=file_name,
            upload_path=upload_path,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetDatasetFileUploadURLResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_dataset_file_upload_url_serialize(
        self,
        file_name,
        upload_path,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if file_name is not None:
            
            _query_params.append(('fileName', file_name))
            
        if upload_path is not None:
            
            _query_params.append(('uploadPath', upload_path))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/datasets/upload-url',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_dataset_file_upload_url2(
        self,
        file_name: str,
        upload_path: Optional[str] = None,
    ) -> GetDatasetFileUploadURLResponse:
        """GetDatasetFileUploadURL

        Returns a pre-signed upload URL for a dataset.  File uploading is not currently supported in a Cloud deployment. Please use an external data source instead.

        :param file_name: Path of dataset file on the local file system. (required)
        :type file_name: str
        :param upload_path: Specify a path in the blob store to use for data uploads.
        :type upload_path: str
        :return: Returns the result object.
        """ # noqa: E501

        body = GetDatasetFileUploadURLRequest(
          file_name=file_name,
          upload_path=upload_path,
        )

        _param = self._get_dataset_file_upload_url2_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetDatasetFileUploadURLResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_dataset_file_upload_url2_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/datasets/upload-url',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_model_directory_upload_urls(
        self,
        directory_name: str,
        relative_file_paths: List[str],
        upload_path: Optional[str] = None,
    ) -> GetModelDirectoryUploadURLsResponse:
        """GetModelDirectoryUploadURL

        Returns a pre-signed upload URL for a model directory.  File uploading is not currently supported in a Cloud deployment. Please use an external data source instead.

        :param directory_name: Path of model directory on local file system. (required)
        :type directory_name: str
        :param relative_file_paths: Array of relative paths from the model directory to model files. (required)
        :type relative_file_paths: List[str]
        :param upload_path: Specify a path in the blob store to which the model will be uploaded.
        :type upload_path: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_model_directory_upload_urls_serialize(
            directory_name=directory_name,
            relative_file_paths=relative_file_paths,
            upload_path=upload_path,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetModelDirectoryUploadURLsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_model_directory_upload_urls_serialize(
        self,
        directory_name,
        relative_file_paths,
        upload_path,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'relativeFilePaths': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if directory_name is not None:
            
            _query_params.append(('directoryName', directory_name))
            
        if relative_file_paths is not None:
            
            _query_params.append(('relativeFilePaths', relative_file_paths))
            
        if upload_path is not None:
            
            _query_params.append(('uploadPath', upload_path))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/models/upload-url',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_model_directory_upload_urls2(
        self,
        directory_name: str,
        relative_file_paths: List[str],
        upload_path: Optional[str] = None,
    ) -> GetModelDirectoryUploadURLsResponse:
        """GetModelDirectoryUploadURL

        Returns a pre-signed upload URL for a model directory.  File uploading is not currently supported in a Cloud deployment. Please use an external data source instead.

        :param directory_name: Path of model directory on local file system. (required)
        :type directory_name: str
        :param relative_file_paths: Array of relative paths from the model directory to model files. (required)
        :type relative_file_paths: List[str]
        :param upload_path: Specify a path in the blob store to which the model will be uploaded.
        :type upload_path: str
        :return: Returns the result object.
        """ # noqa: E501

        body = GetModelDirectoryUploadURLsRequest(
          directory_name=directory_name,
          relative_file_paths=relative_file_paths,
          upload_path=upload_path,
        )

        _param = self._get_model_directory_upload_urls2_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetModelDirectoryUploadURLsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_model_directory_upload_urls2_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/models/upload-url',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_uploaded_file_urls(
        self,
    ) -> ListUploadedFileURLsResponse:
        """ListUploadedFileURLs

        List up to 1000 blob store URLs for uploaded files.  File uploading is not currently supported in a Cloud deployment. Please use an external data source instead.

        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_uploaded_file_urls_serialize(
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListUploadedFileURLsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_uploaded_file_urls_serialize(
        self,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/uploaded-file-urls',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
