# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Any, Dict
from typing_extensions import Annotated
from ri.apiclient.models.create_firewall_request import CreateFirewallRequest
from ri.apiclient.models.create_firewall_response import CreateFirewallResponse
from ri.apiclient.models.get_firewall_response import GetFirewallResponse
from ri.apiclient.models.get_url_response import GetURLResponse
from ri.apiclient.models.update_firewall_request import UpdateFirewallRequest
from ri.apiclient.models.update_firewall_response import UpdateFirewallResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class FirewallServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_firewall(
        self,
        bin_size: str,
        ref_data_id: str,
        model_id: Optional[ID] = None,
        project_id: Optional[ID] = None,
        scheduled_ct_parameters: Optional[ScheduledCTParameters] = None,
    ) -> CreateFirewallResponse:
        """(Deprecated) CreateFirewall

        Creates a firewall with the required fields. This service is deprecated in Robust Intelligence v2.2 and will not be supported from v2.4.

        :param bin_size: Duration of each bin size of continuous tests. (required)
        :type bin_size: str
        :param ref_data_id: Uniquely specifies a reference data set. (required)
        :type ref_data_id: str
        :param model_id:
        :type model_id: ID
        :param project_id:
        :type project_id: ID
        :param scheduled_ct_parameters:
        :type scheduled_ct_parameters: ScheduledCTParameters
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v1/firewall is deprecated.", DeprecationWarning)

        body = CreateFirewallRequest(
          bin_size=bin_size,
          model_id=model_id,
          project_id=project_id,
          ref_data_id=ref_data_id,
          scheduled_ct_parameters=scheduled_ct_parameters,
        )

        _param = self._create_firewall_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateFirewallResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_firewall_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/firewall',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_firewall(
        self,
        firewall_id_uuid: str,
    ) -> object:
        """(Deprecated) DeleteFirewall

        Deletes the firewall with the specified ID. This service is deprecated in Robust Intelligence v2.2 and will not be supported from v2.4.

        :param firewall_id_uuid: Unique object ID. (required)
        :type firewall_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("DELETE /v1/firewall/{firewallId.uuid} is deprecated.", DeprecationWarning)


        _param = self._delete_firewall_serialize(
            firewall_id_uuid=firewall_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_firewall_serialize(
        self,
        firewall_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if firewall_id_uuid is not None:
            _path_params['firewallId.uuid'] = firewall_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/firewall/{firewallId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_firewall(
        self,
        firewall_id_uuid: str,
    ) -> GetFirewallResponse:
        """(Deprecated) GetFirewall

        Gets the firewall that matches the specified ID. This service is deprecated in Robust Intelligence v2.2 and will not be supported from v2.4.

        :param firewall_id_uuid: Unique object ID. (required)
        :type firewall_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v1/firewall/{firewallId.uuid} is deprecated.", DeprecationWarning)


        _param = self._get_firewall_serialize(
            firewall_id_uuid=firewall_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFirewallResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_firewall_serialize(
        self,
        firewall_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if firewall_id_uuid is not None:
            _path_params['firewallId.uuid'] = firewall_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/firewall/{firewallId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_url(
        self,
        firewall_id_uuid: str,
    ) -> GetURLResponse:
        """(Deprecated) GetURL

        Returns the URL for the specified Firewall in the Robust Intelligence web application. This service is deprecated in Robust Intelligence v2.2 and will not be supported from v2.4.

        :param firewall_id_uuid: Unique object ID. (required)
        :type firewall_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v1-beta/firewall/{firewallId.uuid}/url is deprecated.", DeprecationWarning)


        _param = self._get_url_serialize(
            firewall_id_uuid=firewall_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetURLResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_url_serialize(
        self,
        firewall_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if firewall_id_uuid is not None:
            _path_params['firewallId.uuid'] = firewall_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/firewall/{firewallId.uuid}/url',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_firewall(
        self,
        firewall_firewall_id_uuid: str,
        firewall: Optional[UpdateFirewallRequestFirewall] = None,
        firewall_id: Optional[ID] = None,
        mask: Optional[str] = None,
    ) -> UpdateFirewallResponse:
        """(Deprecated) UpdateFirewall

        Updates a firewall's editable fields. This service is deprecated in Robust Intelligence v2.2 and will not be supported from v2.4.

        :param firewall_firewall_id_uuid: Unique object ID. (required)
        :type firewall_firewall_id_uuid: str
        :param firewall:
        :type firewall: UpdateFirewallRequestFirewall
        :param firewall_id:
        :type firewall_id: ID
        :param mask: Field mask specifies which fields of the firewall to update.
        :type mask: str
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /v1/firewall/{firewall.firewallId.uuid} is deprecated.", DeprecationWarning)

        body = UpdateFirewallRequest(
          firewall=firewall,
          firewall_id=firewall_id,
          mask=mask,
        )

        _param = self._update_firewall_serialize(
            firewall_firewall_id_uuid=firewall_firewall_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateFirewallResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_firewall_serialize(
        self,
        firewall_firewall_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if firewall_firewall_id_uuid is not None:
            _path_params['firewall.firewallId.uuid'] = firewall_firewall_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/firewall/{firewall.firewallId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
