# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from ri.apiclient.models.generativevalidation_get_test_run_response import GenerativevalidationGetTestRunResponse
from ri.apiclient.models.generativevalidation_list_test_runs_response import GenerativevalidationListTestRunsResponse
from ri.apiclient.models.get_results_response import GetResultsResponse
from ri.apiclient.models.start_test_request import StartTestRequest
from ri.apiclient.models.start_test_response import StartTestResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class GenerativeValidationApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def demo_scan(
        self,
        agent_id: Optional[ID] = None,
        aws_integration_id: Optional[ID] = None,
        body: Optional[Body] = None,
        endpoint_payload_template: Optional[str] = None,
        http_auth_integration_id: Optional[ID] = None,
        http_headers: Optional[Dict[str, str]] = None,
        model_id: Optional[str] = None,
        mutual_tls_integration_id: Optional[ID] = None,
        name: Optional[str] = None,
        response_json_path: Optional[str] = None,
        system_prompt: Optional[str] = None,
        url: Optional[str] = None,
        workspace_id: Optional[ID] = None,
    ) -> StartTestResponse:
        """Start Generative AI Validation Demo Scan

        Starts an AI Validation demo scan on the specified generative model.  Results for this are not comprehensive. The status of the job can be tracked through the [JobReader service](#tag/JobReader). The results can of the test  can be retrieved using the [Results endpoint](#tag/GenerativeModelTesting/operation/Results).

        :param agent_id:
        :type agent_id: ID
        :param aws_integration_id:
        :type aws_integration_id: ID
        :param body:
        :type body: Body
        :param endpoint_payload_template: A string template that will be used to create the json payload sent to the LLM endpoint. This template must contain one and only one variable -- prompt_string. This will be replaced at runtime with the prompt used to send to the model. Used for arbitrary HTTP requests to models.  The template uses \" and \" as the opening and closing delimiters around the prompt_string variable name.  Example: '{ \"prompt\": \"{{prompt_string}}\" }' Example: '{ \"message\": { \"llm_prompt\": \"{{prompt_string}}\" } }'
        :type endpoint_payload_template: str
        :param http_auth_integration_id:
        :type http_auth_integration_id: ID
        :param http_headers:
        :type http_headers: Dict[str, str]
        :param model_id: If aws_integration_id is set, this field will be the model id used for generative validation for bedrock.
        :type model_id: str
        :param mutual_tls_integration_id:
        :type mutual_tls_integration_id: ID
        :param name: The name to identify the generative model testing job.
        :type name: str
        :param response_json_path: A json path specifying where in the HTTP response json payload we can find the LLM's response string. Note that the path must point to a string value in the json payload. Whitespace and other special characters can be encoded as unicode (\\u0020). Periods in json fields can be escaped with a backslash.  Example (top level field): - Endpoint response json: {\"response\": \"I am an AI Chatbot, how can I assist you?\"} - response_json_path: \"response\"  Example (nested json field): - Endpoint response json: {\"response\": {\"llmResponse\": \"I am an AI Chatbot, how can I assist you?\"}} - response_json_path: \"response.llmResponse\"  Example (extract string from array): - Endpoint response: {\"response\": {\"options\": [\"Hi\", \"Hello there\"], \"count\": 2}} - response_json_path: \"response.options.1\"  Example (periods in field names): - Endpoint response: {\"llm.response\": \"hello\"} - response_json_path: \"llm\\\\.response\"  The syntax uses dot notation only, such as \"myfield.myotherfield\" or \"myarray.1\".
        :type response_json_path: str
        :param system_prompt: The system prompt that is currently active on the provided endpoint.
        :type system_prompt: str
        :param url: Parameters for connecting to the user's generative model.
        :type url: str
        :param workspace_id:
        :type workspace_id: ID
        :return: Returns the result object.
        """ # noqa: E501

        body = StartTestRequest(
          agent_id=agent_id,
          aws_integration_id=aws_integration_id,
          body=body,
          endpoint_payload_template=endpoint_payload_template,
          http_auth_integration_id=http_auth_integration_id,
          http_headers=http_headers,
          model_id=model_id,
          mutual_tls_integration_id=mutual_tls_integration_id,
          name=name,
          response_json_path=response_json_path,
          system_prompt=system_prompt,
          url=url,
          workspace_id=workspace_id,
        )

        _param = self._demo_scan_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StartTestResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _demo_scan_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/generative/testing/demo',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def quick_scan(
        self,
        agent_id: Optional[ID] = None,
        aws_integration_id: Optional[ID] = None,
        body: Optional[Body] = None,
        endpoint_payload_template: Optional[str] = None,
        http_auth_integration_id: Optional[ID] = None,
        http_headers: Optional[Dict[str, str]] = None,
        model_id: Optional[str] = None,
        mutual_tls_integration_id: Optional[ID] = None,
        name: Optional[str] = None,
        response_json_path: Optional[str] = None,
        system_prompt: Optional[str] = None,
        url: Optional[str] = None,
        workspace_id: Optional[ID] = None,
    ) -> StartTestResponse:
        """Start Generative AI Validation Quick Scan

        Starts an AI Validation quick scan on the specified generative model.  Results for this are not comprehensive. The status of the job can be tracked through the [JobReader service](#tag/JobReader). The results can of the test  can be retrieved using the [Results endpoint](#tag/GenerativeModelTesting/operation/Results).

        :param agent_id:
        :type agent_id: ID
        :param aws_integration_id:
        :type aws_integration_id: ID
        :param body:
        :type body: Body
        :param endpoint_payload_template: A string template that will be used to create the json payload sent to the LLM endpoint. This template must contain one and only one variable -- prompt_string. This will be replaced at runtime with the prompt used to send to the model. Used for arbitrary HTTP requests to models.  The template uses \" and \" as the opening and closing delimiters around the prompt_string variable name.  Example: '{ \"prompt\": \"{{prompt_string}}\" }' Example: '{ \"message\": { \"llm_prompt\": \"{{prompt_string}}\" } }'
        :type endpoint_payload_template: str
        :param http_auth_integration_id:
        :type http_auth_integration_id: ID
        :param http_headers:
        :type http_headers: Dict[str, str]
        :param model_id: If aws_integration_id is set, this field will be the model id used for generative validation for bedrock.
        :type model_id: str
        :param mutual_tls_integration_id:
        :type mutual_tls_integration_id: ID
        :param name: The name to identify the generative model testing job.
        :type name: str
        :param response_json_path: A json path specifying where in the HTTP response json payload we can find the LLM's response string. Note that the path must point to a string value in the json payload. Whitespace and other special characters can be encoded as unicode (\\u0020). Periods in json fields can be escaped with a backslash.  Example (top level field): - Endpoint response json: {\"response\": \"I am an AI Chatbot, how can I assist you?\"} - response_json_path: \"response\"  Example (nested json field): - Endpoint response json: {\"response\": {\"llmResponse\": \"I am an AI Chatbot, how can I assist you?\"}} - response_json_path: \"response.llmResponse\"  Example (extract string from array): - Endpoint response: {\"response\": {\"options\": [\"Hi\", \"Hello there\"], \"count\": 2}} - response_json_path: \"response.options.1\"  Example (periods in field names): - Endpoint response: {\"llm.response\": \"hello\"} - response_json_path: \"llm\\\\.response\"  The syntax uses dot notation only, such as \"myfield.myotherfield\" or \"myarray.1\".
        :type response_json_path: str
        :param system_prompt: The system prompt that is currently active on the provided endpoint.
        :type system_prompt: str
        :param url: Parameters for connecting to the user's generative model.
        :type url: str
        :param workspace_id:
        :type workspace_id: ID
        :return: Returns the result object.
        """ # noqa: E501

        body = StartTestRequest(
          agent_id=agent_id,
          aws_integration_id=aws_integration_id,
          body=body,
          endpoint_payload_template=endpoint_payload_template,
          http_auth_integration_id=http_auth_integration_id,
          http_headers=http_headers,
          model_id=model_id,
          mutual_tls_integration_id=mutual_tls_integration_id,
          name=name,
          response_json_path=response_json_path,
          system_prompt=system_prompt,
          url=url,
          workspace_id=workspace_id,
        )

        _param = self._quick_scan_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StartTestResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _quick_scan_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/generative/testing/quick',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def results(
        self,
        test_run_id_uuid: str,
        page_token: Optional[str] = None,
        page_size: Optional[int] = None,
    ) -> GetResultsResponse:
        """Get Generative AI Validation Results

        Retrieve the results of a generative model testing for a successful job. This is a paginated API.

        :param test_run_id_uuid: Unique object ID. (required)
        :type test_run_id_uuid: str
        :param page_token: A token representing one page from the list returned by a GetResults API. The GetResults API returns a page_token when there is more than one page of results.
        :type page_token: str
        :param page_size: The maximum number of objects to return in a single page.  Maximum page size is 1000.
        :type page_size: int
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._results_serialize(
            test_run_id_uuid=test_run_id_uuid,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetResultsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _results_serialize(
        self,
        test_run_id_uuid,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if test_run_id_uuid is not None:
            _path_params['testRunId.uuid'] = test_run_id_uuid
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/generative/testing/{testRunId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def start_generative_test(
        self,
        agent_id: Optional[ID] = None,
        aws_integration_id: Optional[ID] = None,
        body: Optional[Body] = None,
        endpoint_payload_template: Optional[str] = None,
        http_auth_integration_id: Optional[ID] = None,
        http_headers: Optional[Dict[str, str]] = None,
        model_id: Optional[str] = None,
        mutual_tls_integration_id: Optional[ID] = None,
        name: Optional[str] = None,
        response_json_path: Optional[str] = None,
        system_prompt: Optional[str] = None,
        url: Optional[str] = None,
        workspace_id: Optional[ID] = None,
    ) -> StartTestResponse:
        """Start a Generative AI Validation Test

        Starts an AI validation test on the specified generative model. Generative testing is designed to work with a model that is served over an HTTP endpoint that returns JSON. It assumes that the model is a Q&A style model which takes a prompt as an input and returns a single textual response. See the API details for supported features, such as system prompt.  The status of the job can be tracked through the [JobReader service](#tag/JobReader). The results of the test can be retrieved using the [Results endpoint](#tag/GenerativeModelTesting/operation/Results).

        :param agent_id:
        :type agent_id: ID
        :param aws_integration_id:
        :type aws_integration_id: ID
        :param body:
        :type body: Body
        :param endpoint_payload_template: A string template that will be used to create the json payload sent to the LLM endpoint. This template must contain one and only one variable -- prompt_string. This will be replaced at runtime with the prompt used to send to the model. Used for arbitrary HTTP requests to models.  The template uses \" and \" as the opening and closing delimiters around the prompt_string variable name.  Example: '{ \"prompt\": \"{{prompt_string}}\" }' Example: '{ \"message\": { \"llm_prompt\": \"{{prompt_string}}\" } }'
        :type endpoint_payload_template: str
        :param http_auth_integration_id:
        :type http_auth_integration_id: ID
        :param http_headers:
        :type http_headers: Dict[str, str]
        :param model_id: If aws_integration_id is set, this field will be the model id used for generative validation for bedrock.
        :type model_id: str
        :param mutual_tls_integration_id:
        :type mutual_tls_integration_id: ID
        :param name: The name to identify the generative model testing job.
        :type name: str
        :param response_json_path: A json path specifying where in the HTTP response json payload we can find the LLM's response string. Note that the path must point to a string value in the json payload. Whitespace and other special characters can be encoded as unicode (\\u0020). Periods in json fields can be escaped with a backslash.  Example (top level field): - Endpoint response json: {\"response\": \"I am an AI Chatbot, how can I assist you?\"} - response_json_path: \"response\"  Example (nested json field): - Endpoint response json: {\"response\": {\"llmResponse\": \"I am an AI Chatbot, how can I assist you?\"}} - response_json_path: \"response.llmResponse\"  Example (extract string from array): - Endpoint response: {\"response\": {\"options\": [\"Hi\", \"Hello there\"], \"count\": 2}} - response_json_path: \"response.options.1\"  Example (periods in field names): - Endpoint response: {\"llm.response\": \"hello\"} - response_json_path: \"llm\\\\.response\"  The syntax uses dot notation only, such as \"myfield.myotherfield\" or \"myarray.1\".
        :type response_json_path: str
        :param system_prompt: The system prompt that is currently active on the provided endpoint.
        :type system_prompt: str
        :param url: Parameters for connecting to the user's generative model.
        :type url: str
        :param workspace_id:
        :type workspace_id: ID
        :return: Returns the result object.
        """ # noqa: E501

        body = StartTestRequest(
          agent_id=agent_id,
          aws_integration_id=aws_integration_id,
          body=body,
          endpoint_payload_template=endpoint_payload_template,
          http_auth_integration_id=http_auth_integration_id,
          http_headers=http_headers,
          model_id=model_id,
          mutual_tls_integration_id=mutual_tls_integration_id,
          name=name,
          response_json_path=response_json_path,
          system_prompt=system_prompt,
          url=url,
          workspace_id=workspace_id,
        )

        _param = self._start_generative_test_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StartTestResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _start_generative_test_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/generative/testing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def test_run(
        self,
        test_run_id_uuid: str,
    ) -> GenerativevalidationGetTestRunResponse:
        """Get Generative AI Validation Test Run

        Retrieves a generative validation test run by ID.

        :param test_run_id_uuid: Unique object ID. (required)
        :type test_run_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._test_run_serialize(
            test_run_id_uuid=test_run_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GenerativevalidationGetTestRunResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _test_run_serialize(
        self,
        test_run_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if test_run_id_uuid is not None:
            _path_params['testRunId.uuid'] = test_run_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/generative/testing/runs/{testRunId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def test_runs(
        self,
        workspace_id_uuid: str,
        page_token: Optional[str] = None,
        page_size: Optional[int] = None,
    ) -> GenerativevalidationListTestRunsResponse:
        """List Generative AI Validation Test Runs

        Retrieves generative validation test runs for a workspace.  This is a paginated API.

        :param workspace_id_uuid: Unique object ID. (required)
        :type workspace_id_uuid: str
        :param page_token: A token representing one page from the list returned by a GetGenerativeModelTestResults API. The GetGenerativeModelTestResults API returns a page_token when there is more than one page of results.
        :type page_token: str
        :param page_size: The maximum number of objects to return in a single page.  Maximum page size is 1000.
        :type page_size: int
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._test_runs_serialize(
            workspace_id_uuid=workspace_id_uuid,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GenerativevalidationListTestRunsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _test_runs_serialize(
        self,
        workspace_id_uuid,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if workspace_id_uuid is not None:
            _path_params['workspaceId.uuid'] = workspace_id_uuid
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/generative/testing/workspaces/{workspaceId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
