# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Any, Dict
from typing_extensions import Annotated
from ri.apiclient.models.configure_integration_request import ConfigureIntegrationRequest
from ri.apiclient.models.configure_integration_response import ConfigureIntegrationResponse
from ri.apiclient.models.create_integration_request import CreateIntegrationRequest
from ri.apiclient.models.create_integration_response import CreateIntegrationResponse
from ri.apiclient.models.get_integration_response import GetIntegrationResponse
from ri.apiclient.models.list_workspace_integrations_response import ListWorkspaceIntegrationsResponse
from ri.apiclient.models.update_integration_request import UpdateIntegrationRequest
from ri.apiclient.models.update_integration_response import UpdateIntegrationResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class IntegrationServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def configure_integration(
        self,
        integration_id_uuid: str,
        variables: List[ConfigureIntegrationRequestIntegrationVariable],
        integration_id: Optional[object] = None,
    ) -> ConfigureIntegrationResponse:
        """ConfigureIntegration

        Configures the Integration with specified ID.

        :param integration_id_uuid: Unique object ID. (required)
        :type integration_id_uuid: str
        :param variables: (required)
        :type variables: List[ConfigureIntegrationRequestIntegrationVariable]
        :param integration_id: Unique ID of an object in RIME.
        :type integration_id: object
        :return: Returns the result object.
        """ # noqa: E501

        body = ConfigureIntegrationRequest(
          integration_id=integration_id,
          variables=variables,
        )

        _param = self._configure_integration_serialize(
            integration_id_uuid=integration_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConfigureIntegrationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _configure_integration_serialize(
        self,
        integration_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if integration_id_uuid is not None:
            _path_params['integrationId.uuid'] = integration_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/integrations/{integrationId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def create_integration(
        self,
        integration: Optional[Integration] = None,
    ) -> CreateIntegrationResponse:
        """CreateIntegration

        Creates a new Integration.

        :param integration:
        :type integration: Integration
        :return: Returns the result object.
        """ # noqa: E501

        body = CreateIntegrationRequest(
          integration=integration,
        )

        _param = self._create_integration_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateIntegrationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_integration_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/integrations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_integration(
        self,
        integration_id_uuid: str,
    ) -> object:
        """DeleteIntegration

        Delete an Integration by specified ID.

        :param integration_id_uuid: Unique object ID. (required)
        :type integration_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_integration_serialize(
            integration_id_uuid=integration_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_integration_serialize(
        self,
        integration_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if integration_id_uuid is not None:
            _path_params['integrationId.uuid'] = integration_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1-beta/integrations/{integrationId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_integration(
        self,
        integration_id_uuid: str,
    ) -> GetIntegrationResponse:
        """GetIntegration

        Returns an Integration by specified ID.

        :param integration_id_uuid: Unique object ID. (required)
        :type integration_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_integration_serialize(
            integration_id_uuid=integration_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetIntegrationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_integration_serialize(
        self,
        integration_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if integration_id_uuid is not None:
            _path_params['integrationId.uuid'] = integration_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/integrations/{integrationId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_workspace_integrations(
        self,
        workspace_id_uuid: str,
    ) -> ListWorkspaceIntegrationsResponse:
        """ListWorkspaceIntegrations

        List all Integrations for the Workspace with specified ID.

        :param workspace_id_uuid: Unique object ID. (required)
        :type workspace_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_workspace_integrations_serialize(
            workspace_id_uuid=workspace_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWorkspaceIntegrationsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_workspace_integrations_serialize(
        self,
        workspace_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if workspace_id_uuid is not None:
            _path_params['workspaceId.uuid'] = workspace_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/integrations/workspace/{workspaceId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_integration(
        self,
        integration_id_uuid: str,
        integration: Optional[UpdateIntegrationRequestIntegration] = None,
        mask: Optional[str] = None,
    ) -> UpdateIntegrationResponse:
        """UpdateIntegration

        Update the Integration with specified ID.

        :param integration_id_uuid: Unique object ID. (required)
        :type integration_id_uuid: str
        :param integration:
        :type integration: UpdateIntegrationRequestIntegration
        :param mask:
        :type mask: str
        :return: Returns the result object.
        """ # noqa: E501

        body = UpdateIntegrationRequest(
          integration=integration,
          mask=mask,
        )

        _param = self._update_integration_serialize(
            integration_id_uuid=integration_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateIntegrationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_integration_serialize(
        self,
        integration_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if integration_id_uuid is not None:
            _path_params['integration.id.uuid'] = integration_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1-beta/integrations/{integration.id.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
