# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictStr, field_validator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from ri.apiclient.models.create_custom_monitor_request import CreateCustomMonitorRequest
from ri.apiclient.models.create_custom_monitor_response import CreateCustomMonitorResponse
from ri.apiclient.models.get_monitor_result_response import GetMonitorResultResponse
from ri.apiclient.models.list_metric_identifiers_response import ListMetricIdentifiersResponse
from ri.apiclient.models.list_monitors_response import ListMonitorsResponse
from ri.apiclient.models.update_monitor_request import UpdateMonitorRequest
from ri.apiclient.models.update_monitor_response import UpdateMonitorResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class MonitorServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_custom_monitor(
        self,
        name: str,
        aggregation: Optional[Aggregation] = None,
        artifact_identifier: Optional[ArtifactIdentifier] = None,
        firewall_id: Optional[ID] = None,
        notify: Optional[bool] = None,
        threshold: Optional[Threshold] = None,
        transform: Optional[Transform] = None,
    ) -> CreateCustomMonitorResponse:
        """CreateCustomMonitor

        Create a new custom monitor

        :param name: The name of the monitor. (required)
        :type name: str
        :param aggregation:
        :type aggregation: Aggregation
        :param artifact_identifier:
        :type artifact_identifier: ArtifactIdentifier
        :param firewall_id:
        :type firewall_id: ID
        :param notify: Whether to notify when the monitor is triggered.
        :type notify: bool
        :param threshold:
        :type threshold: Threshold
        :param transform:
        :type transform: Transform
        :return: Returns the result object.
        """ # noqa: E501

        body = CreateCustomMonitorRequest(
          aggregation=aggregation,
          artifact_identifier=artifact_identifier,
          firewall_id=firewall_id,
          notify=notify,
          threshold=threshold,
          transform=transform,
        )

        _param = self._create_custom_monitor_serialize(
            name=name,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCustomMonitorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_custom_monitor_serialize(
        self,
        name,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if name is not None:
            _path_params['name'] = name
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/custom-monitors/{name}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_custom_monitor(
        self,
        monitor_id_uuid: str,
    ) -> object:
        """DeleteCustomMonitor

        Delete a custom monitor

        :param monitor_id_uuid: Unique object ID. (required)
        :type monitor_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_custom_monitor_serialize(
            monitor_id_uuid=monitor_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_custom_monitor_serialize(
        self,
        monitor_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if monitor_id_uuid is not None:
            _path_params['monitorId.uuid'] = monitor_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1-beta/custom-monitors/{monitorId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_monitor_result(
        self,
        monitor_id_uuid: str,
        time_interval_start_time: Optional[datetime] = None,
        time_interval_end_time: Optional[datetime] = None,
    ) -> GetMonitorResultResponse:
        """GetMonitorResult

        Graph a monitor within a time range

        :param monitor_id_uuid: Unique object ID. (required)
        :type monitor_id_uuid: str
        :param time_interval_start_time:
        :type time_interval_start_time: datetime
        :param time_interval_end_time:
        :type time_interval_end_time: datetime
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_monitor_result_serialize(
            monitor_id_uuid=monitor_id_uuid,
            time_interval_start_time=time_interval_start_time,
            time_interval_end_time=time_interval_end_time,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonitorResultResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_monitor_result_serialize(
        self,
        monitor_id_uuid,
        time_interval_start_time,
        time_interval_end_time,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if monitor_id_uuid is not None:
            _path_params['monitorId.uuid'] = monitor_id_uuid
        if time_interval_start_time is not None:
            if isinstance(time_interval_start_time, datetime):
                _query_params.append(
                    (
                        'timeInterval.startTime',
                        time_interval_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('timeInterval.startTime', time_interval_start_time))
            
        if time_interval_end_time is not None:
            if isinstance(time_interval_end_time, datetime):
                _query_params.append(
                    (
                        'timeInterval.endTime',
                        time_interval_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('timeInterval.endTime', time_interval_end_time))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/monitors/result/{monitorId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_metric_identifiers(
        self,
        firewall_id_uuid: str,
    ) -> ListMetricIdentifiersResponse:
        """ListMetricIdentifiers

        List all possible Custom Monitor Metric Identifiers

        :param firewall_id_uuid: Unique object ID. (required)
        :type firewall_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_metric_identifiers_serialize(
            firewall_id_uuid=firewall_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListMetricIdentifiersResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_metric_identifiers_serialize(
        self,
        firewall_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if firewall_id_uuid is not None:
            _path_params['firewallId.uuid'] = firewall_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/custom-monitors/metrics/{firewallId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_monitors(
        self,
        firewall_id_uuid: str,
        first_page_req_included_monitor_types: Optional[List[str]] = None,
        first_page_req_included_risk_category_types: Optional[List[str]] = None,
        first_page_req_pinned_monitors_only: Optional[bool] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListMonitorsResponse:
        """ListMonitors

        lists monitors by firewall ID.

        :param firewall_id_uuid: Unique object ID. (required)
        :type firewall_id_uuid: str
        :param first_page_req_included_monitor_types: Specifies a list of monitor types. Filters results to match the specified monitor types.
        :type first_page_req_included_monitor_types: List[str]
        :param first_page_req_included_risk_category_types: Specifies a list of risk category types. Filters results to match the specified risk category types.
        :type first_page_req_included_risk_category_types: List[str]
        :param first_page_req_pinned_monitors_only: When the value of this Boolean is True, this endpoint returns a list of pinned Monitors. Otherwise, this endpoint does not filter Monitors by pinned status.
        :type first_page_req_pinned_monitors_only: bool
        :param page_token: Specifies a page of the list returned by a ListMonitors query. The ListMonitors query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :type page_token: str
        :param page_size: The maximum number of Monitor objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_monitors_serialize(
            firewall_id_uuid=firewall_id_uuid,
            first_page_req_included_monitor_types=first_page_req_included_monitor_types,
            first_page_req_included_risk_category_types=first_page_req_included_risk_category_types,
            first_page_req_pinned_monitors_only=first_page_req_pinned_monitors_only,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListMonitorsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_monitors_serialize(
        self,
        firewall_id_uuid,
        first_page_req_included_monitor_types,
        first_page_req_included_risk_category_types,
        first_page_req_pinned_monitors_only,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'firstPageReq.includedMonitorTypes': 'multi',
            'firstPageReq.includedRiskCategoryTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if firewall_id_uuid is not None:
            _path_params['firewallId.uuid'] = firewall_id_uuid
        if first_page_req_included_monitor_types is not None:
            
            _query_params.append(('firstPageReq.includedMonitorTypes', first_page_req_included_monitor_types))
            
        if first_page_req_included_risk_category_types is not None:
            
            _query_params.append(('firstPageReq.includedRiskCategoryTypes', first_page_req_included_risk_category_types))
            
        if first_page_req_pinned_monitors_only is not None:
            
            _query_params.append(('firstPageReq.pinnedMonitorsOnly', first_page_req_pinned_monitors_only))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/monitors/{firewallId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_monitor(
        self,
        monitor_id_uuid: str,
        mask: Optional[str] = None,
        monitor: Optional[UpdateMonitorRequestMonitor] = None,
    ) -> UpdateMonitorResponse:
        """UpdateMonitor

        Updates a monitor.

        :param monitor_id_uuid: Unique object ID. (required)
        :type monitor_id_uuid: str
        :param mask: The field mask.
        :type mask: str
        :param monitor:
        :type monitor: UpdateMonitorRequestMonitor
        :return: Returns the result object.
        """ # noqa: E501

        body = UpdateMonitorRequest(
          mask=mask,
          monitor=monitor,
        )

        _param = self._update_monitor_serialize(
            monitor_id_uuid=monitor_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateMonitorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_monitor_serialize(
        self,
        monitor_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if monitor_id_uuid is not None:
            _path_params['monitor.id.uuid'] = monitor_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1-beta/monitors/{monitor.id.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
