# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr, field_validator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from ri.apiclient.models.create_notification_request import CreateNotificationRequest
from ri.apiclient.models.create_notification_response import CreateNotificationResponse
from ri.apiclient.models.list_notifications_response import ListNotificationsResponse
from ri.apiclient.models.update_notification_request import UpdateNotificationRequest
from ri.apiclient.models.update_notification_response import UpdateNotificationResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class NotificationSettingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_notification(
        self,
        object_id: str,
        config: Optional[NotificationConfig] = None,
        emails: Optional[List[str]] = None,
        object_type: Optional[ObjectType] = None,
        webhooks: Optional[List[WebhookConfig]] = None,
    ) -> CreateNotificationResponse:
        """CreateNotification

        Creates a new notification setting.

        :param object_id: Uniquely specifies an object for the notification. This varies depending on the object type; for Projects, this should be the unique identifier of the project. (required)
        :type object_id: str
        :param config:
        :type config: NotificationConfig
        :param emails: List of emails that notifications should be sent to - this can be empty.
        :type emails: List[str]
        :param object_type:
        :type object_type: ObjectType
        :param webhooks: List of webhooks that notifications should be sent to - this can be empty.
        :type webhooks: List[WebhookConfig]
        :return: Returns the result object.
        """ # noqa: E501

        body = CreateNotificationRequest(
          config=config,
          emails=emails,
          object_id=object_id,
          object_type=object_type,
          webhooks=webhooks,
        )

        _param = self._create_notification_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNotificationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_notification_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/notif-settings',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_notification(
        self,
        id_uuid: str,
    ) -> object:
        """DeleteNotification

        Hard-delete a notification setting.

        :param id_uuid: Unique object ID. (required)
        :type id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_notification_serialize(
            id_uuid=id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_notification_serialize(
        self,
        id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if id_uuid is not None:
            _path_params['id.uuid'] = id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/notif-settings/{id.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_notifications(
        self,
        list_notifications_query_object_types: Optional[List[str]] = None,
        list_notifications_query_object_ids: Optional[List[str]] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListNotificationsResponse:
        """ListNotifications

        Lists notification settings with options to filter by project or the type of notification.

        :param list_notifications_query_object_types: Specifies a set of object types. Filters results by the specified set of object types.   - OBJECT_TYPE_PROJECT: Used for notifications associated with an project. The Notification object ID is the Project ID.
        :type list_notifications_query_object_types: List[str]
        :param list_notifications_query_object_ids: Specifies a set of object IDs. Filters results by the specified set of object IDs.
        :type list_notifications_query_object_ids: List[str]
        :param page_token: Specifies a page of the list returned by a ListNotifications query. The ListNotifications query returns a pageToken when there is more than one page of results. Specify either this field or the listNotificationsQuery field.
        :type page_token: str
        :param page_size: The maximum number of Notification objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_notifications_serialize(
            list_notifications_query_object_types=list_notifications_query_object_types,
            list_notifications_query_object_ids=list_notifications_query_object_ids,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListNotificationsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_notifications_serialize(
        self,
        list_notifications_query_object_types,
        list_notifications_query_object_ids,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'listNotificationsQuery.objectTypes': 'multi',
            'listNotificationsQuery.objectIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if list_notifications_query_object_types is not None:
            
            _query_params.append(('listNotificationsQuery.objectTypes', list_notifications_query_object_types))
            
        if list_notifications_query_object_ids is not None:
            
            _query_params.append(('listNotificationsQuery.objectIds', list_notifications_query_object_ids))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/notif-settings',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_notification(
        self,
        notification_id_uuid: str,
        mask: Optional[str] = None,
        notification: Optional[UpdateNotificationRequestNotification] = None,
    ) -> UpdateNotificationResponse:
        """UpdateNotification

        Updates an existing notification setting. The ID in the provided notification is used to identify it.

        :param notification_id_uuid: Unique object ID. (required)
        :type notification_id_uuid: str
        :param mask: Mask for determining which fields of the notification setting should be written in the Update. Specify a mask as a `.` separated path of field names e.g. `foo.bar` for nested field `bar` in submessage `foo`. Note: some fields are marked immutable and cannot be changed.
        :type mask: str
        :param notification:
        :type notification: UpdateNotificationRequestNotification
        :return: Returns the result object.
        """ # noqa: E501

        body = UpdateNotificationRequest(
          mask=mask,
          notification=notification,
        )

        _param = self._update_notification_serialize(
            notification_id_uuid=notification_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateNotificationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_notification_serialize(
        self,
        notification_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if notification_id_uuid is not None:
            _path_params['notification.id.uuid'] = notification_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/notif-settings/{notification.id.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
