# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictStr, field_validator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from ri.apiclient.models.activate_schedule_for_project_request import ActivateScheduleForProjectRequest
from ri.apiclient.models.activate_schedule_for_project_response import ActivateScheduleForProjectResponse
from ri.apiclient.models.add_users_to_project_request import AddUsersToProjectRequest
from ri.apiclient.models.create_project_request import CreateProjectRequest
from ri.apiclient.models.create_project_response import CreateProjectResponse
from ri.apiclient.models.get_project_response import GetProjectResponse
from ri.apiclient.models.get_project_url_response import GetProjectURLResponse
from ri.apiclient.models.get_workspace_roles_for_project_response import GetWorkspaceRolesForProjectResponse
from ri.apiclient.models.list_projects_response import ListProjectsResponse
from ri.apiclient.models.list_users_of_project_response import ListUsersOfProjectResponse
from ri.apiclient.models.update_project_request import UpdateProjectRequest
from ri.apiclient.models.update_project_response import UpdateProjectResponse
from ri.apiclient.models.update_user_of_project_request import UpdateUserOfProjectRequest
from ri.apiclient.models.update_workspace_roles_for_project_request import UpdateWorkspaceRolesForProjectRequest
from ri.apiclient.models.update_workspace_roles_for_project_response import UpdateWorkspaceRolesForProjectResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class ProjectServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def activate_schedule_for_project(
        self,
        project_id_uuid: str,
        schedule_id_uuid: str,
        project_id: Optional[object] = None,
        schedule_id: Optional[object] = None,
    ) -> ActivateScheduleForProjectResponse:
        """ActivateScheduleForProject

        Add a Schedule to run automatic tests for a Project.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param schedule_id_uuid: Unique object ID. (required)
        :type schedule_id_uuid: str
        :param project_id: Unique ID of an object in RIME.
        :type project_id: object
        :param schedule_id: Unique ID of an object in RIME.
        :type schedule_id: object
        :return: Returns the result object.
        """ # noqa: E501

        body = ActivateScheduleForProjectRequest(
          project_id=project_id,
          schedule_id=schedule_id,
        )

        _param = self._activate_schedule_for_project_serialize(
            project_id_uuid=project_id_uuid,
            schedule_id_uuid=schedule_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActivateScheduleForProjectResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _activate_schedule_for_project_serialize(
        self,
        project_id_uuid,
        schedule_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if schedule_id_uuid is not None:
            _path_params['scheduleId.uuid'] = schedule_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1-beta/projects/{projectId.uuid}/schedule/{scheduleId.uuid}/activate',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def add_users_to_project(
        self,
        project_id_uuid: str,
        project_id: Optional[object] = None,
        users: Optional[List[UserWithRole]] = None,
    ) -> object:
        """AddUsersToProject

        Grants existing Organization users permissions to a Project for a given Project ID, based on the pairs of role and User ID provided in the request.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param project_id: Uniquely specifies a Project.
        :type project_id: object
        :param users: Pairs of users and their roles for the Project.
        :type users: List[UserWithRole]
        :return: Returns the result object.
        """ # noqa: E501

        body = AddUsersToProjectRequest(
          project_id=project_id,
          users=users,
        )

        _param = self._add_users_to_project_serialize(
            project_id_uuid=project_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _add_users_to_project_serialize(
        self,
        project_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/projects/{projectId.uuid}/role/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def create_project(
        self,
        description: str,
        name: str,
        ethical_consideration: Optional[str] = None,
        is_published: Optional[bool] = None,
        model_task: Optional[ModelTask] = None,
        profiling_config: Optional[ProfilingConfig] = None,
        run_time_info: Optional[RunTimeInfo] = None,
        tags: Optional[List[str]] = None,
        use_case: Optional[str] = None,
        workspace_id: Optional[ID] = None,
    ) -> CreateProjectResponse:
        """CreateProject

        Creates a Project with required fields. Project is an organizational entity under a Workspace that contains Test Runs, Continuous Tests, and Stress Tests, along with their configurations.

        :param description: (required)
        :type description: str
        :param name: (required)
        :type name: str
        :param ethical_consideration:
        :type ethical_consideration: str
        :param is_published: Published projects are shown on the Workspace overview page.
        :type is_published: bool
        :param model_task:
        :type model_task: ModelTask
        :param profiling_config:
        :type profiling_config: ProfilingConfig
        :param run_time_info:
        :type run_time_info: RunTimeInfo
        :param tags: List of tags associated with the Project to help organizing Projects.
        :type tags: List[str]
        :param use_case:
        :type use_case: str
        :param workspace_id:
        :type workspace_id: ID
        :return: Returns the result object.
        """ # noqa: E501

        body = CreateProjectRequest(
          description=description,
          ethical_consideration=ethical_consideration,
          is_published=is_published,
          model_task=model_task,
          name=name,
          profiling_config=profiling_config,
          run_time_info=run_time_info,
          tags=tags,
          use_case=use_case,
          workspace_id=workspace_id,
        )

        _param = self._create_project_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateProjectResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_project_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/projects',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def deactivate_schedule_for_project(
        self,
        project_id_uuid: str,
        schedule_id_uuid: str,
        project_id: Optional[object] = None,
        schedule_id: Optional[object] = None,
    ) -> object:
        """DeactivateScheduleForProject

        Remove a Schedule from a Project.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param schedule_id_uuid: Unique object ID. (required)
        :type schedule_id_uuid: str
        :param project_id: Unique ID of an object in RIME.
        :type project_id: object
        :param schedule_id: Unique ID of an object in RIME.
        :type schedule_id: object
        :return: Returns the result object.
        """ # noqa: E501

        body = ActivateScheduleForProjectRequest(
          project_id=project_id,
          schedule_id=schedule_id,
        )

        _param = self._deactivate_schedule_for_project_serialize(
            project_id_uuid=project_id_uuid,
            schedule_id_uuid=schedule_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _deactivate_schedule_for_project_serialize(
        self,
        project_id_uuid,
        schedule_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if schedule_id_uuid is not None:
            _path_params['scheduleId.uuid'] = schedule_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1-beta/projects/{projectId.uuid}/schedule/{scheduleId.uuid}/deactivate',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_project(
        self,
        project_id_uuid: str,
    ) -> object:
        """DeleteProject

        Deletes a Project for a given Project ID.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_project_serialize(
            project_id_uuid=project_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_project_serialize(
        self,
        project_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/projects/{projectId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_project(
        self,
        project_id_uuid: str,
    ) -> GetProjectResponse:
        """GetProject

        Returns a Project for a given Project ID.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_project_serialize(
            project_id_uuid=project_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetProjectResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_project_serialize(
        self,
        project_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/projects/{projectId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_project_url(
        self,
        project_id_uuid: str,
    ) -> GetProjectURLResponse:
        """GetProjectURL

        Return the URL of a Project for a given Project ID.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_project_url_serialize(
            project_id_uuid=project_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetProjectURLResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_project_url_serialize(
        self,
        project_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/projects/{projectId.uuid}/url',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_workspace_roles_for_project(
        self,
        project_id_uuid: str,
    ) -> GetWorkspaceRolesForProjectResponse:
        """GetWorkspaceRoleForProject

        Returns the permissions of the Workspace members for a Project given Project ID.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_workspace_roles_for_project_serialize(
            project_id_uuid=project_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetWorkspaceRolesForProjectResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_workspace_roles_for_project_serialize(
        self,
        project_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/projects/{projectId.uuid}/role/workspace',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_projects(
        self,
        workspace_id_uuid: Optional[str] = None,
        first_page_query_is_published: Optional[bool] = None,
        first_page_query_creation_time_range_start_time: Optional[datetime] = None,
        first_page_query_creation_time_range_end_time: Optional[datetime] = None,
        first_page_query_last_test_run_time_range_start_time: Optional[datetime] = None,
        first_page_query_last_test_run_time_range_end_time: Optional[datetime] = None,
        first_page_query_stress_test_categories: Optional[List[str]] = None,
        first_page_query_continuous_test_categories: Optional[List[str]] = None,
        first_page_query_owner_email: Optional[str] = None,
        first_page_query_model_tasks: Optional[List[str]] = None,
        first_page_query_status: Optional[str] = None,
        first_page_query_sort_sort_order: Optional[str] = None,
        first_page_query_sort_sort_by: Optional[str] = None,
        first_page_query_search_expression: Optional[str] = None,
        first_page_query_search_search_fields: Optional[List[str]] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListProjectsResponse:
        """ListProjects

        Returns a paginated list of Projects for a given Workspace ID. Filters out Projects that the user does not have access to. The list is sorted by the last test run time field of each Project.

        :param workspace_id_uuid: Unique object ID.
        :type workspace_id_uuid: str
        :param first_page_query_is_published: Optional: If true, return published projects. If false, return unpublished projects. If not specified, return all projects.
        :type first_page_query_is_published: bool
        :param first_page_query_creation_time_range_start_time:
        :type first_page_query_creation_time_range_start_time: datetime
        :param first_page_query_creation_time_range_end_time:
        :type first_page_query_creation_time_range_end_time: datetime
        :param first_page_query_last_test_run_time_range_start_time:
        :type first_page_query_last_test_run_time_range_start_time: datetime
        :param first_page_query_last_test_run_time_range_end_time:
        :type first_page_query_last_test_run_time_range_end_time: datetime
        :param first_page_query_stress_test_categories: Optional: When specified, return all projects whose ST categories are a superset of the ST categories provided here.
        :type first_page_query_stress_test_categories: List[str]
        :param first_page_query_continuous_test_categories: Optional: When specified, return all projects whose CT categories are a superset of the CT categories provided here.
        :type first_page_query_continuous_test_categories: List[str]
        :param first_page_query_owner_email: Optional: When specified, return all projects whose owner email matches.
        :type first_page_query_owner_email: str
        :param first_page_query_model_tasks: Optional: When specified, return all projects whose model task is the provided model task.
        :type first_page_query_model_tasks: List[str]
        :param first_page_query_status: Optional: When specified, return all projects whose status is the provided status.
        :type first_page_query_status: str
        :param first_page_query_sort_sort_order:
        :type first_page_query_sort_sort_order: str
        :param first_page_query_sort_sort_by:
        :type first_page_query_sort_sort_by: str
        :param first_page_query_search_expression:
        :type first_page_query_search_expression: str
        :param first_page_query_search_search_fields:
        :type first_page_query_search_search_fields: List[str]
        :param page_token: Specifies a page of the list returned by a ListProjects query. The ListProjects query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageQuery field.
        :type page_token: str
        :param page_size: The maximum number of Project objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_projects_serialize(
            workspace_id_uuid=workspace_id_uuid,
            first_page_query_is_published=first_page_query_is_published,
            first_page_query_creation_time_range_start_time=first_page_query_creation_time_range_start_time,
            first_page_query_creation_time_range_end_time=first_page_query_creation_time_range_end_time,
            first_page_query_last_test_run_time_range_start_time=first_page_query_last_test_run_time_range_start_time,
            first_page_query_last_test_run_time_range_end_time=first_page_query_last_test_run_time_range_end_time,
            first_page_query_stress_test_categories=first_page_query_stress_test_categories,
            first_page_query_continuous_test_categories=first_page_query_continuous_test_categories,
            first_page_query_owner_email=first_page_query_owner_email,
            first_page_query_model_tasks=first_page_query_model_tasks,
            first_page_query_status=first_page_query_status,
            first_page_query_sort_sort_order=first_page_query_sort_sort_order,
            first_page_query_sort_sort_by=first_page_query_sort_sort_by,
            first_page_query_search_expression=first_page_query_search_expression,
            first_page_query_search_search_fields=first_page_query_search_search_fields,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListProjectsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_projects_serialize(
        self,
        workspace_id_uuid,
        first_page_query_is_published,
        first_page_query_creation_time_range_start_time,
        first_page_query_creation_time_range_end_time,
        first_page_query_last_test_run_time_range_start_time,
        first_page_query_last_test_run_time_range_end_time,
        first_page_query_stress_test_categories,
        first_page_query_continuous_test_categories,
        first_page_query_owner_email,
        first_page_query_model_tasks,
        first_page_query_status,
        first_page_query_sort_sort_order,
        first_page_query_sort_sort_by,
        first_page_query_search_expression,
        first_page_query_search_search_fields,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'firstPageQuery.stressTestCategories': 'multi',
            'firstPageQuery.continuousTestCategories': 'multi',
            'firstPageQuery.modelTasks': 'multi',
            'firstPageQuery.search.searchFields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if workspace_id_uuid is not None:
            
            _query_params.append(('workspaceId.uuid', workspace_id_uuid))
            
        if first_page_query_is_published is not None:
            
            _query_params.append(('firstPageQuery.isPublished', first_page_query_is_published))
            
        if first_page_query_creation_time_range_start_time is not None:
            if isinstance(first_page_query_creation_time_range_start_time, datetime):
                _query_params.append(
                    (
                        'firstPageQuery.creationTimeRange.startTime',
                        first_page_query_creation_time_range_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('firstPageQuery.creationTimeRange.startTime', first_page_query_creation_time_range_start_time))
            
        if first_page_query_creation_time_range_end_time is not None:
            if isinstance(first_page_query_creation_time_range_end_time, datetime):
                _query_params.append(
                    (
                        'firstPageQuery.creationTimeRange.endTime',
                        first_page_query_creation_time_range_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('firstPageQuery.creationTimeRange.endTime', first_page_query_creation_time_range_end_time))
            
        if first_page_query_last_test_run_time_range_start_time is not None:
            if isinstance(first_page_query_last_test_run_time_range_start_time, datetime):
                _query_params.append(
                    (
                        'firstPageQuery.lastTestRunTimeRange.startTime',
                        first_page_query_last_test_run_time_range_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('firstPageQuery.lastTestRunTimeRange.startTime', first_page_query_last_test_run_time_range_start_time))
            
        if first_page_query_last_test_run_time_range_end_time is not None:
            if isinstance(first_page_query_last_test_run_time_range_end_time, datetime):
                _query_params.append(
                    (
                        'firstPageQuery.lastTestRunTimeRange.endTime',
                        first_page_query_last_test_run_time_range_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('firstPageQuery.lastTestRunTimeRange.endTime', first_page_query_last_test_run_time_range_end_time))
            
        if first_page_query_stress_test_categories is not None:
            
            _query_params.append(('firstPageQuery.stressTestCategories', first_page_query_stress_test_categories))
            
        if first_page_query_continuous_test_categories is not None:
            
            _query_params.append(('firstPageQuery.continuousTestCategories', first_page_query_continuous_test_categories))
            
        if first_page_query_owner_email is not None:
            
            _query_params.append(('firstPageQuery.ownerEmail', first_page_query_owner_email))
            
        if first_page_query_model_tasks is not None:
            
            _query_params.append(('firstPageQuery.modelTasks', first_page_query_model_tasks))
            
        if first_page_query_status is not None:
            
            _query_params.append(('firstPageQuery.status', first_page_query_status))
            
        if first_page_query_sort_sort_order is not None:
            
            _query_params.append(('firstPageQuery.sort.sortOrder', first_page_query_sort_sort_order))
            
        if first_page_query_sort_sort_by is not None:
            
            _query_params.append(('firstPageQuery.sort.sortBy', first_page_query_sort_sort_by))
            
        if first_page_query_search_expression is not None:
            
            _query_params.append(('firstPageQuery.search.expression', first_page_query_search_expression))
            
        if first_page_query_search_search_fields is not None:
            
            _query_params.append(('firstPageQuery.search.searchFields', first_page_query_search_search_fields))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/projects',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_users_of_project(
        self,
        project_id_uuid: str,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListUsersOfProjectResponse:
        """ListUsersOfProject

        Lists the users and their roles of a Project for a given Project ID.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param page_token: Specifies a page of the list returned by a ListUsersOfProject query. The ListUsersOfProject query returns a pageToken when there is more than one page of results.
        :type page_token: str
        :param page_size: The maximum number of User objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_users_of_project_serialize(
            project_id_uuid=project_id_uuid,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListUsersOfProjectResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_users_of_project_serialize(
        self,
        project_id_uuid,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/projects/{projectId.uuid}/role/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def remove_user_from_project(
        self,
        project_id_uuid: str,
        user_id_uuid: str,
    ) -> object:
        """RemoveUserFromProject

        Removes all existing permissions of a user from a Project given Project ID and User ID.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param user_id_uuid: Unique object ID. (required)
        :type user_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._remove_user_from_project_serialize(
            project_id_uuid=project_id_uuid,
            user_id_uuid=user_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _remove_user_from_project_serialize(
        self,
        project_id_uuid,
        user_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if user_id_uuid is not None:
            _path_params['userId.uuid'] = user_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/projects/{projectId.uuid}/role/users/{userId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_project(
        self,
        project_id_uuid: str,
        mask: Optional[str] = None,
        project: Optional[Project] = None,
        project_id: Optional[object] = None,
    ) -> UpdateProjectResponse:
        """UpdateProject

        Updates a Project for a given Project ID. Only updates the fields specified in the FieldMask.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param mask:
        :type mask: str
        :param project:
        :type project: Project
        :param project_id: Uniquely specifies a Project to update.
        :type project_id: object
        :return: Returns the result object.
        """ # noqa: E501

        body = UpdateProjectRequest(
          mask=mask,
          project=project,
          project_id=project_id,
        )

        _param = self._update_project_serialize(
            project_id_uuid=project_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateProjectResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_project_serialize(
        self,
        project_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/projects/{projectId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_user_of_project(
        self,
        project_id_uuid: str,
        user_user_id_uuid: str,
        project_id: Optional[object] = None,
        user: Optional[UpdateUserOfProjectRequestUser] = None,
    ) -> object:
        """UpdateUserOfProject

        Updates the existing permission of a user of a Project given Project ID and User ID.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param user_user_id_uuid: Unique object ID. (required)
        :type user_user_id_uuid: str
        :param project_id: Uniquely specifies a Project.
        :type project_id: object
        :param user:
        :type user: UpdateUserOfProjectRequestUser
        :return: Returns the result object.
        """ # noqa: E501

        body = UpdateUserOfProjectRequest(
          project_id=project_id,
          user=user,
        )

        _param = self._update_user_of_project_serialize(
            project_id_uuid=project_id_uuid,
            user_user_id_uuid=user_user_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_user_of_project_serialize(
        self,
        project_id_uuid,
        user_user_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if user_user_id_uuid is not None:
            _path_params['user.userId.uuid'] = user_user_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/projects/{projectId.uuid}/role/users/{user.userId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_workspace_roles_for_project(
        self,
        project_id_uuid: str,
        role_pairs: List[ParentRoleSubjectRolePair],
        project_id: Optional[object] = None,
    ) -> UpdateWorkspaceRolesForProjectResponse:
        """UpdateWorkspaceRoleForProject

        Assigns users roles(permissions) on a Project based on their roles in the Workspace that contains the Project.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param role_pairs: The elements of role_pairs maps each Workspace role to a Project role. For example, you can specify that a user with admin rights on a Workspace will get viewer rights on Projects in that Workspace. (required)
        :type role_pairs: List[ParentRoleSubjectRolePair]
        :param project_id: Uniquely specifies a Project.
        :type project_id: object
        :return: Returns the result object.
        """ # noqa: E501

        body = UpdateWorkspaceRolesForProjectRequest(
          project_id=project_id,
          role_pairs=role_pairs,
        )

        _param = self._update_workspace_roles_for_project_serialize(
            project_id_uuid=project_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateWorkspaceRolesForProjectResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_workspace_roles_for_project_serialize(
        self,
        project_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/projects/{projectId.uuid}/role/workspace',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
