# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr
from typing import Any, Dict, Optional
from typing_extensions import Annotated
from ri.apiclient.models.get_dataset_response import GetDatasetResponse
from ri.apiclient.models.get_model_response import GetModelResponse
from ri.apiclient.models.get_prediction_set_response import GetPredictionSetResponse
from ri.apiclient.models.list_datasets_response import ListDatasetsResponse
from ri.apiclient.models.list_models_response import ListModelsResponse
from ri.apiclient.models.list_prediction_sets_response import ListPredictionSetsResponse
from ri.apiclient.models.register_dataset_request import RegisterDatasetRequest
from ri.apiclient.models.register_dataset_response import RegisterDatasetResponse
from ri.apiclient.models.register_model_request import RegisterModelRequest
from ri.apiclient.models.register_model_response import RegisterModelResponse
from ri.apiclient.models.register_prediction_set_request import RegisterPredictionSetRequest
from ri.apiclient.models.register_prediction_set_response import RegisterPredictionSetResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class RegistryServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def delete_dataset(
        self,
        dataset_id: str,
    ) -> object:
        """DeleteDataset

        Delete a Dataset from the Registry.

        :param dataset_id: Uniquely specifies a Dataset. (required)
        :type dataset_id: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_dataset_serialize(
            dataset_id=dataset_id,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_dataset_serialize(
        self,
        dataset_id,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if dataset_id is not None:
            _path_params['datasetId'] = dataset_id
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/registry/dataset/{datasetId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_model(
        self,
        model_id_uuid: str,
    ) -> object:
        """DeleteModel

        Delete a Model from the Registry.

        :param model_id_uuid: Unique object ID. (required)
        :type model_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_model_serialize(
            model_id_uuid=model_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_model_serialize(
        self,
        model_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if model_id_uuid is not None:
            _path_params['modelId.uuid'] = model_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/registry/model/{modelId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_prediction_set(
        self,
        model_id_uuid: str,
        dataset_id: str,
    ) -> object:
        """DeletePredictionSet

        Delete the Prediction set corresponding to a specified Model and Dataset.

        :param model_id_uuid: Unique object ID. (required)
        :type model_id_uuid: str
        :param dataset_id: Uniquely specifies a Dataset. (required)
        :type dataset_id: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_prediction_set_serialize(
            model_id_uuid=model_id_uuid,
            dataset_id=dataset_id,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_prediction_set_serialize(
        self,
        model_id_uuid,
        dataset_id,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if model_id_uuid is not None:
            _path_params['modelId.uuid'] = model_id_uuid
        if dataset_id is not None:
            _path_params['datasetId'] = dataset_id
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/registry/prediction/{modelId.uuid}/{datasetId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_dataset(
        self,
        dataset_id: Optional[str] = None,
        dataset_name: Optional[str] = None,
    ) -> GetDatasetResponse:
        """GetDataset

        Returns information about a registered Dataset. Allows for searching by ID or name.

        :param dataset_id: Uniquely specifies a Dataset.
        :type dataset_id: str
        :param dataset_name: Unique name of a Dataset.
        :type dataset_name: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_dataset_serialize(
            dataset_id=dataset_id,
            dataset_name=dataset_name,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetDatasetResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_dataset_serialize(
        self,
        dataset_id,
        dataset_name,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if dataset_id is not None:
            
            _query_params.append(('datasetId', dataset_id))
            
        if dataset_name is not None:
            
            _query_params.append(('datasetName', dataset_name))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/registry/dataset',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_model(
        self,
        model_id_uuid: Optional[str] = None,
        model_name: Optional[str] = None,
    ) -> GetModelResponse:
        """GetModel

        Returns information about a registered Model. Allows for searching by ID or name.

        :param model_id_uuid: Unique object ID.
        :type model_id_uuid: str
        :param model_name: Unique name of a Model.
        :type model_name: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_model_serialize(
            model_id_uuid=model_id_uuid,
            model_name=model_name,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetModelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_model_serialize(
        self,
        model_id_uuid,
        model_name,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if model_id_uuid is not None:
            
            _query_params.append(('modelId.uuid', model_id_uuid))
            
        if model_name is not None:
            
            _query_params.append(('modelName', model_name))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/registry/model',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_prediction_set(
        self,
        model_id_uuid: str,
        dataset_id: str,
    ) -> GetPredictionSetResponse:
        """GetPredictionSet

        Returns information about a registered Prediction set.

        :param model_id_uuid: Unique object ID. (required)
        :type model_id_uuid: str
        :param dataset_id: Uniquely specifies a Dataset. (required)
        :type dataset_id: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_prediction_set_serialize(
            model_id_uuid=model_id_uuid,
            dataset_id=dataset_id,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPredictionSetResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_prediction_set_serialize(
        self,
        model_id_uuid,
        dataset_id,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if model_id_uuid is not None:
            _path_params['modelId.uuid'] = model_id_uuid
        if dataset_id is not None:
            _path_params['datasetId'] = dataset_id
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/registry/prediction/{modelId.uuid}/{datasetId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_datasets(
        self,
        project_id_uuid: str,
        first_page_req_scheduled_ct_intervals_start_time: Optional[datetime] = None,
        first_page_req_scheduled_ct_intervals_end_time: Optional[datetime] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListDatasetsResponse:
        """ListDatasets

        List all Datasets in the Registry with optional filters.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param first_page_req_scheduled_ct_intervals_start_time:
        :type first_page_req_scheduled_ct_intervals_start_time: datetime
        :param first_page_req_scheduled_ct_intervals_end_time:
        :type first_page_req_scheduled_ct_intervals_end_time: datetime
        :param page_token: Specifies a page of the list returned by a ListDatasets query. The ListDatasets query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :type page_token: str
        :param page_size: The maximum number of Dataset objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_datasets_serialize(
            project_id_uuid=project_id_uuid,
            first_page_req_scheduled_ct_intervals_start_time=first_page_req_scheduled_ct_intervals_start_time,
            first_page_req_scheduled_ct_intervals_end_time=first_page_req_scheduled_ct_intervals_end_time,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListDatasetsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_datasets_serialize(
        self,
        project_id_uuid,
        first_page_req_scheduled_ct_intervals_start_time,
        first_page_req_scheduled_ct_intervals_end_time,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if first_page_req_scheduled_ct_intervals_start_time is not None:
            if isinstance(first_page_req_scheduled_ct_intervals_start_time, datetime):
                _query_params.append(
                    (
                        'firstPageReq.scheduledCtIntervals.startTime',
                        first_page_req_scheduled_ct_intervals_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('firstPageReq.scheduledCtIntervals.startTime', first_page_req_scheduled_ct_intervals_start_time))
            
        if first_page_req_scheduled_ct_intervals_end_time is not None:
            if isinstance(first_page_req_scheduled_ct_intervals_end_time, datetime):
                _query_params.append(
                    (
                        'firstPageReq.scheduledCtIntervals.endTime',
                        first_page_req_scheduled_ct_intervals_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('firstPageReq.scheduledCtIntervals.endTime', first_page_req_scheduled_ct_intervals_end_time))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/registry/{projectId.uuid}/dataset',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_models(
        self,
        project_id_uuid: str,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListModelsResponse:
        """ListModels

        List all Models in the Registry of the specified Project.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param page_token: Specifies a page of the list returned by a ListModels query. The ListModels query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :type page_token: str
        :param page_size: The maximum number of Model objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_models_serialize(
            project_id_uuid=project_id_uuid,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListModelsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_models_serialize(
        self,
        project_id_uuid,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/registry/{projectId.uuid}/model',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_prediction_sets(
        self,
        project_id_uuid: str,
        first_page_req_model_id: Optional[str] = None,
        first_page_req_dataset_id: Optional[str] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListPredictionSetsResponse:
        """ListPredictionSets

        List all Prediction sets in the Registry with optional filters.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param first_page_req_model_id: Uniquely specifies a Model.
        :type first_page_req_model_id: str
        :param first_page_req_dataset_id: Uniquely specifies a Dataset.
        :type first_page_req_dataset_id: str
        :param page_token: Specifies a page of the list returned by a ListPredictions query. The ListPredictions query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :type page_token: str
        :param page_size: The maximum number of Prediction objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_prediction_sets_serialize(
            project_id_uuid=project_id_uuid,
            first_page_req_model_id=first_page_req_model_id,
            first_page_req_dataset_id=first_page_req_dataset_id,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListPredictionSetsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_prediction_sets_serialize(
        self,
        project_id_uuid,
        first_page_req_model_id,
        first_page_req_dataset_id,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if first_page_req_model_id is not None:
            
            _query_params.append(('firstPageReq.modelId', first_page_req_model_id))
            
        if first_page_req_dataset_id is not None:
            
            _query_params.append(('firstPageReq.datasetId', first_page_req_dataset_id))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/registry/{projectId.uuid}/prediction',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def register_dataset(
        self,
        project_id_uuid: str,
        name: str,
        agent_id: Optional[ID] = None,
        ct_info: Optional[CTInfo] = None,
        data_info: Optional[DataInfo] = None,
        integration_id: Optional[ID] = None,
        metadata: Optional[Metadata] = None,
        project_id: Optional[object] = None,
        skip_validation: Optional[bool] = None,
    ) -> RegisterDatasetResponse:
        """RegisterDataset

        Register a new Dataset for the specified Project.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param name: Unique name of the Dataset. (required)
        :type name: str
        :param agent_id:
        :type agent_id: ID
        :param ct_info:
        :type ct_info: CTInfo
        :param data_info:
        :type data_info: DataInfo
        :param integration_id:
        :type integration_id: ID
        :param metadata:
        :type metadata: Metadata
        :param project_id: Uniquely specifies a Project.
        :type project_id: object
        :param skip_validation: The parameter is deprecated since 2.7, and does not have any effect. Will always validate the dataset you are registering. Validation ensures that the dataset is valid for Robust Intelligence's systems.
        :type skip_validation: bool
        :return: Returns the result object.
        """ # noqa: E501

        body = RegisterDatasetRequest(
          agent_id=agent_id,
          ct_info=ct_info,
          data_info=data_info,
          integration_id=integration_id,
          metadata=metadata,
          name=name,
          project_id=project_id,
          skip_validation=skip_validation,
        )

        _param = self._register_dataset_serialize(
            project_id_uuid=project_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RegisterDatasetResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _register_dataset_serialize(
        self,
        project_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/registry/{projectId.uuid}/dataset',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def register_model(
        self,
        project_id_uuid: str,
        name: str,
        agent_id: Optional[ID] = None,
        external_id: Optional[str] = None,
        integration_id: Optional[ID] = None,
        metadata: Optional[Metadata] = None,
        model_endpoint_integration_id: Optional[ID] = None,
        model_info: Optional[ModelInfo] = None,
        project_id: Optional[object] = None,
        skip_validation: Optional[bool] = None,
    ) -> RegisterModelResponse:
        """RegisterModel

        Register a new Model for the specified Project.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param name: Unique name of the Model. (required)
        :type name: str
        :param agent_id:
        :type agent_id: ID
        :param external_id: External ID that can be used to identify the model.
        :type external_id: str
        :param integration_id:
        :type integration_id: ID
        :param metadata:
        :type metadata: Metadata
        :param model_endpoint_integration_id:
        :type model_endpoint_integration_id: ID
        :param model_info:
        :type model_info: ModelInfo
        :param project_id: Uniquely specifies a Project.
        :type project_id: object
        :param skip_validation: The parameter is deprecated since 2.7, and does not have any effect. Will always validate the model you are registering. Validation ensures that the model is valid for Robust Intelligence's systems.
        :type skip_validation: bool
        :return: Returns the result object.
        """ # noqa: E501

        body = RegisterModelRequest(
          agent_id=agent_id,
          external_id=external_id,
          integration_id=integration_id,
          metadata=metadata,
          model_endpoint_integration_id=model_endpoint_integration_id,
          model_info=model_info,
          name=name,
          project_id=project_id,
          skip_validation=skip_validation,
        )

        _param = self._register_model_serialize(
            project_id_uuid=project_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RegisterModelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _register_model_serialize(
        self,
        project_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/registry/{projectId.uuid}/model',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def register_prediction_set(
        self,
        project_id_uuid: str,
        model_id_uuid: str,
        dataset_id: str,
        agent_id: Optional[ID] = None,
        integration_id: Optional[ID] = None,
        metadata: Optional[Metadata] = None,
        model_id: Optional[object] = None,
        pred_info: Optional[PredInfo] = None,
        project_id: Optional[object] = None,
        skip_validation: Optional[bool] = None,
    ) -> RegisterPredictionSetResponse:
        """RegisterPredictionSet

        Register a Prediction set corresponding to a specified Model and Dataset.

        :param project_id_uuid: Unique object ID. (required)
        :type project_id_uuid: str
        :param model_id_uuid: Unique object ID. (required)
        :type model_id_uuid: str
        :param dataset_id: Uniquely specifies a Dataset. (required)
        :type dataset_id: str
        :param agent_id:
        :type agent_id: ID
        :param integration_id:
        :type integration_id: ID
        :param metadata:
        :type metadata: Metadata
        :param model_id: Uniquely specifies a Model.
        :type model_id: object
        :param pred_info:
        :type pred_info: PredInfo
        :param project_id: Uniquely specifies a Project.
        :type project_id: object
        :param skip_validation: The parameter is deprecated since 2.7, and does not have any effect. Will always validate the predictions you are registering. Validation ensures that the predictions is valid for Robust Intelligence's systems.
        :type skip_validation: bool
        :return: Returns the result object.
        """ # noqa: E501

        body = RegisterPredictionSetRequest(
          agent_id=agent_id,
          integration_id=integration_id,
          metadata=metadata,
          model_id=model_id,
          pred_info=pred_info,
          project_id=project_id,
          skip_validation=skip_validation,
        )

        _param = self._register_prediction_set_serialize(
            project_id_uuid=project_id_uuid,
            model_id_uuid=model_id_uuid,
            dataset_id=dataset_id,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RegisterPredictionSetResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _register_prediction_set_serialize(
        self,
        project_id_uuid,
        model_id_uuid,
        dataset_id,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id_uuid is not None:
            _path_params['projectId.uuid'] = project_id_uuid
        if model_id_uuid is not None:
            _path_params['modelId.uuid'] = model_id_uuid
        if dataset_id is not None:
            _path_params['datasetId'] = dataset_id
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/registry/{projectId.uuid}/model/{modelId.uuid}/dataset/{datasetId}/prediction',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
