# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr, field_validator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from ri.apiclient.models.get_batch_result_response import GetBatchResultResponse
from ri.apiclient.models.get_category_results_response import GetCategoryResultsResponse
from ri.apiclient.models.get_feature_result_response import GetFeatureResultResponse
from ri.apiclient.models.get_test_config_response import GetTestConfigResponse
from ri.apiclient.models.list_batch_results_response import ListBatchResultsResponse
from ri.apiclient.models.list_feature_results_response import ListFeatureResultsResponse
from ri.apiclient.models.list_monitor_categories_response import ListMonitorCategoriesResponse
from ri.apiclient.models.list_summary_tests_response import ListSummaryTestsResponse
from ri.apiclient.models.list_test_cases_response import ListTestCasesResponse
from ri.apiclient.models.list_validation_categories_response import ListValidationCategoriesResponse
from ri.apiclient.models.rename_test_run_request import RenameTestRunRequest
from ri.apiclient.models.rename_test_run_response import RenameTestRunResponse
from ri.apiclient.models.testrunresult_get_test_run_response import TestrunresultGetTestRunResponse
from ri.apiclient.models.testrunresult_list_test_runs_response import TestrunresultListTestRunsResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class ResultsReaderApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def delete_test_run(
        self,
        test_run_id: str,
    ) -> object:
        """DeleteTestRun

        Deletes a specified test run.

        :param test_run_id: Uniquely specifies a Test Run to delete. (required)
        :type test_run_id: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_test_run_serialize(
            test_run_id=test_run_id,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_test_run_serialize(
        self,
        test_run_id,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if test_run_id is not None:
            _path_params['testRunId'] = test_run_id
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/test-runs/{testRunId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_batch_result(
        self,
        test_run_id: str,
        test_type: str,
        show_display: Optional[bool] = None,
    ) -> GetBatchResultResponse:
        """GetBatchResult

        Gets the batch result for a given Test Run ID and a test type.

        :param test_run_id: Uniquely specifies a Test Run. (required)
        :type test_run_id: str
        :param test_type: The type of test, such as \"Subset Accuracy\" or \"Overall Metrics\". (required)
        :type test_type: str
        :param show_display: A Boolean flag that toggles whether to return display HTML. info with message.
        :type show_display: bool
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_batch_result_serialize(
            test_run_id=test_run_id,
            test_type=test_type,
            show_display=show_display,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBatchResultResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_batch_result_serialize(
        self,
        test_run_id,
        test_type,
        show_display,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if test_run_id is not None:
            _path_params['testRunId'] = test_run_id
        if test_type is not None:
            _path_params['testType'] = test_type
        if show_display is not None:
            
            _query_params.append(('showDisplay', show_display))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/test-runs/{testRunId}/batch-result/{testType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_category_results(
        self,
        test_run_id: str,
    ) -> GetCategoryResultsResponse:
        """GetCategoryResults

        Returns all category results of a test run.

        :param test_run_id: The ID of the test run associated with summary tests. Specify exactly one of the page_token field or this field. (required)
        :type test_run_id: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_category_results_serialize(
            test_run_id=test_run_id,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCategoryResultsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_category_results_serialize(
        self,
        test_run_id,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if test_run_id is not None:
            _path_params['testRunId'] = test_run_id
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/category-results/{testRunId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_feature_result(
        self,
        test_run_id: str,
        url_safe_feature_id: str,
        show_display: Optional[bool] = None,
    ) -> GetFeatureResultResponse:
        """GetFeatureResult

        Returns the feature result that matches the specified test run ID and feature ID.

        :param test_run_id: Uniquely specifies a Test Run. (required)
        :type test_run_id: str
        :param url_safe_feature_id: Uniquely specifies a Feature. (required)
        :type url_safe_feature_id: str
        :param show_display: A Boolean flag that specifies whether to return display HTML information.
        :type show_display: bool
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_feature_result_serialize(
            test_run_id=test_run_id,
            url_safe_feature_id=url_safe_feature_id,
            show_display=show_display,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFeatureResultResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_feature_result_serialize(
        self,
        test_run_id,
        url_safe_feature_id,
        show_display,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if test_run_id is not None:
            _path_params['testRunId'] = test_run_id
        if url_safe_feature_id is not None:
            _path_params['urlSafeFeatureId'] = url_safe_feature_id
        if show_display is not None:
            
            _query_params.append(('showDisplay', show_display))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/test-runs/{testRunId}/feature-result/{urlSafeFeatureId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_test_config(
        self,
        test_run_id: str,
        config_name: str,
    ) -> GetTestConfigResponse:
        """GetTestConfig

        Returns the test configuration of the specified test run as bytes.

        :param test_run_id: Uniquely specifies a Test Run. (required)
        :type test_run_id: str
        :param config_name: The name of the test config requested. (required)
        :type config_name: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_test_config_serialize(
            test_run_id=test_run_id,
            config_name=config_name,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTestConfigResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_test_config_serialize(
        self,
        test_run_id,
        config_name,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if test_run_id is not None:
            _path_params['testRunId'] = test_run_id
        if config_name is not None:
            _path_params['configName'] = config_name
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/test-runs/{testRunId}/test-config/{configName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_test_run(
        self,
        test_run_id: str,
    ) -> TestrunresultGetTestRunResponse:
        """GetTestRun

        Returns the test run result detail for a given Test Run ID.

        :param test_run_id: Uniquely specifies a test run. (required)
        :type test_run_id: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_test_run_serialize(
            test_run_id=test_run_id,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TestrunresultGetTestRunResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_test_run_serialize(
        self,
        test_run_id,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if test_run_id is not None:
            _path_params['testRunId'] = test_run_id
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/test-runs/{testRunId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_batch_results(
        self,
        test_run_id: Optional[str] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
        show_display: Optional[bool] = None,
    ) -> ListBatchResultsResponse:
        """ListBatchResults

        Returns a paginated list of batch results from a test run.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```

        :param test_run_id: The ID of the Test Run associated with batch results. Specify exactly one of the pageToken field or this field.
        :type test_run_id: str
        :param page_token: A token representing one page from the list returned by a ListBatchResults query. The ListBatchResults query returns a page_token when there is more than one page of results. Specify exactly one of the testRunId field or this field.
        :type page_token: str
        :param page_size: The maximum number of Batch Result objects to return in a single page.
        :type page_size: str
        :param show_display: A Boolean that toggles whether to return display html info.
        :type show_display: bool
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_batch_results_serialize(
            test_run_id=test_run_id,
            page_token=page_token,
            page_size=page_size,
            show_display=show_display,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBatchResultsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_batch_results_serialize(
        self,
        test_run_id,
        page_token,
        page_size,
        show_display,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if test_run_id is not None:
            
            _query_params.append(('testRunId', test_run_id))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if show_display is not None:
            
            _query_params.append(('showDisplay', show_display))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/batch-results',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_feature_results(
        self,
        test_run_id: Optional[str] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
        show_display: Optional[bool] = None,
    ) -> ListFeatureResultsResponse:
        """ListFeatureResults

        List all feature results from a test run.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```

        :param test_run_id: The ID of the Test Run associated with feature results. Specify exactly one of the page_token field or this field.
        :type test_run_id: str
        :param page_token: A token representing one page from the list returned by a ListFeatureResults query. The ListFeatureResults query returns a page_token when there is more than one page of results. Specify exactly one of the testRunId field or this field.
        :type page_token: str
        :param page_size: The maximum number of Feature Result objects to return in a single page.
        :type page_size: str
        :param show_display: A Boolean that specifies whether to return display HTML information.
        :type show_display: bool
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_feature_results_serialize(
            test_run_id=test_run_id,
            page_token=page_token,
            page_size=page_size,
            show_display=show_display,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFeatureResultsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_feature_results_serialize(
        self,
        test_run_id,
        page_token,
        page_size,
        show_display,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if test_run_id is not None:
            
            _query_params.append(('testRunId', test_run_id))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if show_display is not None:
            
            _query_params.append(('showDisplay', show_display))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/feature-results',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_monitor_categories(
        self,
    ) -> ListMonitorCategoriesResponse:
        """ListMonitorCategories

        Returns test categories belongs to monitor.

        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_monitor_categories_serialize(
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListMonitorCategoriesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_monitor_categories_serialize(
        self,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/test-runs/test-category/monitor',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_summary_tests(
        self,
        query_test_run_id: Optional[str] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListSummaryTestsResponse:
        """ListSummaryTests

        Returns a paginated list of the summary tests of a test run. DEPRECATED: Use GetCategoryResults instead, the API request and response are the same. This method will be removed in the future.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```

        :param query_test_run_id: The ID of the test run associated with summary tests. Specify exactly one of the page_token field or this field.
        :type query_test_run_id: str
        :param page_token: A token representing one page from the list returned by a ListSummaryTests query. The ListSummaryTests query returns a page_token when there is more than one page of results. Specify exactly one of the query.testRunId field or this field.
        :type page_token: str
        :param page_size: The maximum number of Summary Test objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_summary_tests_serialize(
            query_test_run_id=query_test_run_id,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListSummaryTestsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_summary_tests_serialize(
        self,
        query_test_run_id,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if query_test_run_id is not None:
            
            _query_params.append(('query.testRunId', query_test_run_id))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/summary-tests',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_test_cases(
        self,
        list_test_cases_query_test_run_id: Optional[str] = None,
        list_test_cases_query_test_types: Optional[List[str]] = None,
        list_test_cases_query_url_safe_feature_ids: Optional[List[str]] = None,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
        show_display: Optional[bool] = None,
    ) -> ListTestCasesResponse:
        """ListTestCases

        Returns a paginated list of the test cases in a test run. Specify a set of test types to filter the list by test types.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```

        :param list_test_cases_query_test_run_id: Uniquely specifies a Test Run associated with test cases. Specify exactly one of the page_token field or this field.
        :type list_test_cases_query_test_run_id: str
        :param list_test_cases_query_test_types: Optional filter for test types.
        :type list_test_cases_query_test_types: List[str]
        :param list_test_cases_query_url_safe_feature_ids: Optional filter for features.
        :type list_test_cases_query_url_safe_feature_ids: List[str]
        :param page_token: A token representing one page from the list returned by a ListTestCases query. The ListTestCases query returns a page_token when there is more than one page of results. Specify exactly one of the ListTestCasesQuery.testRunId field or this field.
        :type page_token: str
        :param page_size: The maximum number of Test Case objects to return in a single page.
        :type page_size: str
        :param show_display: A Boolean flag that specifies whether to return display HTML information with the message.
        :type show_display: bool
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_test_cases_serialize(
            list_test_cases_query_test_run_id=list_test_cases_query_test_run_id,
            list_test_cases_query_test_types=list_test_cases_query_test_types,
            list_test_cases_query_url_safe_feature_ids=list_test_cases_query_url_safe_feature_ids,
            page_token=page_token,
            page_size=page_size,
            show_display=show_display,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTestCasesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_test_cases_serialize(
        self,
        list_test_cases_query_test_run_id,
        list_test_cases_query_test_types,
        list_test_cases_query_url_safe_feature_ids,
        page_token,
        page_size,
        show_display,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'listTestCasesQuery.testTypes': 'multi',
            'listTestCasesQuery.urlSafeFeatureIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if list_test_cases_query_test_run_id is not None:
            
            _query_params.append(('listTestCasesQuery.testRunId', list_test_cases_query_test_run_id))
            
        if list_test_cases_query_test_types is not None:
            
            _query_params.append(('listTestCasesQuery.testTypes', list_test_cases_query_test_types))
            
        if list_test_cases_query_url_safe_feature_ids is not None:
            
            _query_params.append(('listTestCasesQuery.urlSafeFeatureIds', list_test_cases_query_url_safe_feature_ids))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if show_display is not None:
            
            _query_params.append(('showDisplay', show_display))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/test-cases',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_test_runs(
        self,
        project_id: Optional[str] = None,
        page_token: Optional[str] = None,
        first_page_query_project_id_uuid: Optional[str] = None,
        first_page_query_testing_type: Optional[str] = None,
        first_page_query_schedule_id_uuid: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> TestrunresultListTestRunsResponse:
        """ListTestRuns

        Lists all test runs belonging to a project.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```

        :param project_id: The field is deprecated in v2.2. Use first_page_query.project_id instead. The field will be removed after v2.3. The ID of the project containing the requested test runs. Specify exactly one of the page_token field or this field.
        :type project_id: str
        :param page_token: A token representing one page from the list returned by a ListTestRuns query. The ListTestRuns query returns a page_token when there is more than one page of results. Specify exactly one of the projectId field or this field.
        :type page_token: str
        :param first_page_query_project_id_uuid: Unique object ID.
        :type first_page_query_project_id_uuid: str
        :param first_page_query_testing_type: The test type of Test Runs to request. Defaults to Stress Testing.   - TEST_TYPE_STRESS_TESTING_UNSPECIFIED: Default type as stress testing
        :type first_page_query_testing_type: str
        :param first_page_query_schedule_id_uuid: Unique object ID.
        :type first_page_query_schedule_id_uuid: str
        :param page_size: The maximum number of Test Run objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_test_runs_serialize(
            project_id=project_id,
            page_token=page_token,
            first_page_query_project_id_uuid=first_page_query_project_id_uuid,
            first_page_query_testing_type=first_page_query_testing_type,
            first_page_query_schedule_id_uuid=first_page_query_schedule_id_uuid,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TestrunresultListTestRunsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_test_runs_serialize(
        self,
        project_id,
        page_token,
        first_page_query_project_id_uuid,
        first_page_query_testing_type,
        first_page_query_schedule_id_uuid,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if project_id is not None:
            
            _query_params.append(('projectId', project_id))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if first_page_query_project_id_uuid is not None:
            
            _query_params.append(('firstPageQuery.projectId.uuid', first_page_query_project_id_uuid))
            
        if first_page_query_testing_type is not None:
            
            _query_params.append(('firstPageQuery.testingType', first_page_query_testing_type))
            
        if first_page_query_schedule_id_uuid is not None:
            
            _query_params.append(('firstPageQuery.scheduleId.uuid', first_page_query_schedule_id_uuid))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/test-runs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_validation_categories(
        self,
    ) -> ListValidationCategoriesResponse:
        """ListValidationCategories

        Returns test categories belongs to validation.

        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_validation_categories_serialize(
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListValidationCategoriesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_validation_categories_serialize(
        self,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/test-runs/test-category/validation',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def rename_test_run(
        self,
        test_run_id: str,
        name: Optional[str] = None,
    ) -> RenameTestRunResponse:
        """RenameTestRun

        Updates the name of a test run.

        :param test_run_id: Uniquely specifies a Test Run to rename. (required)
        :type test_run_id: str
        :param name: The new name of the Test Run.
        :type name: str
        :return: Returns the result object.
        """ # noqa: E501

        body = RenameTestRunRequest(
          name=name,
        )

        _param = self._rename_test_run_serialize(
            test_run_id=test_run_id,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RenameTestRunResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _rename_test_run_serialize(
        self,
        test_run_id,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if test_run_id is not None:
            _path_params['testRunId'] = test_run_id
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/test-runs/rename/{testRunId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
