# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Any, Dict
from typing_extensions import Annotated
from ri.apiclient.models.create_schedule_request import CreateScheduleRequest
from ri.apiclient.models.create_schedule_response import CreateScheduleResponse
from ri.apiclient.models.get_schedule_response import GetScheduleResponse
from ri.apiclient.models.update_schedule_request import UpdateScheduleRequest
from ri.apiclient.models.update_schedule_response import UpdateScheduleResponse

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class ScheduleServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_schedule(
        self,
        frequency_cron_expr: str,
        project_id: Optional[ID] = None,
        test_run_config: Optional[TestRunConfig] = None,
    ) -> CreateScheduleResponse:
        """CreateSchedule creates a schedule.


        :param frequency_cron_expr: Cron expression used to determine how often to run the schedule. (required)
        :type frequency_cron_expr: str
        :param project_id:
        :type project_id: ID
        :param test_run_config:
        :type test_run_config: TestRunConfig
        :return: Returns the result object.
        """ # noqa: E501

        body = CreateScheduleRequest(
          frequency_cron_expr=frequency_cron_expr,
          project_id=project_id,
          test_run_config=test_run_config,
        )

        _param = self._create_schedule_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateScheduleResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_schedule_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1-beta/schedules',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_schedule(
        self,
        schedule_id_uuid: str,
    ) -> object:
        """DeleteSchedule deletes a schedule.


        :param schedule_id_uuid: Unique object ID. (required)
        :type schedule_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_schedule_serialize(
            schedule_id_uuid=schedule_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_schedule_serialize(
        self,
        schedule_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if schedule_id_uuid is not None:
            _path_params['scheduleId.uuid'] = schedule_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1-beta/schedules/{scheduleId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_schedule(
        self,
        schedule_id_uuid: str,
    ) -> GetScheduleResponse:
        """GetSchedule gets a schedule.


        :param schedule_id_uuid: Unique object ID. (required)
        :type schedule_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_schedule_serialize(
            schedule_id_uuid=schedule_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetScheduleResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_schedule_serialize(
        self,
        schedule_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if schedule_id_uuid is not None:
            _path_params['scheduleId.uuid'] = schedule_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/schedules/{scheduleId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_schedule(
        self,
        schedule_schedule_id_uuid: str,
        mask: str,
        frequency_cron_expr: Optional[str] = None,
        project_id: Optional[ID] = None,
        schedule_id: Optional[object] = None,
        test_run_config: Optional[TestRunConfig] = None,
    ) -> UpdateScheduleResponse:
        """UpdateSchedule updates a schedule.


        :param schedule_schedule_id_uuid: Unique object ID. (required)
        :type schedule_schedule_id_uuid: str
        :param mask: Update mask specifies the fields in the config that will be updated. Any values not in the mask will be ignored. Currently only updated the frequency of the schedule is supported. (required)
        :type mask: str
        :param frequency_cron_expr: Cron expression used to determine how often to run the schedule. Accepts \"@hourly\", \"@daily\", \"@weekly\", and \"@monthly\".
        :type frequency_cron_expr: str
        :param project_id:
        :type project_id: ID
        :param schedule_id: Unique ID of an object in RIME.
        :type schedule_id: object
        :param test_run_config:
        :type test_run_config: TestRunConfig
        :return: Returns the result object.
        """ # noqa: E501

        schedule = UpdateScheduleRequest(
          frequency_cron_expr=frequency_cron_expr,
          project_id=project_id,
          schedule_id=schedule_id,
          test_run_config=test_run_config,
        )

        _param = self._update_schedule_serialize(
            schedule_schedule_id_uuid=schedule_schedule_id_uuid,
            mask=mask,
            schedule=schedule,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateScheduleResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_schedule_serialize(
        self,
        schedule_schedule_id_uuid,
        mask,
        schedule,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if schedule_schedule_id_uuid is not None:
            _path_params['schedule.scheduleId.uuid'] = schedule_schedule_id_uuid
        if mask is not None:
            
            _query_params.append(('mask', mask))
            
        if schedule is not None:
            _body_params = schedule
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1-beta/schedules/{schedule.scheduleId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
