# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr, field_validator
from typing import Any, Dict, Optional
from typing_extensions import Annotated
from ri.apiclient.models.create_api_token_request import CreateAPITokenRequest
from ri.apiclient.models.create_api_token_response import CreateAPITokenResponse
from ri.apiclient.models.create_user_request import CreateUserRequest
from ri.apiclient.models.create_user_response import CreateUserResponse
from ri.apiclient.models.get_user_response import GetUserResponse
from ri.apiclient.models.list_api_tokens_response import ListAPITokensResponse
from ri.apiclient.models.list_current_user_roles_response import ListCurrentUserRolesResponse
from ri.apiclient.models.list_users_response import ListUsersResponse
from ri.apiclient.models.reset_password_request import ResetPasswordRequest
from ri.apiclient.models.update_agent_api_token_request import UpdateAgentAPITokenRequest
from ri.apiclient.models.update_agent_api_token_response import UpdateAgentAPITokenResponse
from ri.apiclient.models.update_user_request import UpdateUserRequest

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class UserApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_api_token(
        self,
        name: str,
        agent_id: Optional[ID] = None,
        expiry_days: Optional[int] = None,
        token_type: Optional[TokenType] = None,
        workspace_id: Optional[ID] = None,
    ) -> CreateAPITokenResponse:
        """CreateAPIToken

        Create a new API token.

        :param name: Name of the API token. (required)
        :type name: str
        :param agent_id:
        :type agent_id: ID
        :param expiry_days:
        :type expiry_days: int
        :param token_type:
        :type token_type: TokenType
        :param workspace_id:
        :type workspace_id: ID
        :return: Returns the result object.
        """ # noqa: E501

        body = CreateAPITokenRequest(
          agent_id=agent_id,
          expiry_days=expiry_days,
          name=name,
          token_type=token_type,
          workspace_id=workspace_id,
        )

        _param = self._create_api_token_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAPITokenResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_api_token_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/users/api-tokens',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def create_user(
        self,
        email: str,
        full_name: str,
        password: str,
        org_role: Optional[ActorRole] = None,
    ) -> CreateUserResponse:
        """CreateUser

        Creates a user.

        :param email: The email address of the user. (required)
        :type email: str
        :param full_name: The full name of the user. (required)
        :type full_name: str
        :param password: The password of the user. This password will be changed on the first login. (required)
        :type password: str
        :param org_role:
        :type org_role: ActorRole
        :return: Returns the result object.
        """ # noqa: E501

        body = CreateUserRequest(
          email=email,
          full_name=full_name,
          org_role=org_role,
          password=password,
        )

        _param = self._create_user_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateUserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_user_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_api_token(
        self,
        id_uuid: str,
    ) -> object:
        """DeleteAPIToken

        Delete an API token by ID.

        :param id_uuid: Unique object ID. (required)
        :type id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_api_token_serialize(
            id_uuid=id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_api_token_serialize(
        self,
        id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if id_uuid is not None:
            _path_params['id.uuid'] = id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/users/api-tokens/{id.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_user(
        self,
        user_id_uuid: str,
    ) -> object:
        """DeleteUser

        Delete the user with the specified ID.

        :param user_id_uuid: Unique object ID. (required)
        :type user_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_user_serialize(
            user_id_uuid=user_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_user_serialize(
        self,
        user_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if user_id_uuid is not None:
            _path_params['userId.uuid'] = user_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/users/{userId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_user(
        self,
        user_id_uuid: str,
        oidc_id_token: Optional[str] = None,
    ) -> GetUserResponse:
        """GetUser

        Return the user with the specified ID.

        :param user_id_uuid: Unique object ID. (required)
        :type user_id_uuid: str
        :param oidc_id_token: ID of the OIDC provider token.
        :type oidc_id_token: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_user_serialize(
            user_id_uuid=user_id_uuid,
            oidc_id_token=oidc_id_token,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_user_serialize(
        self,
        user_id_uuid,
        oidc_id_token,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if user_id_uuid is not None:
            _path_params['userId.uuid'] = user_id_uuid
        if oidc_id_token is not None:
            
            _query_params.append(('oidcIdToken', oidc_id_token))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/users/{userId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_api_tokens(
        self,
        page_size: Optional[str] = None,
        workspace_id_uuid: Optional[str] = None,
        page_token: Optional[str] = None,
        first_page_query_token_type: Optional[str] = None,
    ) -> ListAPITokensResponse:
        """ListAPITokens

        List all API tokens for a Workspace.

        :param page_size: The maximum number of API Token objects to return in a single page.
        :type page_size: str
        :param workspace_id_uuid: Unique object ID.
        :type workspace_id_uuid: str
        :param page_token: Specifies a page of the list returned by a ListAPITokens query. The ListAPITokens query returns a pageToken when there is more than one page of results.
        :type page_token: str
        :param first_page_query_token_type: Specifies the type of token. The query filters for results that match the specified type.
        :type first_page_query_token_type: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_api_tokens_serialize(
            page_size=page_size,
            workspace_id_uuid=workspace_id_uuid,
            page_token=page_token,
            first_page_query_token_type=first_page_query_token_type,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListAPITokensResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_api_tokens_serialize(
        self,
        page_size,
        workspace_id_uuid,
        page_token,
        first_page_query_token_type,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if workspace_id_uuid is not None:
            
            _query_params.append(('workspaceId.uuid', workspace_id_uuid))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if first_page_query_token_type is not None:
            
            _query_params.append(('firstPageQuery.tokenType', first_page_query_token_type))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/users/api-tokens',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_current_user_roles(
        self,
    ) -> ListCurrentUserRolesResponse:
        """ListCurrentUserRoles

        Returns the list of roles of the logged in user.

        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_current_user_roles_serialize(
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListCurrentUserRolesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_current_user_roles_serialize(
        self,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/users/roles',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_users(
        self,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListUsersResponse:
        """ListUsers

        List all users.

        :param page_token: Specifies a page of the list returned by a ListUsers query. The ListUsers query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageQuery field.
        :type page_token: str
        :param page_size: The maximum number of User objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_users_serialize(
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListUsersResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_users_serialize(
        self,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def reset_password(
        self,
        user_id_uuid: str,
        new_password: str,
        old_password: Optional[str] = None,
        user_id: Optional[object] = None,
    ) -> object:
        """ResetPassword

        Reset the password of a user with the specified ID.

        :param user_id_uuid: Unique object ID. (required)
        :type user_id_uuid: str
        :param new_password: (required)
        :type new_password: str
        :param old_password:
        :type old_password: str
        :param user_id: Unique ID of an object in RIME.
        :type user_id: object
        :return: Returns the result object.
        """ # noqa: E501

        body = ResetPasswordRequest(
          new_password=new_password,
          old_password=old_password,
          user_id=user_id,
        )

        _param = self._reset_password_serialize(
            user_id_uuid=user_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _reset_password_serialize(
        self,
        user_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if user_id_uuid is not None:
            _path_params['userId.uuid'] = user_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/users/reset-password/{userId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_agent_api_token(
        self,
        agent_id: Optional[ID] = None,
    ) -> UpdateAgentAPITokenResponse:
        """UpdateAgentAPIToken

        Refreshes an agent's API token.

        :param agent_id:
        :type agent_id: ID
        :return: Returns the result object.
        """ # noqa: E501

        body = UpdateAgentAPITokenRequest(
          agent_id=agent_id,
        )

        _param = self._update_agent_api_token_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateAgentAPITokenResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_agent_api_token_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/users/agent-api-tokens',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_user(
        self,
        user_id_uuid: str,
        mask: Optional[UserWriteMask] = None,
        user: Optional[UpdateUserRequestUser] = None,
    ) -> object:
        """UpdateUser

        Update a user with the specified ID.

        :param user_id_uuid: Unique object ID. (required)
        :type user_id_uuid: str
        :param mask:
        :type mask: UserWriteMask
        :param user:
        :type user: UpdateUserRequestUser
        :return: Returns the result object.
        """ # noqa: E501

        body = UpdateUserRequest(
          mask=mask,
          user=user,
        )

        _param = self._update_user_serialize(
            user_id_uuid=user_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_user_serialize(
        self,
        user_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if user_id_uuid is not None:
            _path_params['user.id.uuid'] = user_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/users/{user.id.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
