# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Any, Dict, Optional
from typing_extensions import Annotated
from ri.apiclient.models.add_users_to_workspace_request import AddUsersToWorkspaceRequest
from ri.apiclient.models.create_workspace_request import CreateWorkspaceRequest
from ri.apiclient.models.create_workspace_response import CreateWorkspaceResponse
from ri.apiclient.models.get_workspace_response import GetWorkspaceResponse
from ri.apiclient.models.list_project_tags_in_workspace_response import ListProjectTagsInWorkspaceResponse
from ri.apiclient.models.list_users_of_workspace_response import ListUsersOfWorkspaceResponse
from ri.apiclient.models.list_workspaces_response import ListWorkspacesResponse
from ri.apiclient.models.update_user_of_workspace_request import UpdateUserOfWorkspaceRequest
from ri.apiclient.models.update_workspace_request import UpdateWorkspaceRequest

from ri.apiclient.models import *
from ri.apiclient.api_client import ApiClient, RequestSerialized
from ri.apiclient.api_response import ApiResponse
from ri.apiclient.rest import RESTResponseType


class WorkspaceServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def add_users_to_workspace(
        self,
        workspace_id_uuid: str,
        users: List[UserWithRole],
        workspace_id: Optional[object] = None,
    ) -> object:
        """AddUsersToWorkspace

        Grants Users permissions to a Workspace.

        :param workspace_id_uuid: Unique object ID. (required)
        :type workspace_id_uuid: str
        :param users: List of Users to add to the Workspace. (required)
        :type users: List[UserWithRole]
        :param workspace_id: Unique ID of an object in RIME.
        :type workspace_id: object
        :return: Returns the result object.
        """ # noqa: E501

        body = AddUsersToWorkspaceRequest(
          users=users,
          workspace_id=workspace_id,
        )

        _param = self._add_users_to_workspace_serialize(
            workspace_id_uuid=workspace_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _add_users_to_workspace_serialize(
        self,
        workspace_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if workspace_id_uuid is not None:
            _path_params['workspaceId.uuid'] = workspace_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/workspace/{workspaceId.uuid}/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def create_workspace(
        self,
        name: str,
        agent_ids: Optional[List[ID]] = None,
        default_agent_id: Optional[ID] = None,
        description: Optional[str] = None,
        results_retention_in_days: Optional[int] = None,
    ) -> CreateWorkspaceResponse:
        """CreateWorkspace

        Create a new Workspace.

        :param name: Name of the Workspace. (required)
        :type name: str
        :param agent_ids: List of Agent IDs to be added to the Workspace.
        :type agent_ids: List[ID]
        :param default_agent_id:
        :type default_agent_id: ID
        :param description: Description of the Workspace.
        :type description: str
        :param results_retention_in_days:
        :type results_retention_in_days: int
        :return: Returns the result object.
        """ # noqa: E501

        body = CreateWorkspaceRequest(
          agent_ids=agent_ids,
          default_agent_id=default_agent_id,
          description=description,
          name=name,
          results_retention_in_days=results_retention_in_days,
        )

        _param = self._create_workspace_serialize(
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateWorkspaceResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _create_workspace_serialize(
        self,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/workspace',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def delete_workspace(
        self,
        workspace_id_uuid: str,
    ) -> object:
        """DeleteWorkspace

        Deletes an existing Workspace by ID.

        :param workspace_id_uuid: Unique object ID. (required)
        :type workspace_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._delete_workspace_serialize(
            workspace_id_uuid=workspace_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _delete_workspace_serialize(
        self,
        workspace_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if workspace_id_uuid is not None:
            _path_params['workspaceId.uuid'] = workspace_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/workspace/{workspaceId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def get_workspace(
        self,
        workspace_id_uuid: str,
    ) -> GetWorkspaceResponse:
        """GetWorkspace

        Return a Workspace by ID.

        :param workspace_id_uuid: Unique object ID. (required)
        :type workspace_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_workspace_serialize(
            workspace_id_uuid=workspace_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetWorkspaceResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_workspace_serialize(
        self,
        workspace_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if workspace_id_uuid is not None:
            _path_params['workspaceId.uuid'] = workspace_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/workspace/{workspaceId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_project_tags_in_workspace(
        self,
        workspace_id_uuid: str,
    ) -> ListProjectTagsInWorkspaceResponse:
        """ListProjectTagsInWorkspace

        List the union of all tags in all projects in the workspace

        :param workspace_id_uuid: Unique object ID. (required)
        :type workspace_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_project_tags_in_workspace_serialize(
            workspace_id_uuid=workspace_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListProjectTagsInWorkspaceResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_project_tags_in_workspace_serialize(
        self,
        workspace_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if workspace_id_uuid is not None:
            _path_params['workspaceId.uuid'] = workspace_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/workspace/{workspaceId.uuid}/tags/project',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_users_of_workspace(
        self,
        workspace_id_uuid: str,
        page_token: Optional[str] = None,
        page_size: Optional[str] = None,
    ) -> ListUsersOfWorkspaceResponse:
        """ListUsersOfWorkspace

        Lists all Users that have permissions to a Workspace.

        :param workspace_id_uuid: Unique object ID. (required)
        :type workspace_id_uuid: str
        :param page_token: Specifies a page of the list returned by a ListUsersOfWorkspace query. The ListUsersOfWorkspace query returns a pageToken when there is more than one page of results.
        :type page_token: str
        :param page_size: The maximum number of User objects to return in a single page.
        :type page_size: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_users_of_workspace_serialize(
            workspace_id_uuid=workspace_id_uuid,
            page_token=page_token,
            page_size=page_size,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListUsersOfWorkspaceResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_users_of_workspace_serialize(
        self,
        workspace_id_uuid,
        page_token,
        page_size,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if workspace_id_uuid is not None:
            _path_params['workspaceId.uuid'] = workspace_id_uuid
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/workspace/{workspaceId.uuid}/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_workspaces(
        self,
        page_size: Optional[str] = None,
        page_token: Optional[str] = None,
    ) -> ListWorkspacesResponse:
        """ListWorkspaces

        List Workspaces with optional filter.

        :param page_size: The maximum number of Workspace objects to return in a single page.
        :type page_size: str
        :param page_token: Specifies a page of the list returned by a ListWorkspaces query. The ListWorkspaces query returns a pageToken when there is more than one page of results.
        :type page_token: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_workspaces_serialize(
            page_size=page_size,
            page_token=page_token,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWorkspacesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_workspaces_serialize(
        self,
        page_size,
        page_token,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/workspace',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def remove_user_from_workspace(
        self,
        workspace_id_uuid: str,
        user_id_uuid: str,
    ) -> object:
        """RemoveUserFromWorkspace

        Removes a User from a Workspace.

        :param workspace_id_uuid: Unique object ID. (required)
        :type workspace_id_uuid: str
        :param user_id_uuid: Unique object ID. (required)
        :type user_id_uuid: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._remove_user_from_workspace_serialize(
            workspace_id_uuid=workspace_id_uuid,
            user_id_uuid=user_id_uuid,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _remove_user_from_workspace_serialize(
        self,
        workspace_id_uuid,
        user_id_uuid,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if workspace_id_uuid is not None:
            _path_params['workspaceId.uuid'] = workspace_id_uuid
        if user_id_uuid is not None:
            _path_params['userId.uuid'] = user_id_uuid
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/workspace/{workspaceId.uuid}/users/{userId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_user_of_workspace(
        self,
        workspace_id_uuid: str,
        user_user_id_uuid: str,
        user: Optional[UpdateUserOfProjectRequestUser] = None,
        workspace_id: Optional[object] = None,
    ) -> object:
        """UpdateUserOfWorkspace

        Updates the permission of a specified User for a Workspace.

        :param workspace_id_uuid: Unique object ID. (required)
        :type workspace_id_uuid: str
        :param user_user_id_uuid: Unique object ID. (required)
        :type user_user_id_uuid: str
        :param user:
        :type user: UpdateUserOfProjectRequestUser
        :param workspace_id: Unique ID of an object in RIME.
        :type workspace_id: object
        :return: Returns the result object.
        """ # noqa: E501

        body = UpdateUserOfWorkspaceRequest(
          user=user,
          workspace_id=workspace_id,
        )

        _param = self._update_user_of_workspace_serialize(
            workspace_id_uuid=workspace_id_uuid,
            user_user_id_uuid=user_user_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_user_of_workspace_serialize(
        self,
        workspace_id_uuid,
        user_user_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if workspace_id_uuid is not None:
            _path_params['workspaceId.uuid'] = workspace_id_uuid
        if user_user_id_uuid is not None:
            _path_params['user.userId.uuid'] = user_user_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/workspace/{workspaceId.uuid}/users/{user.userId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def update_workspace(
        self,
        workspace_workspace_id_uuid: str,
        workspace: Optional[UpdateWorkspaceRequestWorkspace] = None,
        workspace_write_mask: Optional[WorkspaceWriteMask] = None,
    ) -> object:
        """UpdateWorkspace

        Updates an existing Workspace by ID.

        :param workspace_workspace_id_uuid: Unique object ID. (required)
        :type workspace_workspace_id_uuid: str
        :param workspace:
        :type workspace: UpdateWorkspaceRequestWorkspace
        :param workspace_write_mask:
        :type workspace_write_mask: WorkspaceWriteMask
        :return: Returns the result object.
        """ # noqa: E501

        body = UpdateWorkspaceRequest(
          workspace=workspace,
          workspace_write_mask=workspace_write_mask,
        )

        _param = self._update_workspace_serialize(
            workspace_workspace_id_uuid=workspace_workspace_id_uuid,
            body=body,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _update_workspace_serialize(
        self,
        workspace_workspace_id_uuid,
        body,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if workspace_workspace_id_uuid is not None:
            _path_params['workspace.workspaceId.uuid'] = workspace_workspace_id_uuid
        if body is not None:
            _body_params = body
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        _default_content_type = (
            self.api_client.select_header_content_type(
                [
                    'application/json'
                ]
            )
        )
        if _default_content_type is not None:
            _header_params['Content-Type'] = _default_content_type

        _auth_settings: List[str] = [
            'rime-api-key'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/workspace/{workspace.workspaceId.uuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
