# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.agent_desired_state import AgentDesiredState
from ri.apiclient.models.agent_status import AgentStatus
from ri.apiclient.models.agent_type import AgentType
from ri.apiclient.models.id import ID
from typing import Optional, Set
from typing_extensions import Self

class Agent(BaseModel):
    """
    Agent
    """ # noqa: E501
    agent_id: Optional[ID] = Field(default=None, alias="agentId")
    creation_time: Optional[datetime] = Field(default=None, description="The time of creation of the agent.", alias="creationTime")
    desired_state: Optional[AgentDesiredState] = Field(default=None, alias="desiredState")
    internal: Optional[StrictBool] = Field(default=None, description="Specifies whether the agent is an internal agent. Internal agents come bundled with the deployment.")
    last_heartbeat_time: Optional[datetime] = Field(default=None, description="The time of the last heartbeat.", alias="lastHeartbeatTime")
    name: Optional[StrictStr] = Field(default=None, description="The user specified name of the agent.")
    status: Optional[AgentStatus] = None
    type: Optional[AgentType] = None
    url: Optional[StrictStr] = Field(default=None, description="The url of the agent. E.g., https://dev.my-firewall.rbst.io This is used for firewall agents, which can have a different URL than the control plane.")
    version: Optional[StrictStr] = Field(default=None, description="Agent version.")
    __properties: ClassVar[List[str]] = ["agentId", "creationTime", "desiredState", "internal", "lastHeartbeatTime", "name", "status", "type", "url", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Agent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of agent_id
        if self.agent_id:
            _dict['agentId'] = self.agent_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of desired_state
        if self.desired_state:
            _dict['desiredState'] = self.desired_state.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Agent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "agentId": ID.from_dict(obj["agentId"]) if obj.get("agentId") is not None else None,
            "creationTime": obj.get("creationTime"),
            "desiredState": AgentDesiredState.from_dict(obj["desiredState"]) if obj.get("desiredState") is not None else None,
            "internal": obj.get("internal"),
            "lastHeartbeatTime": obj.get("lastHeartbeatTime"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "url": obj.get("url"),
            "version": obj.get("version")
        })
        return _obj


