# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.category_test_identifier import CategoryTestIdentifier
from ri.apiclient.models.subset_test_metric_identifier import SubsetTestMetricIdentifier
from ri.apiclient.models.test_case_metric_identifier import TestCaseMetricIdentifier
from typing import Optional, Set
from typing_extensions import Self

class ArtifactIdentifier(BaseModel):
    """
    ArtifactIdentifier specifies the artifact a monitor tracks over time. Metrics exist in TestCases, TestBatches and CategoryTests. This is extendable to allow new kinds of metrics.
    """ # noqa: E501
    category_test_metric_identifier: Optional[CategoryTestIdentifier] = Field(default=None, alias="categoryTestMetricIdentifier")
    subset_test_metric_identifier: Optional[SubsetTestMetricIdentifier] = Field(default=None, alias="subsetTestMetricIdentifier")
    test_case_metric_identifier: Optional[TestCaseMetricIdentifier] = Field(default=None, alias="testCaseMetricIdentifier")
    __properties: ClassVar[List[str]] = ["categoryTestMetricIdentifier", "subsetTestMetricIdentifier", "testCaseMetricIdentifier"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ArtifactIdentifier from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of category_test_metric_identifier
        if self.category_test_metric_identifier:
            _dict['categoryTestMetricIdentifier'] = self.category_test_metric_identifier.to_dict()
        # override the default output from pydantic by calling `to_dict()` of subset_test_metric_identifier
        if self.subset_test_metric_identifier:
            _dict['subsetTestMetricIdentifier'] = self.subset_test_metric_identifier.to_dict()
        # override the default output from pydantic by calling `to_dict()` of test_case_metric_identifier
        if self.test_case_metric_identifier:
            _dict['testCaseMetricIdentifier'] = self.test_case_metric_identifier.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ArtifactIdentifier from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "categoryTestMetricIdentifier": CategoryTestIdentifier.from_dict(obj["categoryTestMetricIdentifier"]) if obj.get("categoryTestMetricIdentifier") is not None else None,
            "subsetTestMetricIdentifier": SubsetTestMetricIdentifier.from_dict(obj["subsetTestMetricIdentifier"]) if obj.get("subsetTestMetricIdentifier") is not None else None,
            "testCaseMetricIdentifier": TestCaseMetricIdentifier.from_dict(obj["testCaseMetricIdentifier"]) if obj.get("testCaseMetricIdentifier") is not None else None
        })
        return _obj


