# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.aws_access_key import AWSAccessKey
from ri.apiclient.models.aws_region import AWSRegion
from ri.apiclient.models.bedrock_inference_config import BedrockInferenceConfig
from typing import Optional, Set
from typing_extensions import Self

class BedrockConnectionSpec(BaseModel):
    """
    BedrockConnectionSpec defines the information needed to make and parse a request to AWS Bedrock.
    """ # noqa: E501
    additional_config: Optional[Dict[str, Any]] = Field(default=None, alias="additionalConfig")
    assume_role_arn: Optional[StrictStr] = Field(default=None, alias="assumeRoleArn")
    aws_access_key: Optional[AWSAccessKey] = Field(default=None, alias="awsAccessKey")
    body_template: Optional[Dict[str, Any]] = Field(default=None, alias="bodyTemplate")
    inference_config: Optional[BedrockInferenceConfig] = Field(default=None, alias="inferenceConfig")
    model_id: Optional[StrictStr] = Field(default=None, description="Specifies the model id to use.", alias="modelId")
    region: Optional[AWSRegion] = None
    response_json_path: Optional[StrictStr] = Field(default=None, description="A json path specifying where in the response json payload we can find the LLM's response response string. Note that the path must point to a string value in the json payload. Whitespace and other special characters can be encoded as unicode (\\u0020). Periods in json fields can be escaped with a backslash.", alias="responseJsonPath")
    __properties: ClassVar[List[str]] = ["additionalConfig", "assumeRoleArn", "awsAccessKey", "bodyTemplate", "inferenceConfig", "modelId", "region", "responseJsonPath"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BedrockConnectionSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of aws_access_key
        if self.aws_access_key:
            _dict['awsAccessKey'] = self.aws_access_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of inference_config
        if self.inference_config:
            _dict['inferenceConfig'] = self.inference_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BedrockConnectionSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "additionalConfig": obj.get("additionalConfig"),
            "assumeRoleArn": obj.get("assumeRoleArn"),
            "awsAccessKey": AWSAccessKey.from_dict(obj["awsAccessKey"]) if obj.get("awsAccessKey") is not None else None,
            "bodyTemplate": obj.get("bodyTemplate"),
            "inferenceConfig": BedrockInferenceConfig.from_dict(obj["inferenceConfig"]) if obj.get("inferenceConfig") is not None else None,
            "modelId": obj.get("modelId"),
            "region": obj.get("region"),
            "responseJsonPath": obj.get("responseJsonPath")
        })
        return _obj


