# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from ri.apiclient.models.category_metric import CategoryMetric
from ri.apiclient.models.rime_severity import RimeSeverity
from ri.apiclient.models.risk_category_type import RiskCategoryType
from ri.apiclient.models.severity_counts import SeverityCounts
from ri.apiclient.models.suggestion import Suggestion
from ri.apiclient.models.test_category_type import TestCategoryType
from typing import Optional, Set
from typing_extensions import Self

class CategoryTestResult(BaseModel):
    """
    CategoryTestResult is a summary of a single category of tests in Robust Intelligence. For instance, the \"Drift\" category includes specific tests such as Prediction Drift or Label Drift. The CategoryTestResult for Drift includes an overall severity and other details aggregated across those individual tests.
    """ # noqa: E501
    category_importance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The relative importance of the category.", alias="categoryImportance")
    category_metrics: Optional[List[CategoryMetric]] = Field(default=None, description="Category metrics are aggregated or important metrics for the category.", alias="categoryMetrics")
    description: Optional[StrictStr] = Field(default=None, description="Human-readable description of the category test result.")
    duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Duration is the total time in seconds for tests in that category.")
    failing_test_types: Optional[List[StrictStr]] = Field(default=None, description="List of all the failing test types.", alias="failingTestTypes")
    id: Optional[StrictStr] = Field(default=None, description="When combined with the test run ID, this uniquely identifies a category test result.")
    risk_category: Optional[RiskCategoryType] = None
    severity: Optional[RimeSeverity] = None
    severity_counts: Optional[SeverityCounts] = Field(default=None, alias="severityCounts")
    suggestion: Optional[Suggestion] = None
    test_batch_types: Optional[List[StrictStr]] = Field(default=None, description="List of the tests in the category.", alias="testBatchTypes")
    test_category: Optional[TestCategoryType] = None
    __properties: ClassVar[List[str]] = ["categoryImportance", "categoryMetrics", "description", "duration", "failingTestTypes", "id", "riskCategory", "severity", "severityCounts", "suggestion", "testBatchTypes", "testCategory"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CategoryTestResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in category_metrics (list)
        _items = []
        if self.category_metrics:
            for _item in self.category_metrics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['categoryMetrics'] = _items
        # override the default output from pydantic by calling `to_dict()` of severity_counts
        if self.severity_counts:
            _dict['severityCounts'] = self.severity_counts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of suggestion
        if self.suggestion:
            _dict['suggestion'] = self.suggestion.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CategoryTestResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "categoryImportance": obj.get("categoryImportance"),
            "categoryMetrics": [CategoryMetric.from_dict(_item) for _item in obj["categoryMetrics"]] if obj.get("categoryMetrics") is not None else None,
            "description": obj.get("description"),
            "duration": obj.get("duration"),
            "failingTestTypes": obj.get("failingTestTypes"),
            "id": obj.get("id"),
            "riskCategory": obj.get("riskCategory"),
            "severity": obj.get("severity"),
            "severityCounts": SeverityCounts.from_dict(obj["severityCounts"]) if obj.get("severityCounts") is not None else None,
            "suggestion": Suggestion.from_dict(obj["suggestion"]) if obj.get("suggestion") is not None else None,
            "testBatchTypes": obj.get("testBatchTypes"),
            "testCategory": obj.get("testCategory")
        })
        return _obj


