# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.aws_config import AWSConfig
from ri.apiclient.models.azure_config import AzureConfig
from ri.apiclient.models.gcp_config import GCPConfig
from typing import Optional, Set
from typing_extensions import Self

class CreateAgentRequest(BaseModel):
    """
    CreateAgentRequest is the request for creating an agent.
    """ # noqa: E501
    aws_config: Optional[AWSConfig] = Field(default=None, alias="awsConfig")
    azure_config: Optional[AzureConfig] = Field(default=None, alias="azureConfig")
    gcp_config: Optional[GCPConfig] = Field(default=None, alias="gcpConfig")
    local_config: Optional[Dict[str, Any]] = Field(default=None, description="Configuration for local machine.", alias="localConfig")
    name: Optional[StrictStr] = Field(default=None, description="Agent name given by the user.")
    __properties: ClassVar[List[str]] = ["awsConfig", "azureConfig", "gcpConfig", "localConfig", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateAgentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of aws_config
        if self.aws_config:
            _dict['awsConfig'] = self.aws_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of azure_config
        if self.azure_config:
            _dict['azureConfig'] = self.azure_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gcp_config
        if self.gcp_config:
            _dict['gcpConfig'] = self.gcp_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateAgentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "awsConfig": AWSConfig.from_dict(obj["awsConfig"]) if obj.get("awsConfig") is not None else None,
            "azureConfig": AzureConfig.from_dict(obj["azureConfig"]) if obj.get("azureConfig") is not None else None,
            "gcpConfig": GCPConfig.from_dict(obj["gcpConfig"]) if obj.get("gcpConfig") is not None else None,
            "localConfig": obj.get("localConfig"),
            "name": obj.get("name")
        })
        return _obj


