# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.package_requirement import PackageRequirement
from ri.apiclient.models.pip_requirement import PipRequirement
from typing import Optional, Set
from typing_extensions import Self

class CreateImageRequest(BaseModel):
    """
    Request and response for a CreateImage RPC.
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the Managed Image.")
    package_requirements: Optional[List[PackageRequirement]] = Field(default=None, description="List of system requirements that specify the customization used for this Image.", alias="packageRequirements")
    pip_requirements: List[PipRequirement] = Field(description="List of `pip` requirements that specify the customization used for this Image.", alias="pipRequirements")
    python_version: Optional[StrictStr] = Field(default=None, description="The version of the Python interpreter to use.", alias="pythonVersion")
    __properties: ClassVar[List[str]] = ["name", "packageRequirements", "pipRequirements", "pythonVersion"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateImageRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in package_requirements (list)
        _items = []
        if self.package_requirements:
            for _item in self.package_requirements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['packageRequirements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pip_requirements (list)
        _items = []
        if self.pip_requirements:
            for _item in self.pip_requirements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['pipRequirements'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateImageRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "packageRequirements": [PackageRequirement.from_dict(_item) for _item in obj["packageRequirements"]] if obj.get("packageRequirements") is not None else None,
            "pipRequirements": [PipRequirement.from_dict(_item) for _item in obj["pipRequirements"]] if obj.get("pipRequirements") is not None else None,
            "pythonVersion": obj.get("pythonVersion")
        })
        return _obj


