# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.category_config_generation_service_response import CategoryConfigGenerationServiceResponse
from ri.apiclient.models.check_object_exists_response import CheckObjectExistsResponse
from ri.apiclient.models.get_read_object_presigned_link_response import GetReadObjectPresignedLinkResponse
from ri.apiclient.models.get_upload_object_presigned_link_response import GetUploadObjectPresignedLinkResponse
from ri.apiclient.models.list_objects_response import ListObjectsResponse
from ri.apiclient.models.profiling_config_generation_service_response import ProfilingConfigGenerationServiceResponse
from ri.apiclient.models.test_suite_config_generation_service_response import TestSuiteConfigGenerationServiceResponse
from ri.apiclient.models.validate_dataset_response import ValidateDatasetResponse
from ri.apiclient.models.validate_model_response import ValidateModelResponse
from ri.apiclient.models.validate_predictions_response import ValidatePredictionsResponse
from typing import Optional, Set
from typing_extensions import Self

class CrossPlaneResponse(BaseModel):
    """
    CrossPlaneResponse encompasses the set of responses from cross-plane services.
    """ # noqa: E501
    category_config_generation_service_response: Optional[CategoryConfigGenerationServiceResponse] = Field(default=None, alias="categoryConfigGenerationServiceResponse")
    check_object_exists_response: Optional[CheckObjectExistsResponse] = Field(default=None, alias="checkObjectExistsResponse")
    delete_object_response: Optional[Dict[str, Any]] = Field(default=None, alias="deleteObjectResponse")
    get_read_object_presigned_link_response: Optional[GetReadObjectPresignedLinkResponse] = Field(default=None, alias="getReadObjectPresignedLinkResponse")
    get_upload_object_presigned_link_response: Optional[GetUploadObjectPresignedLinkResponse] = Field(default=None, alias="getUploadObjectPresignedLinkResponse")
    list_objects_response: Optional[ListObjectsResponse] = Field(default=None, alias="listObjectsResponse")
    profiling_config_generation_service_response: Optional[ProfilingConfigGenerationServiceResponse] = Field(default=None, alias="profilingConfigGenerationServiceResponse")
    test_suite_config_generation_service_response: Optional[TestSuiteConfigGenerationServiceResponse] = Field(default=None, alias="testSuiteConfigGenerationServiceResponse")
    validate_dataset_response: Optional[ValidateDatasetResponse] = Field(default=None, alias="validateDatasetResponse")
    validate_model_response: Optional[ValidateModelResponse] = Field(default=None, alias="validateModelResponse")
    validate_predictions_response: Optional[ValidatePredictionsResponse] = Field(default=None, alias="validatePredictionsResponse")
    __properties: ClassVar[List[str]] = ["categoryConfigGenerationServiceResponse", "checkObjectExistsResponse", "deleteObjectResponse", "getReadObjectPresignedLinkResponse", "getUploadObjectPresignedLinkResponse", "listObjectsResponse", "profilingConfigGenerationServiceResponse", "testSuiteConfigGenerationServiceResponse", "validateDatasetResponse", "validateModelResponse", "validatePredictionsResponse"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CrossPlaneResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of category_config_generation_service_response
        if self.category_config_generation_service_response:
            _dict['categoryConfigGenerationServiceResponse'] = self.category_config_generation_service_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of check_object_exists_response
        if self.check_object_exists_response:
            _dict['checkObjectExistsResponse'] = self.check_object_exists_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of get_read_object_presigned_link_response
        if self.get_read_object_presigned_link_response:
            _dict['getReadObjectPresignedLinkResponse'] = self.get_read_object_presigned_link_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of get_upload_object_presigned_link_response
        if self.get_upload_object_presigned_link_response:
            _dict['getUploadObjectPresignedLinkResponse'] = self.get_upload_object_presigned_link_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of list_objects_response
        if self.list_objects_response:
            _dict['listObjectsResponse'] = self.list_objects_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of profiling_config_generation_service_response
        if self.profiling_config_generation_service_response:
            _dict['profilingConfigGenerationServiceResponse'] = self.profiling_config_generation_service_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of test_suite_config_generation_service_response
        if self.test_suite_config_generation_service_response:
            _dict['testSuiteConfigGenerationServiceResponse'] = self.test_suite_config_generation_service_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of validate_dataset_response
        if self.validate_dataset_response:
            _dict['validateDatasetResponse'] = self.validate_dataset_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of validate_model_response
        if self.validate_model_response:
            _dict['validateModelResponse'] = self.validate_model_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of validate_predictions_response
        if self.validate_predictions_response:
            _dict['validatePredictionsResponse'] = self.validate_predictions_response.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CrossPlaneResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "categoryConfigGenerationServiceResponse": CategoryConfigGenerationServiceResponse.from_dict(obj["categoryConfigGenerationServiceResponse"]) if obj.get("categoryConfigGenerationServiceResponse") is not None else None,
            "checkObjectExistsResponse": CheckObjectExistsResponse.from_dict(obj["checkObjectExistsResponse"]) if obj.get("checkObjectExistsResponse") is not None else None,
            "deleteObjectResponse": obj.get("deleteObjectResponse"),
            "getReadObjectPresignedLinkResponse": GetReadObjectPresignedLinkResponse.from_dict(obj["getReadObjectPresignedLinkResponse"]) if obj.get("getReadObjectPresignedLinkResponse") is not None else None,
            "getUploadObjectPresignedLinkResponse": GetUploadObjectPresignedLinkResponse.from_dict(obj["getUploadObjectPresignedLinkResponse"]) if obj.get("getUploadObjectPresignedLinkResponse") is not None else None,
            "listObjectsResponse": ListObjectsResponse.from_dict(obj["listObjectsResponse"]) if obj.get("listObjectsResponse") is not None else None,
            "profilingConfigGenerationServiceResponse": ProfilingConfigGenerationServiceResponse.from_dict(obj["profilingConfigGenerationServiceResponse"]) if obj.get("profilingConfigGenerationServiceResponse") is not None else None,
            "testSuiteConfigGenerationServiceResponse": TestSuiteConfigGenerationServiceResponse.from_dict(obj["testSuiteConfigGenerationServiceResponse"]) if obj.get("testSuiteConfigGenerationServiceResponse") is not None else None,
            "validateDatasetResponse": ValidateDatasetResponse.from_dict(obj["validateDatasetResponse"]) if obj.get("validateDatasetResponse") is not None else None,
            "validateModelResponse": ValidateModelResponse.from_dict(obj["validateModelResponse"]) if obj.get("validateModelResponse") is not None else None,
            "validatePredictionsResponse": ValidatePredictionsResponse.from_dict(obj["validatePredictionsResponse"]) if obj.get("validatePredictionsResponse") is not None else None
        })
        return _obj


