# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.feature_intersection import FeatureIntersection
from ri.apiclient.models.ranking_info import RankingInfo
from typing import Optional, Set
from typing_extensions import Self

class DataParams(BaseModel):
    """
    DataParams specifies the parameters for a dataset.
    """ # noqa: E501
    categorical_features: Optional[List[StrictStr]] = Field(default=None, description="Feature types and relations.", alias="categoricalFeatures")
    class_names: Optional[List[StrictStr]] = Field(default=None, description="List of label class names.", alias="classNames")
    experimental_fields: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, description="Fields that enable experimental functionality.  WARNING: these fields are experimental; ie, their functionality may not be reliable or backwards-compatible. Do not use these fields in production.", alias="experimentalFields")
    feature_type_path: Optional[StrictStr] = Field(default=None, description="Path to a CSV file that specifies the data type of each feature. The file should have two columns: FeatureName and FeatureType.", alias="featureTypePath")
    features_not_in_model: Optional[List[StrictStr]] = Field(default=None, alias="featuresNotInModel")
    image_features: Optional[List[StrictStr]] = Field(default=None, description="Image features to run CV tests over.", alias="imageFeatures")
    image_load_path: Optional[StrictStr] = Field(default=None, description="Path to a python file containing a custom function for loading images in the dataset.", alias="imageLoadPath")
    intersections: Optional[List[FeatureIntersection]] = Field(default=None, description="A list of arrays of features. Each array represents the intersection of features on which certain subset and fairness tests are run.")
    label_col: Optional[StrictStr] = Field(default=None, description="Naming of special columns.", alias="labelCol")
    loading_kwargs: Optional[StrictStr] = Field(default=None, description="Paths for external resources. Keyword arguments to be passed to the pandas loading function (either pd.read_CSV or pd.read_Parquet, depending on your data format). NOTE: if you wish to specify nrows, this should NOT be done with kwargs.", alias="loadingKwargs")
    nrows: Optional[StrictStr] = Field(default=None, description="Dataset size parameters. Number of rows of data to load and test. If null, will load all rows.")
    nrows_per_time_bin: Optional[StrictStr] = Field(default=None, description="Number of rows of data per time bin to load and test in CT. If null, will load all rows.", alias="nrowsPerTimeBin")
    prompt_col: Optional[StrictStr] = Field(default=None, description="Prompt template column for Generative tasks.", alias="promptCol")
    protected_features: Optional[List[StrictStr]] = Field(default=None, description="Features that are protected attributes. If Bias and Fairness category is specified, these tests will run only over protected_features.", alias="protectedFeatures")
    ranking_info: Optional[RankingInfo] = Field(default=None, alias="rankingInfo")
    sample: Optional[StrictBool] = Field(default=None, description="Whether to sample rows in the data. Default is True.")
    text_features: Optional[List[StrictStr]] = Field(default=None, description="Text features to run NLP tests over.", alias="textFeatures")
    timestamp_col: Optional[StrictStr] = Field(default=None, description="Column to look at for CT timestamp.", alias="timestampCol")
    __properties: ClassVar[List[str]] = ["categoricalFeatures", "classNames", "experimentalFields", "featureTypePath", "featuresNotInModel", "imageFeatures", "imageLoadPath", "intersections", "labelCol", "loadingKwargs", "nrows", "nrowsPerTimeBin", "promptCol", "protectedFeatures", "rankingInfo", "sample", "textFeatures", "timestampCol"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in intersections (list)
        _items = []
        if self.intersections:
            for _item in self.intersections:
                if _item:
                    _items.append(_item.to_dict())
            _dict['intersections'] = _items
        # override the default output from pydantic by calling `to_dict()` of ranking_info
        if self.ranking_info:
            _dict['rankingInfo'] = self.ranking_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "categoricalFeatures": obj.get("categoricalFeatures"),
            "classNames": obj.get("classNames"),
            "experimentalFields": obj.get("experimentalFields"),
            "featureTypePath": obj.get("featureTypePath"),
            "featuresNotInModel": obj.get("featuresNotInModel"),
            "imageFeatures": obj.get("imageFeatures"),
            "imageLoadPath": obj.get("imageLoadPath"),
            "intersections": [FeatureIntersection.from_dict(_item) for _item in obj["intersections"]] if obj.get("intersections") is not None else None,
            "labelCol": obj.get("labelCol"),
            "loadingKwargs": obj.get("loadingKwargs"),
            "nrows": obj.get("nrows"),
            "nrowsPerTimeBin": obj.get("nrowsPerTimeBin"),
            "promptCol": obj.get("promptCol"),
            "protectedFeatures": obj.get("protectedFeatures"),
            "rankingInfo": RankingInfo.from_dict(obj["rankingInfo"]) if obj.get("rankingInfo") is not None else None,
            "sample": obj.get("sample"),
            "textFeatures": obj.get("textFeatures"),
            "timestampCol": obj.get("timestampCol")
        })
        return _obj


