# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from ri.apiclient.models.id import ID
from typing import Optional, Set
from typing_extensions import Self

class DatacollectorPrediction(BaseModel):
    """
    Prediction contains the prediction of a model for a datapoint.
    """ # noqa: E501
    data_stream_id: Optional[ID] = Field(default=None, alias="dataStreamId")
    datapoint_id: Optional[ID] = Field(default=None, alias="datapointId")
    model_id: Optional[ID] = Field(default=None, alias="modelId")
    prediction: Optional[Union[Annotated[bytes, Field(strict=True)], Annotated[str, Field(strict=True)]]] = None
    timestamp: Optional[datetime] = Field(default=None, description="The timestamp of the datapoint is stored in the prediction for fast querying.")
    __properties: ClassVar[List[str]] = ["dataStreamId", "datapointId", "modelId", "prediction", "timestamp"]

    @field_validator('prediction')
    def prediction_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$", value):
            raise ValueError(r"must validate the regular expression /^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatacollectorPrediction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data_stream_id
        if self.data_stream_id:
            _dict['dataStreamId'] = self.data_stream_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of datapoint_id
        if self.datapoint_id:
            _dict['datapointId'] = self.datapoint_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of model_id
        if self.model_id:
            _dict['modelId'] = self.model_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatacollectorPrediction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dataStreamId": ID.from_dict(obj["dataStreamId"]) if obj.get("dataStreamId") is not None else None,
            "datapointId": ID.from_dict(obj["datapointId"]) if obj.get("datapointId") is not None else None,
            "modelId": ID.from_dict(obj["modelId"]) if obj.get("modelId") is not None else None,
            "prediction": obj.get("prediction"),
            "timestamp": obj.get("timestamp")
        })
        return _obj


