# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.event_detail import EventDetail
from ri.apiclient.models.event_type import EventType
from ri.apiclient.models.id import ID
from ri.apiclient.models.resolution import Resolution
from ri.apiclient.models.rime_severity import RimeSeverity
from ri.apiclient.models.risk_category_type import RiskCategoryType
from ri.apiclient.models.test_category_type import TestCategoryType
from ri.apiclient.models.time_interval import TimeInterval
from typing import Optional, Set
from typing_extensions import Self

class DetectionEvent(BaseModel):
    """
    DetectionEvent describes a specific problem with a model. Examples of issues reported by this event include performance metrics dropping below a specified threshold or detecting an evasion attack. Each event is attached to a parent monitor that has a corresponding test in the RIME engine.
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="Human-readable description of the event.")
    description_html: Optional[StrictStr] = Field(default=None, description="Description of the event with HTML for nicer rendering.", alias="descriptionHtml")
    detail: Optional[EventDetail] = None
    event_object_id: Optional[StrictStr] = Field(default=None, description="The event object varies with the event type. CT and security events use a monitor. Offline Test events use the test run.", alias="eventObjectId")
    event_object_name: Optional[StrictStr] = Field(default=None, description="event_object_name to avoid extra query from UI to display, and allow easier search support with DB. If the event object is renamed, the event will not be updated.", alias="eventObjectName")
    event_time_range: Optional[TimeInterval] = Field(default=None, alias="eventTimeRange")
    event_type: Optional[EventType] = None
    firewall_id: Optional[ID] = Field(default=None, alias="firewallId")
    id: Optional[ID] = None
    last_update_time: Optional[datetime] = Field(default=None, alias="lastUpdateTime")
    project_id: Optional[ID] = Field(default=None, alias="projectId")
    resolution: Optional[Resolution] = None
    risk_category_type: Optional[RiskCategoryType] = None
    severity: Optional[RimeSeverity] = None
    test_category: Optional[TestCategoryType] = None
    __properties: ClassVar[List[str]] = ["description", "descriptionHtml", "detail", "eventObjectId", "eventObjectName", "eventTimeRange", "eventType", "firewallId", "id", "lastUpdateTime", "projectId", "resolution", "riskCategoryType", "severity", "testCategory"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DetectionEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of detail
        if self.detail:
            _dict['detail'] = self.detail.to_dict()
        # override the default output from pydantic by calling `to_dict()` of event_time_range
        if self.event_time_range:
            _dict['eventTimeRange'] = self.event_time_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of firewall_id
        if self.firewall_id:
            _dict['firewallId'] = self.firewall_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project_id
        if self.project_id:
            _dict['projectId'] = self.project_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resolution
        if self.resolution:
            _dict['resolution'] = self.resolution.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DetectionEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "descriptionHtml": obj.get("descriptionHtml"),
            "detail": EventDetail.from_dict(obj["detail"]) if obj.get("detail") is not None else None,
            "eventObjectId": obj.get("eventObjectId"),
            "eventObjectName": obj.get("eventObjectName"),
            "eventTimeRange": TimeInterval.from_dict(obj["eventTimeRange"]) if obj.get("eventTimeRange") is not None else None,
            "eventType": obj.get("eventType"),
            "firewallId": ID.from_dict(obj["firewallId"]) if obj.get("firewallId") is not None else None,
            "id": ID.from_dict(obj["id"]) if obj.get("id") is not None else None,
            "lastUpdateTime": obj.get("lastUpdateTime"),
            "projectId": ID.from_dict(obj["projectId"]) if obj.get("projectId") is not None else None,
            "resolution": Resolution.from_dict(obj["resolution"]) if obj.get("resolution") is not None else None,
            "riskCategoryType": obj.get("riskCategoryType"),
            "severity": obj.get("severity"),
            "testCategory": obj.get("testCategory")
        })
        return _obj


