# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.filescanning_file_security_report import FilescanningFileSecurityReport
from ri.apiclient.models.filescanning_repo_metadata import FilescanningRepoMetadata
from ri.apiclient.models.id import ID
from ri.apiclient.models.rime_severity import RimeSeverity
from typing import Optional, Set
from typing_extensions import Self

class FilescanningFileScanResult(BaseModel):
    """
    FilescanningFileScanResult
    """ # noqa: E501
    file_scan_id: Optional[ID] = Field(default=None, alias="fileScanId")
    file_security_reports: Optional[List[FilescanningFileSecurityReport]] = Field(default=None, description="The security reports for the files that were scanned.", alias="fileSecurityReports")
    model_id: Optional[ID] = Field(default=None, alias="modelId")
    project_id: Optional[ID] = Field(default=None, alias="projectId")
    repo_metadata: Optional[FilescanningRepoMetadata] = Field(default=None, alias="repoMetadata")
    rime_agent_version: Optional[StrictStr] = Field(default=None, description="The version of the RIME agent that was used to scan the model.", alias="rimeAgentVersion")
    severity: Optional[RimeSeverity] = None
    unscanned_file_paths: Optional[List[StrictStr]] = Field(default=None, description="The list of files that were not scanned.", alias="unscannedFilePaths")
    upload_time: Optional[datetime] = Field(default=None, description="The time when the file scan result was uploaded.", alias="uploadTime")
    __properties: ClassVar[List[str]] = ["fileScanId", "fileSecurityReports", "modelId", "projectId", "repoMetadata", "rimeAgentVersion", "severity", "unscannedFilePaths", "uploadTime"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FilescanningFileScanResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of file_scan_id
        if self.file_scan_id:
            _dict['fileScanId'] = self.file_scan_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in file_security_reports (list)
        _items = []
        if self.file_security_reports:
            for _item in self.file_security_reports:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fileSecurityReports'] = _items
        # override the default output from pydantic by calling `to_dict()` of model_id
        if self.model_id:
            _dict['modelId'] = self.model_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project_id
        if self.project_id:
            _dict['projectId'] = self.project_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repo_metadata
        if self.repo_metadata:
            _dict['repoMetadata'] = self.repo_metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FilescanningFileScanResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fileScanId": ID.from_dict(obj["fileScanId"]) if obj.get("fileScanId") is not None else None,
            "fileSecurityReports": [FilescanningFileSecurityReport.from_dict(_item) for _item in obj["fileSecurityReports"]] if obj.get("fileSecurityReports") is not None else None,
            "modelId": ID.from_dict(obj["modelId"]) if obj.get("modelId") is not None else None,
            "projectId": ID.from_dict(obj["projectId"]) if obj.get("projectId") is not None else None,
            "repoMetadata": FilescanningRepoMetadata.from_dict(obj["repoMetadata"]) if obj.get("repoMetadata") is not None else None,
            "rimeAgentVersion": obj.get("rimeAgentVersion"),
            "severity": obj.get("severity"),
            "unscannedFilePaths": obj.get("unscannedFilePaths"),
            "uploadTime": obj.get("uploadTime")
        })
        return _obj


