# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.monitor_type import MonitorType
from ri.apiclient.models.risk_category_type import RiskCategoryType
from typing import Optional, Set
from typing_extensions import Self

class Filter(BaseModel):
    """
    Filter
    """ # noqa: E501
    included_monitor_types: Optional[List[MonitorType]] = Field(default=None, description="Specifies a list of monitor types. Filters results to match the specified monitor types.", alias="includedMonitorTypes")
    included_risk_category_types: Optional[List[RiskCategoryType]] = Field(default=None, description="Specifies a list of risk category types. Filters results to match the specified risk category types.", alias="includedRiskCategoryTypes")
    pinned_monitors_only: Optional[StrictBool] = Field(default=None, description="When the value of this Boolean is True, this endpoint returns a list of pinned Monitors. Otherwise, this endpoint does not filter Monitors by pinned status.", alias="pinnedMonitorsOnly")
    __properties: ClassVar[List[str]] = ["includedMonitorTypes", "includedRiskCategoryTypes", "pinnedMonitorsOnly"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Filter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Filter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "includedMonitorTypes": obj.get("includedMonitorTypes"),
            "includedRiskCategoryTypes": obj.get("includedRiskCategoryTypes"),
            "pinnedMonitorsOnly": obj.get("pinnedMonitorsOnly")
        })
        return _obj


