# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.firewall_instance_deployment_config import FirewallInstanceDeploymentConfig
from ri.apiclient.models.model_server_config import ModelServerConfig
from ri.apiclient.models.yara_server_config import YaraServerConfig
from typing import Optional, Set
from typing_extensions import Self

class FirewallInstanceConfig(BaseModel):
    """
    Full version and sensitivity configuration for a firewall instance.
    """ # noqa: E501
    firewall_backend_image: Optional[StrictStr] = Field(default=None, alias="firewallBackendImage")
    firewall_server_image: Optional[StrictStr] = Field(default=None, alias="firewallServerImage")
    kubernetes_spec: Optional[FirewallInstanceDeploymentConfig] = Field(default=None, alias="kubernetesSpec")
    model_server_configs: Optional[List[ModelServerConfig]] = Field(default=None, alias="modelServerConfigs")
    yara_server_config: Optional[YaraServerConfig] = Field(default=None, alias="yaraServerConfig")
    __properties: ClassVar[List[str]] = ["firewallBackendImage", "firewallServerImage", "kubernetesSpec", "modelServerConfigs", "yaraServerConfig"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FirewallInstanceConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of kubernetes_spec
        if self.kubernetes_spec:
            _dict['kubernetesSpec'] = self.kubernetes_spec.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in model_server_configs (list)
        _items = []
        if self.model_server_configs:
            for _item in self.model_server_configs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['modelServerConfigs'] = _items
        # override the default output from pydantic by calling `to_dict()` of yara_server_config
        if self.yara_server_config:
            _dict['yaraServerConfig'] = self.yara_server_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FirewallInstanceConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "firewallBackendImage": obj.get("firewallBackendImage"),
            "firewallServerImage": obj.get("firewallServerImage"),
            "kubernetesSpec": FirewallInstanceDeploymentConfig.from_dict(obj["kubernetesSpec"]) if obj.get("kubernetesSpec") is not None else None,
            "modelServerConfigs": [ModelServerConfig.from_dict(_item) for _item in obj["modelServerConfigs"]] if obj.get("modelServerConfigs") is not None else None,
            "yaraServerConfig": YaraServerConfig.from_dict(obj["yaraServerConfig"]) if obj.get("yaraServerConfig") is not None else None
        })
        return _obj


