# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.attack_objective import AttackObjective
from ri.apiclient.models.example import Example
from ri.apiclient.models.generative_severity import GenerativeSeverity
from ri.apiclient.models.id import ID
from ri.apiclient.models.objective_sub_category import ObjectiveSubCategory
from ri.apiclient.models.standard_info import StandardInfo
from ri.apiclient.models.threat import Threat
from typing import Optional, Set
from typing_extensions import Self

class GenerativeValidationResult(BaseModel):
    """
    GenerativeValidationResult represents a single result of testing a Generative model with attack prompts. The model output is sent to a detection layer, which indicates whether it contains objectionable content. A test result represents a single prompt. Currently it has been updated to write to a channel in the test engine which can then be read to do what the consumer wants to do with it. No longer writing this to a DB on the RI side.
    """ # noqa: E501
    attack_objective: Optional[AttackObjective] = None
    attack_technique: Optional[StrictStr] = Field(default=None, description="The attack technique used in the prompt. This is a string because the types of attacks changes frequently over time depending on our threat intelligence.", alias="attackTechnique")
    example: Optional[Example] = None
    id: Optional[ID] = None
    mitre_standards: Optional[List[StandardInfo]] = Field(default=None, description="List of the MITRE AI risk standards associated with the attacks in these results.", alias="mitreStandards")
    nist_standards: Optional[List[StandardInfo]] = Field(default=None, description="List of the NIST AI risk standards associated with the attacks in these results.", alias="nistStandards")
    objective_sub_category: Optional[ObjectiveSubCategory] = None
    owasp_standards: Optional[List[StandardInfo]] = Field(default=None, description="List of the OWASP AI risk standards associated with the attacks in these results.", alias="owaspStandards")
    sequential_id: Optional[StrictInt] = Field(default=None, description="This is a special ID used by the AI Defense CP to manage retries. It should not be used for any other purpose.", alias="sequentialId")
    severity: Optional[GenerativeSeverity] = None
    skipped_reason: Optional[StrictStr] = Field(default=None, description="Indicates that the test was skipped and provides a reason. If the test was not skipped this will be the empty string.", alias="skippedReason")
    test_run_id: Optional[ID] = Field(default=None, alias="testRunId")
    threat: Optional[Threat] = None
    total_num_prompts: Optional[StrictInt] = Field(default=None, description="The total number of prompts in this test run. Does not include prompts that were filtered out.", alias="totalNumPrompts")
    __properties: ClassVar[List[str]] = ["attackObjective", "attackTechnique", "example", "id", "mitreStandards", "nistStandards", "objectiveSubCategory", "owaspStandards", "sequentialId", "severity", "skippedReason", "testRunId", "threat", "totalNumPrompts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GenerativeValidationResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of example
        if self.example:
            _dict['example'] = self.example.to_dict()
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in mitre_standards (list)
        _items = []
        if self.mitre_standards:
            for _item in self.mitre_standards:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mitreStandards'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in nist_standards (list)
        _items = []
        if self.nist_standards:
            for _item in self.nist_standards:
                if _item:
                    _items.append(_item.to_dict())
            _dict['nistStandards'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in owasp_standards (list)
        _items = []
        if self.owasp_standards:
            for _item in self.owasp_standards:
                if _item:
                    _items.append(_item.to_dict())
            _dict['owaspStandards'] = _items
        # override the default output from pydantic by calling `to_dict()` of test_run_id
        if self.test_run_id:
            _dict['testRunId'] = self.test_run_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GenerativeValidationResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attackObjective": obj.get("attackObjective"),
            "attackTechnique": obj.get("attackTechnique"),
            "example": Example.from_dict(obj["example"]) if obj.get("example") is not None else None,
            "id": ID.from_dict(obj["id"]) if obj.get("id") is not None else None,
            "mitreStandards": [StandardInfo.from_dict(_item) for _item in obj["mitreStandards"]] if obj.get("mitreStandards") is not None else None,
            "nistStandards": [StandardInfo.from_dict(_item) for _item in obj["nistStandards"]] if obj.get("nistStandards") is not None else None,
            "objectiveSubCategory": obj.get("objectiveSubCategory"),
            "owaspStandards": [StandardInfo.from_dict(_item) for _item in obj["owaspStandards"]] if obj.get("owaspStandards") is not None else None,
            "sequentialId": obj.get("sequentialId"),
            "severity": obj.get("severity"),
            "skippedReason": obj.get("skippedReason"),
            "testRunId": ID.from_dict(obj["testRunId"]) if obj.get("testRunId") is not None else None,
            "threat": obj.get("threat"),
            "totalNumPrompts": obj.get("totalNumPrompts")
        })
        return _obj


