# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.generative_validation_config import GenerativeValidationConfig
from ri.apiclient.models.id import ID
from ri.apiclient.models.job_info import JobInfo
from typing import Optional, Set
from typing_extensions import Self

class GenerativeValidationTestRun(BaseModel):
    """
    GenerativeValidationTestRun are the details about a generative validation test run.
    """ # noqa: E501
    attempted_attacks: Optional[StrictInt] = Field(default=None, description="The number of attacks attempted.", alias="attemptedAttacks")
    config: Optional[GenerativeValidationConfig] = None
    id: Optional[ID] = None
    job_info: Optional[JobInfo] = Field(default=None, alias="jobInfo")
    name: Optional[StrictStr] = Field(default=None, description="A name of the test run.")
    successful_attacks: Optional[StrictInt] = Field(default=None, description="The number of successful attacks on the model.", alias="successfulAttacks")
    total_attacks: Optional[StrictInt] = Field(default=None, description="Total attacks run during the test.", alias="totalAttacks")
    workspace_id: Optional[ID] = Field(default=None, alias="workspaceId")
    __properties: ClassVar[List[str]] = ["attemptedAttacks", "config", "id", "jobInfo", "name", "successfulAttacks", "totalAttacks", "workspaceId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GenerativeValidationTestRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of job_info
        if self.job_info:
            _dict['jobInfo'] = self.job_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workspace_id
        if self.workspace_id:
            _dict['workspaceId'] = self.workspace_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GenerativeValidationTestRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attemptedAttacks": obj.get("attemptedAttacks"),
            "config": GenerativeValidationConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "id": ID.from_dict(obj["id"]) if obj.get("id") is not None else None,
            "jobInfo": JobInfo.from_dict(obj["jobInfo"]) if obj.get("jobInfo") is not None else None,
            "name": obj.get("name"),
            "successfulAttacks": obj.get("successfulAttacks"),
            "totalAttacks": obj.get("totalAttacks"),
            "workspaceId": ID.from_dict(obj["workspaceId"]) if obj.get("workspaceId") is not None else None
        })
        return _obj


